/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentForm;
import com.xebialabs.xlrelease.api.v1.views.BaseApplicationView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentReservationView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentReservationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentService;
import com.xebialabs.xlrelease.rest.AllCILevels;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/environments")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class EnvironmentApi
implements ApiService {
    private EnvironmentService environmentService;
    private EnvironmentSecurity environmentSecurity;
    private ApplicationService applicationService;
    private EnvironmentReservationService environmentReservationService;

    public String serviceName() {
        return "environmentApi";
    }

    @Autowired
    public EnvironmentApi(EnvironmentService environmentService, EnvironmentSecurity environmentSecurity, ApplicationService applicationService, EnvironmentReservationService environmentReservationService) {
        this.environmentService = environmentService;
        this.environmentSecurity = environmentSecurity;
        this.applicationService = applicationService;
        this.environmentReservationService = environmentReservationService;
    }

    @POST
    @Timed
    public EnvironmentView createEnvironment(EnvironmentForm environmentForm) {
        this.environmentSecurity.checkCreate();
        return EnvironmentView.fromEnvironment(this.environmentService.createEnvironment(environmentForm.toEnvironment()));
    }

    @GET
    @Timed
    @Path(value="/{environmentId:.*/Environment[^/]*}")
    public EnvironmentView getEnvironment(@PathParam(value="environmentId") String environmentId) {
        this.environmentSecurity.checkView();
        return EnvironmentView.fromEnvironment(this.environmentService.findEnvironmentById(environmentId));
    }

    @PUT
    @Timed
    @Path(value="/{environmentId:.*/Environment[^/]*}")
    public EnvironmentView updateEnvironment(@PathParam(value="environmentId") String environmentId, EnvironmentForm environmentForm) {
        this.environmentSecurity.checkEdit();
        Environment environment = environmentForm.toEnvironment();
        environment.setId(environmentId);
        return EnvironmentView.fromEnvironment(this.environmentService.updateEnvironment(environment));
    }

    @POST
    @Timed
    @Path(value="/search")
    public List<EnvironmentView> searchEnvironments(EnvironmentFilters environmentFilters) {
        this.environmentSecurity.checkView();
        return this.environmentService.searchEnvironments(environmentFilters).stream().map(EnvironmentView::fromEnvironment).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="/{environmentId:.*/Environment[^/]*}/reservations")
    public List<EnvironmentReservationView> getReservationsForEnvironment(@PathParam(value="environmentId") String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentReservationService.getReservationsByEnvironmentId(environmentId).stream().map(EnvironmentReservationView::fromEnvironmentReservation).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="/{environmentId:.*/Environment[^/]*}/applications")
    public List<BaseApplicationView> getDeployableApplicationsForEnvironment(@PathParam(value="environmentId") String environmentId) {
        this.environmentSecurity.checkView();
        return this.applicationService.getApplicationsDeployableOnEnvironment(environmentId).stream().map(BaseApplicationView::fromApplication).collect(Collectors.toList());
    }

    @DELETE
    @PublicApiMember
    @Timed
    @Path(value="/{environmentId:.*/Environment[^/]*}")
    public void delete(@PathParam(value="environmentId") String environmentId) {
        this.environmentSecurity.checkEdit();
        this.environmentService.deleteEnvironment(environmentId);
    }

    @PublicApiMember
    @Timed
    public Environment create(Environment environment) {
        this.environmentSecurity.checkCreate();
        return this.environmentService.createEnvironment(environment);
    }

    @PublicApiMember
    @Timed
    public Environment getById(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentService.findEnvironmentById(environmentId);
    }

    @PublicApiMember
    @Timed
    public Environment update(Environment environment) {
        this.environmentSecurity.checkEdit();
        return this.environmentService.updateEnvironment(environment);
    }

    @PublicApiMember
    @Timed
    public List<Environment> search(EnvironmentFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentService.searchEnvironments(filters);
    }

    @PublicApiMember
    @Timed
    public List<EnvironmentReservation> getReservations(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentReservationService.getReservationsByEnvironmentId(environmentId);
    }

    @PublicApiMember
    @Timed
    public List<Application> getDeployableApplications(String environmentId) {
        this.environmentSecurity.checkView();
        return this.applicationService.getApplicationsDeployableOnEnvironment(environmentId);
    }
}

