/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.client.ClusterClientReceptionist$;
import akka.cluster.client.ClusterReceptionist$;
import akka.cluster.client.ClusterReceptionistSettings$;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSub$;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.cluster.pubsub.DistributedPubSubMediator$Subscribe$;
import akka.cluster.pubsub.DistributedPubSubMediator$Unsubscribe$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uq!B\f\u0019\u0011\u0003yb!B\u0011\u0019\u0011\u0003\u0011\u0003\"\u0002\u001d\u0002\t\u0003Q\b\"B>\u0002\t\u0003b\bBB>\u0002\t\u0003\n\u0019\u0001\u0003\u0004\u0002\u000e\u0005!\tE\u001f\u0005\b\u0003\u001f\tA\u0011IA\t\r\u0011\t\u0003D\u0001\u0019\t\u0011Q:!\u0011!Q\u0001\nUBQ\u0001O\u0004\u0005\u0002eBqaO\u0004C\u0002\u0013%A\b\u0003\u0004G\u000f\u0001\u0006I!\u0010\u0005\b\u000f\u001e\u0011\r\u0011\"\u0003I\u0011\u00199v\u0001)A\u0005\u0013\")\u0001l\u0002C\u00013\")Ql\u0002C\u0005=\")!m\u0002C\u0001G\")\u0001n\u0002C\u0001S\")1n\u0002C\u0001Y\")\u0001o\u0002C\u0001c\"9Ao\u0002b\u0001\n\u0013q\u0006BB;\bA\u0003%q\fC\u0003w\u000f\u0011\u0005a,A\rDYV\u001cH/\u001a:DY&,g\u000e\u001e*fG\u0016\u0004H/[8oSN$(BA\r\u001b\u0003\u0019\u0019G.[3oi*\u00111\u0004H\u0001\bG2,8\u000f^3s\u0015\u0005i\u0012\u0001B1lW\u0006\u001c\u0001\u0001\u0005\u0002!\u00035\t\u0001DA\rDYV\u001cH/\u001a:DY&,g\u000e\u001e*fG\u0016\u0004H/[8oSN$8\u0003B\u0001$S]\u0004\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007c\u0001\u0016._5\t1F\u0003\u0002-9\u0005)\u0011m\u0019;pe&\u0011af\u000b\u0002\f\u000bb$XM\\:j_:LE\r\u0005\u0002!\u000fM\u0019qaI\u0019\u0011\u0005)\u0012\u0014BA\u001a,\u0005%)\u0005\u0010^3og&|g.\u0001\u0004tsN$X-\u001c\t\u0003UYJ!aN\u0016\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\ty#\bC\u00035\u0013\u0001\u0007Q'\u0001\u0004d_:4\u0017nZ\u000b\u0002{A\u0011a\bR\u0007\u0002\u007f)\u00111\b\u0011\u0006\u0003\u0003\n\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0007\u0006\u00191m\\7\n\u0005\u0015{$AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\tI|G.Z\u000b\u0002\u0013B\u0019AE\u0013'\n\u0005-+#AB(qi&|g\u000e\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001f\u0016j\u0011\u0001\u0015\u0006\u0003#z\ta\u0001\u0010:p_Rt\u0014BA*&\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M+\u0013!\u0002:pY\u0016\u0004\u0013\u0001D5t)\u0016\u0014X.\u001b8bi\u0016$W#\u0001.\u0011\u0005\u0011Z\u0016B\u0001/&\u0005\u001d\u0011un\u001c7fC:\fa\u0002];c'V\u0014W*\u001a3jCR|'/F\u0001`!\tQ\u0003-\u0003\u0002bW\tA\u0011i\u0019;peJ+g-A\bsK\u001eL7\u000f^3s'\u0016\u0014h/[2f)\t!w\r\u0005\u0002%K&\u0011a-\n\u0002\u0005+:LG\u000fC\u0003-!\u0001\u0007q,A\tv]J,w-[:uKJ\u001cVM\u001d<jG\u0016$\"\u0001\u001a6\t\u000b1\n\u0002\u0019A0\u0002%I,w-[:uKJ\u001cVOY:de&\u0014WM\u001d\u000b\u0004I6|\u0007\"\u00028\u0013\u0001\u0004a\u0015!\u0002;pa&\u001c\u0007\"\u0002\u0017\u0013\u0001\u0004y\u0016\u0001F;oe\u0016<\u0017n\u001d;feN+(m]2sS\n,'\u000fF\u0002eeNDQA\\\nA\u00021CQ\u0001L\nA\u0002}\u000bAB]3dKB$\u0018n\u001c8jgR\fQB]3dKB$\u0018n\u001c8jgR\u0004\u0013AC;oI\u0016\u0014H._5oOB\u0011!\u0006_\u0005\u0003s.\u00121#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012aH\u0001\u0004O\u0016$HCA\u0018~\u0011\u0015!4\u00011\u0001\u007f!\tQs0C\u0002\u0002\u0002-\u00121\"Q2u_J\u001c\u0016p\u001d;f[R\u0019q&!\u0002\t\rQ\"\u0001\u0019AA\u0004!\rQ\u0013\u0011B\u0005\u0004\u0003\u0017Y#AG\"mCN\u001c\u0018nY!di>\u00148+_:uK6\u0004&o\u001c<jI\u0016\u0014\u0018A\u00027p_.,\b/A\bde\u0016\fG/Z#yi\u0016t7/[8o)\ry\u00131\u0003\u0005\u0006i\u0019\u0001\r!\u000e")
public final class ClusterClientReceptionist
implements Extension {
    private final ExtendedActorSystem system;
    private final Config config;
    private final Option<String> role;
    private final ActorRef receptionist;

    public static ClusterClientReceptionist createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterClientReceptionist$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterClientReceptionist$ lookup() {
        return ClusterClientReceptionist$.MODULE$.lookup();
    }

    public static ClusterClientReceptionist get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterClientReceptionist$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterClientReceptionist get(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterClientReceptionist$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.apply(actorSystem);
    }

    private Config config() {
        return this.config;
    }

    private Option<String> role() {
        return this.role;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminated() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).isTerminated()) return true;
        Set set = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).selfRoles();
        if (this.role().forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)))) return false;
        return true;
    }

    private ActorRef pubSubMediator() {
        return ((DistributedPubSub)DistributedPubSub$.MODULE$.apply((ActorSystem)this.system)).mediator();
    }

    public void registerService(ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Put x$1 = new DistributedPubSubMediator.Put(actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void unregisterService(ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Remove x$1 = new DistributedPubSubMediator.Remove(actor.path().toStringWithoutAddress());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void registerSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Subscribe x$1 = DistributedPubSubMediator$Subscribe$.MODULE$.apply(topic, actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void unregisterSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Unsubscribe x$1 = DistributedPubSubMediator$Unsubscribe$.MODULE$.apply(topic, actor);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    private ActorRef receptionist() {
        return this.receptionist;
    }

    public ActorRef underlying() {
        return this.receptionist();
    }

    public ClusterClientReceptionist(ExtendedActorSystem system) {
        ActorRef actorRef;
        this.system = system;
        this.config = system.settings().config().getConfig("akka.cluster.client.receptionist");
        String string = this.config().getString("role");
        Object object = "".equals(string) ? None$.MODULE$ : new Some((Object)string);
        this.role = object;
        if (this.isTerminated()) {
            actorRef = system.deadLetters();
        } else {
            String name = this.config().getString("name");
            String string2 = this.config().getString("use-dispatcher");
            String string3 = "".equals(string2) ? "akka.actor.default-dispatcher" : string2;
            String dispatcher = string3;
            ActorRef mediator = this.pubSubMediator();
            actorRef = system.systemActorOf(ClusterReceptionist$.MODULE$.props(mediator, ClusterReceptionistSettings$.MODULE$.apply(this.config())).withDispatcher(dispatcher), name);
        }
        this.receptionist = actorRef;
    }
}

