/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingExecutionOutputHandler
implements OverthereExecutionOutputHandler,
Closeable {
    private final Function<String, Object> onFlushCallback;
    private final boolean resetBufferOnFlush;
    private final StringBuilder buffer;
    private final ScheduledFuture<?> cancelHandle;
    private static final Logger logger = LoggerFactory.getLogger(PollingExecutionOutputHandler.class);

    protected PollingExecutionOutputHandler(Scheduler scheduler, Function<String, Object> onFlushCallback, boolean resetBufferOnFlush, long initialDelay, long delay) {
        this.onFlushCallback = onFlushCallback;
        this.resetBufferOnFlush = resetBufferOnFlush;
        this.buffer = new StringBuilder();
        TimerTask flushTimerTask = new TimerTask(){

            @Override
            public void run() {
                PollingExecutionOutputHandler.this.flush();
            }
        };
        this.cancelHandle = scheduler.scheduleAtFixedRate(flushTimerTask, initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        String output;
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            output = this.buffer.toString();
            if (this.resetBufferOnFlush && this.buffer.length() > 0) {
                this.buffer.setLength(0);
            }
        }
        if (!Strings.isBlank((String)output)) {
            logger.debug("Flushing buffered content to callback:\n{}", (Object)output);
            this.onFlushCallback.apply(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleChar(char c) {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.buffer.append(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLine(String line) {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.buffer.append(line);
        }
    }

    @Override
    public void close() throws IOException {
        logger.debug("Shutdown polling timer thread");
        this.cancelHandle.cancel(true);
        logger.debug("Flushing content still present in buffer...");
        this.flush();
    }

    public static PollingExecutionOutputHandler pollingHandler(Scheduler scheduler, Function<String, Object> onFlushCallback, boolean resetBufferOnFlush, long initialDelay, long delay) {
        return new PollingExecutionOutputHandler(scheduler, onFlushCallback, resetBufferOnFlush, initialDelay, delay);
    }
}

