/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.CloseableUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001B\f\u0019\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005e!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003:\u0011!i\u0004A!b\u0001\n\u0003q\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\u0019\u0003!Q1A\u0005\u0002\u001dC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0019\u0002\u0011)\u0019!C\u0001\u001b\"A\u0011\u000b\u0001B\u0001B\u0003%a\n\u0003\u0005S\u0001\t\u0015\r\u0011\"\u0001T\u0011!9\u0006A!A!\u0002\u0013!\u0006\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011A-\t\u0011\u0001\u0004!\u0011!Q\u0001\niCQ!\u0019\u0001\u0005\u0002\tDQA\u001f\u0001\u0005\u0002mDq!a\r\u0001\t\u0013\t)\u0004C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAA\u0001\u0011E\u00111\u0011\u0005\b\u0003\u0017\u0003A\u0011BAG\u0005Y\u0019\u0005.\u00198hK\u0016CXmY;uS>t7+\u001a:wS\u000e,'BA\r\u001b\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0007\u000f\u0002\u0013ad'/\u001a7fCN,'BA\u000f\u001f\u0003%AXMY5bY\u0006\u00147OC\u0001 \u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013!B:mMRR'\"A\u0017\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\f\u0016\u0003\u000f1{wmZ5oO\u0006q1m\\7nK:$8+\u001a:wS\u000e,W#\u0001\u001a\u0011\u0005M\"T\"\u0001\r\n\u0005UB\"AD\"p[6,g\u000e^*feZL7-Z\u0001\u0010G>lW.\u001a8u'\u0016\u0014h/[2fA\u0005\t\u0012\r\u001e;bG\"lWM\u001c;TKJ4\u0018nY3\u0016\u0003e\u0002\"a\r\u001e\n\u0005mB\"!E!ui\u0006\u001c\u0007.\\3oiN+'O^5dK\u0006\u0011\u0012\r\u001e;bG\"lWM\u001c;TKJ4\u0018nY3!\u00039!\u0018m]6SKB|7/\u001b;pef,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005j\t!B]3q_NLGo\u001c:z\u0013\t!\u0015I\u0001\bUCN\\'+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b*fa>\u001c\u0018\u000e^8ss\u0002\nA#\u0019;uC\u000eDW.\u001a8u%\u0016\u0004xn]5u_JLX#\u0001%\u0011\u0005\u0001K\u0015B\u0001&B\u0005Q\tE\u000f^1dQ6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u0006)\u0012\r\u001e;bG\"lWM\u001c;SKB|7/\u001b;pef\u0004\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\ta\n\u0005\u0002A\u001f&\u0011\u0001+\u0011\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195feV\tA\u000b\u0005\u0002A+&\u0011a+\u0011\u0002\u001a\r\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'/\u0001\u000egC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014\b%\u0001\u0005fm\u0016tGOQ;t+\u0005Q\u0006CA._\u001b\u0005a&BA/\u001b\u0003\u0019)g/\u001a8ug&\u0011q\f\u0018\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u0003\u0019a\u0014N\\5u}QA1\rZ3gO\"L'\u000e\u0005\u00024\u0001!)\u0001g\u0004a\u0001e!)qg\u0004a\u0001s!)Qh\u0004a\u0001\u007f!)ai\u0004a\u0001\u0011\")Aj\u0004a\u0001\u001d\")!k\u0004a\u0001)\")\u0001l\u0004a\u00015\"\u0012q\u0002\u001c\t\u0003[bl\u0011A\u001c\u0006\u0003_B\f!\"\u00198o_R\fG/[8o\u0015\t\t(/A\u0004gC\u000e$xN]=\u000b\u0005M$\u0018!\u00022fC:\u001c(BA;w\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A<\u0002\u0007=\u0014x-\u0003\u0002z]\nI\u0011)\u001e;po&\u0014X\rZ\u0001\rCB\u0004H._\"iC:<Wm\u001d\u000b\u0005y~\fy\u0001\u0005\u0002${&\u0011a\u0010\n\u0002\u0005+:LG\u000fC\u0004\u0002\u0002A\u0001\r!a\u0001\u0002\u000f\rD\u0017M\\4fgB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\ni\ta\u0001Z8nC&t\u0017\u0002BA\u0007\u0003\u000f\u0011qa\u00115b]\u001e,7\u000fC\u0004\u0002\u0012A\u0001\r!a\u0005\u0002\tU\u001cXM\u001d\t\u0005\u0003+\tI\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0003\u000e\n\t\u0005m\u0011q\u0003\u0002\u0005+N,'\u000fK\u0002\u0011\u0003?\u0001B!!\t\u000205\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0006ue\u0006t7/Y2uS>t'\u0002BA\u0015\u0003W\t1a]9m\u0015\r\tiCG\u0001\u0003I\nLA!!\r\u0002$\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG.A\u0007qe>\u001cWm]:GC\u000e,Go\u001d\u000b\u0004y\u0006]\u0002bBA\u0001#\u0001\u0007\u00111A\u0001\u0010aJ|7-Z:t%\u0016dW-Y:fgR\u0019A0!\u0010\t\u000f\u0005\u0005!\u00031\u0001\u0002\u0004\u0005y1m\u001c7mK\u000e$8i\\7nK:$8\u000f\u0006\u0004\u0002D\u0005]\u0014\u0011\u0010\t\t\u0003\u000b\n\u0019&!\u0017\u0002`9!\u0011qIA(!\r\tI\u0005J\u0007\u0003\u0003\u0017R1!!\u0014!\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u000b\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t)&a\u0016\u0003\u00075\u000b\u0007OC\u0002\u0002R\u0011\u0002B!!\u0002\u0002\\%!\u0011QLA\u0004\u0005\u0011!\u0016m]6\u0011\r\u0005\u0005\u00141NA9\u001d\u0011\t\u0019'a\u001a\u000f\t\u0005%\u0013QM\u0005\u0002K%\u0019\u0011\u0011\u000e\u0013\u0002\u000fA\f7m[1hK&!\u0011QNA8\u0005\r\u0019V-\u001d\u0006\u0004\u0003S\"\u0003\u0003BA\u0003\u0003gJA!!\u001e\u0002\b\t91i\\7nK:$\bbBA\u0001'\u0001\u0007\u00111\u0001\u0005\b\u0003#\u0019\u0002\u0019AA\n\u0003I\u0001(o\\2fgN\fE\u000f^1dQ6,g\u000e^:\u0015\u0007q\fy\bC\u0004\u0002\u0002Q\u0001\r!a\u0001\u0002\u001fA\u0014xnY3tg\u000e{W.\\3oiN$R\u0001`AC\u0003\u0013Cq!a\"\u0016\u0001\u0004\t\u0019%\u0001\bd_6lWM\u001c;t\u0005f$\u0016m]6\t\u000f\u0005EQ\u00031\u0001\u0002\u0014\u0005a\u0001O]8dKN\u001cH+Y:lgR\u0019A0a$\t\u000f\u0005\u0005a\u00031\u0001\u0002\u0004!\u001a\u0001!a%\u0011\t\u0005U\u00151T\u0007\u0003\u0003/S1!!'u\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003;\u000b9JA\u0004TKJ4\u0018nY3")
public class ChangeExecutionService
implements Logging {
    private final CommentService commentService;
    private final AttachmentService attachmentService;
    private final TaskRepository taskRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseRepository releaseRepository;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ChangeExecutionService changeExecutionService = this;
        synchronized (changeExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public CommentService commentService() {
        return this.commentService;
    }

    public AttachmentService attachmentService() {
        return this.attachmentService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public AttachmentRepository attachmentRepository() {
        return this.attachmentRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @IsTransactional
    public void applyChanges(Changes changes, User user) {
        this.processFacets(changes);
        this.processAttachments(changes);
        this.processComments(this.collectComments(changes, user), user);
        this.processTasks(changes);
        this.processReleases(changes);
    }

    private void processFacets(Changes changes) {
        Set facets = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processFacets$1(x$1)))).map((Function1 & Serializable)x$2 -> (Facet)x$2)).toSet();
        facets.foreach((Function1 & Serializable)facet -> ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher().liveRepository())).update((Facet)facet));
    }

    private void processReleases(Changes changes) {
        Set releases = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processReleases$1(x$3)))).map((Function1 & Serializable)x$4 -> ((PlanItem)x$4).getRelease())).toSet();
        releases.foreach((Function1 & Serializable)release -> this.releaseRepository().update((Release)release));
    }

    private Map<Task, Seq<Comment>> collectComments(Changes changes, User user) {
        return CollectionConverters$.MODULE$.MapHasAsScala(changes.getCommentsByTask().asMap()).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task task = (Task)tuple2._1();
            Collection commentTexts = (Collection)tuple2._2();
            Seq userComments = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(commentTexts).asScala().map((Function1 & Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                User u = (User)tuple3._1();
                String text = (String)tuple3._2();
                DateTime date = (DateTime)tuple3._3();
                User actualUser = (User)Option$.MODULE$.apply((Object)u).getOrElse((Function0 & Serializable)() -> user);
                Comment comment = this.commentService().buildComment(task, text, actualUser.getName(), date.toDate(), CommentService.COMMENT_PREFIX_MANUAL, CommentService.COMMENT_SUFFIX);
                return comment;
            })).toSeq();
            Tuple2 tuple22 = new Tuple2((Object)task, (Object)userComments);
            return tuple22;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void processAttachments(Changes changes) {
        CollectionConverters$.MODULE$.MapHasAsScala(changes.getAttachmentsByTask().asMap()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processAttachments$1(this, changes, x0$1);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.MapHasAsScala(changes.getLinkedAttachments().asMap()).asScala().foreach((Function1 & Serializable)x0$2 -> {
            ChangeExecutionService.$anonfun$processAttachments$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void processComments(Map<Task, Seq<Comment>> commentsByTask, User user) {
        commentsByTask.foreach((Function1 & Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processComments$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void processTasks(Changes changes) {
        Set tasks = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processTasks$1(x$5)))).map((Function1 & Serializable)x$6 -> (Task)x$6)).toSet();
        tasks.foreach((Function1 & Serializable)task -> {
            ChangeExecutionService.$anonfun$processTasks$3(this, task);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$processFacets$1(ConfigurationItem x$1) {
        return x$1 instanceof Facet;
    }

    public static final /* synthetic */ boolean $anonfun$processReleases$1(ConfigurationItem x$3) {
        return x$3 instanceof PlanItem;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$3(ChangeExecutionService $this, Task task$2, Attachment attachment$1, Changes changes$1, InputStream is) {
        Boolean bl;
        Attachment attachmentAttached = $this.attachmentService().attachToRelease(task$2.getRelease(), attachment$1.getFile().getName(), attachment$1.getContentType(), is);
        if ($this.attachmentRepository().batchInsert(task$2.getRelease(), (Seq<Attachment>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attachment[]{attachmentAttached}))))) {
            task$2.getAttachments().add(attachmentAttached);
            $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$2.getId(), attachmentAttached));
            bl = BoxedUnit.UNIT;
        } else {
            changes$1.addComment(task$2, User.LOG_OUTPUT, "There was a problem adding the attachment. See xl-release.log");
            bl = BoxesRunTime.boxToBoolean((boolean)task$2.getRelease().getAttachments().remove(attachmentAttached));
        }
        changes$1.update((ConfigurationItem)task$2.getRelease());
    }

    public static final /* synthetic */ void $anonfun$processAttachments$1(ChangeExecutionService $this, Changes changes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Collection attachments = (Collection)tuple2._2();
        CollectionConverters$.MODULE$.CollectionHasAsScala(attachments).asScala().foreach((Function1 & Serializable)attachment -> {
            CloseableUtils$.MODULE$.using(attachment.getFile().getInputStream(), (Function1 & Serializable)is -> {
                ChangeExecutionService.$anonfun$processAttachments$3($this, task$2, attachment, changes$1, is);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$5(ChangeExecutionService $this, Task task$3, Attachment attachment) {
        Attachment loadedAttachment = $this.attachmentRepository().findById(attachment.getId());
        attachment.setFile(loadedAttachment.getFile());
        $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$3.getId(), attachment));
    }

    public static final /* synthetic */ void $anonfun$processAttachments$4(ChangeExecutionService $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Collection attachments = (Collection)tuple2._2();
        CollectionConverters$.MODULE$.CollectionHasAsScala(attachments).asScala().foreach((Function1 & Serializable)attachment -> {
            ChangeExecutionService.$anonfun$processAttachments$5($this, task, attachment);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processComments$1(ChangeExecutionService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Seq comments = (Seq)tuple2._2();
        comments.foreach((Function1 & Serializable)comment -> $this.commentService().create(task, (Comment)comment));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$processTasks$1(ConfigurationItem x$5) {
        return x$5 instanceof Task;
    }

    public static final /* synthetic */ void $anonfun$processTasks$3(ChangeExecutionService $this, Task task) {
        $this.taskRepository().updateTaskProperties(task);
    }

    @Autowired
    public ChangeExecutionService(CommentService commentService, AttachmentService attachmentService, TaskRepository taskRepository, AttachmentRepository attachmentRepository, ReleaseRepository releaseRepository, FacetRepositoryDispatcher facetRepositoryDispatcher, XLReleaseEventBus eventBus) {
        this.commentService = commentService;
        this.attachmentService = attachmentService;
        this.taskRepository = taskRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseRepository = releaseRepository;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

