/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Project;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;
import liquibase.ui.UIService;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class RegisterChangeLogCommand
extends AbstractSelfConfiguratingCommand<CommandResult> {
    private PrintStream outputStream = System.out;
    private HubChangeLog hubChangeLog;
    private String changeLogFile;
    private Map<String, Object> argsMap = new HashMap<String, Object>();
    private UUID hubProjectId;

    public HubChangeLog getHubChangeLog() {
        return this.hubChangeLog;
    }

    public void setHubProjectId(UUID hubProjectId) {
        this.hubProjectId = hubProjectId;
    }

    @Override
    public void configure(Map<String, Object> argsMap) throws LiquibaseException {
        this.argsMap = argsMap;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    @Override
    public String getName() {
        return "registerChangeLog";
    }

    @Override
    public CommandValidationErrors validate() {
        return null;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandResult run() throws Exception {
        String changeLogId;
        HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        if (!hubServiceFactory.isOnline()) {
            return new CommandResult("The command registerChangeLog requires access to Liquibase Hub: " + hubServiceFactory.getOfflineReason() + ".  Learn more at https://hub.liquibase.com", false);
        }
        HubService service = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)this.argsMap.get("changeLog");
        String string = changeLogId = databaseChangeLog != null ? databaseChangeLog.getChangeLogId() : null;
        if (changeLogId != null) {
            this.hubChangeLog = service.getHubChangeLog(UUID.fromString(changeLogId));
            if (this.hubChangeLog != null) {
                return new CommandResult("Changelog '" + this.changeLogFile + "' is already registered with changeLogId '" + changeLogId + "' to project '" + this.hubChangeLog.getProject().getName() + "' with project ID '" + this.hubChangeLog.getProject().getId().toString() + "'.\nFor more information visit https://docs.liquibase.com.", false);
            }
            return new CommandResult("Changelog '" + this.changeLogFile + "' is already registered with changeLogId '" + changeLogId + "'.\nFor more information visit https://docs.liquibase.com.", false);
        }
        Project project = null;
        if (this.hubProjectId != null) {
            project = service.getProject(this.hubProjectId);
            if (project == null) {
                return new CommandResult("Project Id '" + this.hubProjectId + "' does not exist or you do not have access to it", false);
            }
        } else {
            List<Project> projects = this.getProjectsFromHub();
            boolean done = false;
            String input = null;
            while (!done) {
                input = this.readProjectFromConsole(projects);
                try {
                    if (input.equalsIgnoreCase("C")) {
                        String projectName = this.readProjectNameFromConsole();
                        if (StringUtil.isEmpty(projectName)) {
                            this.outputStream.print("\nNo project created\n\n");
                            continue;
                        }
                        if (projectName.length() > 255) {
                            this.outputStream.print("\nThe project name you entered is longer than 255 characters\n\n");
                            continue;
                        }
                        project = service.createProject(new Project().setName(projectName));
                        if (project == null) {
                            return new CommandResult("\nUnable to create project '" + projectName + "'.\n\n", false);
                        }
                        this.outputStream.print("\nProject '" + project.getName() + "' created with project ID '" + project.getId() + "'.\n\n");
                        projects = this.getProjectsFromHub();
                        done = true;
                        continue;
                    }
                    if (input.equalsIgnoreCase("N")) {
                        return new CommandResult("Your changelog " + this.changeLogFile + " was not registered to any Liquibase Hub project. You can still run Liquibase commands, but no data will be saved in your Liquibase Hub account for monitoring or reports.  Learn more at https://hub.liquibase.com.", false);
                    }
                    int projectIdx = Integer.parseInt(input);
                    if (projectIdx > 0 && projectIdx <= projects.size()) {
                        project = projects.get(projectIdx - 1);
                        if (project == null) continue;
                        done = true;
                        continue;
                    }
                    this.outputStream.printf("\nInvalid project '%d' selected\n\n", projectIdx);
                }
                catch (NumberFormatException nfe) {
                    this.outputStream.printf("\nInvalid selection '" + input + "'\n\n", new Object[0]);
                }
            }
        }
        HubChangeLog newChangeLog = new HubChangeLog();
        newChangeLog.setProject(project);
        newChangeLog.setFileName(databaseChangeLog.getFilePath());
        newChangeLog.setName(databaseChangeLog.getFilePath());
        this.hubChangeLog = service.createChangeLog(newChangeLog);
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        try (InputStreamList list = null;){
            list = resourceAccessor.openStreams("", this.changeLogFile);
            List<URI> uris = list.getURIs();
            InputStream is2 = list.iterator().next();
            String encoding = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding();
            String changeLogString = StreamUtil.readStreamAsString(is2, encoding);
            if (this.changeLogFile.toLowerCase().endsWith(".xml")) {
                String patternString = "(?ms).*<databaseChangeLog[^>]*>";
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(changeLogString);
                if (matcher.find()) {
                    String header = changeLogString.substring(matcher.start(), matcher.end() - 1);
                    String xsdPatternString = "([dbchangelog|liquibase-pro])-3.[0-9]?[0-9]?.xsd";
                    Pattern xsdPattern = Pattern.compile(xsdPatternString);
                    Matcher xsdMatcher = xsdPattern.matcher(header);
                    String editedString = xsdMatcher.replaceAll("$1-" + XMLChangeLogSAXParser.getSchemaVersion() + ".xsd");
                    String outputChangeLogString = " changeLogId=\"" + this.hubChangeLog.getId().toString() + "\"";
                    if (changeLogString.trim().endsWith("/>")) {
                        changeLogString = changeLogString.replaceFirst("/>", outputChangeLogString + "/>");
                    } else {
                        String outputHeader = editedString + outputChangeLogString + ">";
                        changeLogString = changeLogString.replaceFirst(patternString, outputHeader);
                    }
                }
            } else if (this.changeLogFile.toLowerCase().endsWith(".sql")) {
                String newChangeLogString = changeLogString.replaceFirst("--(\\s*)liquibase formatted sql", "-- liquibase formatted sql changeLogId:" + this.hubChangeLog.getId().toString());
                if (newChangeLogString.equals(changeLogString)) {
                    CommandResult pattern = new CommandResult("Unable to update changeLogId in changelog file '" + this.changeLogFile + "'", false);
                    return pattern;
                }
                changeLogString = newChangeLogString;
            } else if (this.changeLogFile.toLowerCase().endsWith(".json")) {
                changeLogString = changeLogString.replaceFirst("\\[", "\\[\n\"changeLogId\":\"" + this.hubChangeLog.getId().toString() + "\",\n");
            } else if (this.changeLogFile.toLowerCase().endsWith(".yml") || this.changeLogFile.toLowerCase().endsWith(".yaml")) {
                changeLogString = changeLogString.replaceFirst("^databaseChangeLog:(\\s*)\n", "databaseChangeLog:$1\n- changeLogId: " + this.hubChangeLog.getId().toString() + "$1\n");
            } else {
                CommandResult newChangeLogString = new CommandResult("Changelog file '" + this.changeLogFile + "' is not a supported format", false);
                return newChangeLogString;
            }
            File f2 = new File(uris.get(0).getPath());
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(f2, "rw");){
                randomAccessFile.write(changeLogString.getBytes(encoding));
            }
            databaseChangeLog.setChangeLogId(this.hubChangeLog.getId().toString());
            CommandResult commandResult = new CommandResult("* Changelog file '" + this.changeLogFile + "' registered with changelog ID '" + this.hubChangeLog.getId() + "' to project '" + project.getName() + "'\n", true);
            return commandResult;
        }
    }

    private List<Project> getProjectsFromHub() throws LiquibaseHubException {
        HubService service = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        List<Project> projects = service.getProjects();
        Collections.sort(projects, new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                Date date1 = o1.getCreateDate();
                Date date2 = o2.getCreateDate();
                return date2.compareTo(date1);
            }
        });
        return projects;
    }

    private String readProjectNameFromConsole() throws CommandLineParsingException {
        UIService ui = Scope.getCurrentScope().getUI();
        HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        String hubUrl = hubConfiguration.getLiquibaseHubUrl();
        String input = ui.prompt("Please enter your Project name and press [enter].  This is editable in your Liquibase Hub account at " + hubUrl, null, null, String.class);
        return StringUtil.trimToEmpty(input);
    }

    private String readProjectFromConsole(List<Project> projects) throws CommandLineParsingException {
        UIService ui = Scope.getCurrentScope().getUI();
        StringBuilder prompt = new StringBuilder("Registering a changelog connects Liquibase operations to a Project for monitoring and reporting.\n");
        prompt.append("Register changelog " + this.changeLogFile + " to an existing Project, or create a new one.\n");
        prompt.append("Please make a selection:\n");
        prompt.append("[c] Create new Project\n");
        String projFormat = "[%d]";
        if (projects.size() >= 10 && projects.size() < 100) {
            projFormat = "[%2d]";
        } else if (projects.size() >= 100 && projects.size() < 1000) {
            projFormat = "[%3d]";
        } else if (projects.size() >= 1000 && projects.size() < 10000) {
            projFormat = "[%4d]";
        }
        int maxLen = 40;
        for (Project project : projects) {
            if (project.getName() == null || project.getName().length() <= maxLen) continue;
            maxLen = project.getName().length();
        }
        for (int i2 = 0; i2 < projects.size(); ++i2) {
            Project project;
            project = projects.get(i2);
            prompt.append(String.format(projFormat + " %-" + maxLen + "s (Project ID:%s) %s\n", i2 + 1, project.getName(), projects.get(i2).getId(), projects.get(i2).getCreateDate()));
        }
        prompt.append("[N] to not register this changelog right now.\nYou can still run Liquibase commands, but no data will be saved in your Liquibase Hub account for monitoring or reports.\n Learn more at https://hub.liquibase.com.\n?");
        return StringUtil.trimToEmpty(ui.prompt(prompt.toString(), "N", null, String.class));
    }
}

