/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.search;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.search.SearchResultProperty;
import org.apache.jackrabbit.webdav.search.QueryGrammerSet;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.search.SearchResource;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResourceImpl
implements SearchResource {
    private static Logger log = LoggerFactory.getLogger((Class)SearchResourceImpl.class);
    private final JcrDavSession session;
    private final DavResourceLocator locator;

    public SearchResourceImpl(DavResourceLocator locator, JcrDavSession session) {
        this.session = session;
        this.locator = locator;
    }

    public QueryGrammerSet getQueryGrammerSet() {
        QueryGrammerSet qgs = new QueryGrammerSet();
        try {
            QueryManager qMgr = this.getRepositorySession().getWorkspace().getQueryManager();
            String[] langs = qMgr.getSupportedQueryLanguages();
            for (int i = 0; i < langs.length; ++i) {
                qgs.addQueryLanguage(langs[i], Namespace.EMPTY_NAMESPACE);
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return qgs;
    }

    public MultiStatus search(SearchInfo sInfo) throws DavException {
        try {
            Query q = this.getQuery(sInfo);
            QueryResult qR = q.execute();
            return this.queryResultToMultiStatus(qR);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query getQuery(SearchInfo sInfo) throws InvalidQueryException, RepositoryException, DavException {
        Query q;
        Node qNode;
        String qNodeRelPath;
        Session session = this.getRepositorySession();
        NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
        Node rootNode = session.getRootNode();
        QueryManager qMgr = this.getRepositorySession().getWorkspace().getQueryManager();
        String itemPath = this.locator.getRepositoryPath();
        if (itemPath != null && !rootNode.getPath().equals(itemPath) && rootNode.hasNode(qNodeRelPath = itemPath.substring(1)) && (qNode = rootNode.getNode(qNodeRelPath)).isNodeType("nt:query")) {
            return qMgr.getQuery(qNode);
        }
        if (sInfo != null) {
            Iterator<Object> it;
            Map namespaces = sInfo.getNamespaces();
            try {
                it = namespaces.keySet().iterator();
                while (it.hasNext()) {
                    String prefix = (String)it.next();
                    String uri = (String)namespaces.get(prefix);
                    session.setNamespacePrefix(prefix, uri);
                }
                q = qMgr.createQuery(sInfo.getQuery(), sInfo.getLanguageName());
            }
            finally {
                it = namespaces.values().iterator();
                while (it.hasNext()) {
                    String uri = (String)it.next();
                    try {
                        session.setNamespacePrefix(nsReg.getPrefix(uri), uri);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to reset mapping of namespace: " + uri);
                    }
                }
            }
        } else {
            throw new DavException(400, this.locator.getResourcePath() + " is not a nt:query node -> searchRequest body required.");
        }
        if (itemPath != null && !this.getRepositorySession().itemExists(itemPath)) {
            try {
                q.storeAsNode(itemPath);
            }
            catch (RepositoryException e) {
                new JcrDavException(e);
            }
        }
        return q;
    }

    private MultiStatus queryResultToMultiStatus(QueryResult qResult) throws RepositoryException {
        MultiStatus ms = new MultiStatus();
        String[] columnNames = qResult.getColumnNames();
        StringBuffer responseDescription = new StringBuffer();
        String delim = "";
        for (int i = 0; i < columnNames.length; ++i) {
            responseDescription.append(delim);
            responseDescription.append(ISO9075.encode(columnNames[i]));
            delim = " ";
        }
        ms.setResponseDescription(responseDescription.toString());
        RowIterator rowIter = qResult.getRows();
        while (rowIter.hasNext()) {
            Row row = rowIter.nextRow();
            Value[] values = row.getValues();
            String itemPath = row.getValue("jcr:path").getString();
            DavResourceLocator loc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), itemPath, false);
            String href = loc.getHref(true);
            MultiStatusResponse resp = new MultiStatusResponse(href, null);
            SearchResultProperty srp = new SearchResultProperty(columnNames, values);
            resp.add(srp);
            ms.addResponse(resp);
        }
        return ms;
    }

    private Session getRepositorySession() {
        return this.session.getRepositorySession();
    }
}

