/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.notifications.TriggerType$;
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings;
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings;
import com.xebialabs.xlrelease.notifications.email.EmailNotificationsService;
import com.xebialabs.xlrelease.notifications.views.EmailNotificationSettingsView;
import com.xebialabs.xlrelease.notifications.views.EmailPreviewView;
import com.xebialabs.xlrelease.notifications.views.converters.EmailNotificationSettingsConverter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import scala.reflect.ScalaSignature;

@Path(value="/settings/notifications")
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001B\t\u0013\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rm\u0003\u0001\u0015!\u0003T\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u00151\b\u0001\"\u0001x\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002B\u0002/\u0001\t\u0003\ti\u0006C\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"1a\u000f\u0001C\u0001\u0003WCaa \u0001\u0005\u0002\u0005}\u0006bBAi\u0001\u0011\u0005\u00111\u001b\u0002\u0016\u001d>$\u0018NZ5dCRLwN\\:SKN|WO]2f\u0015\t\u0019B#\u0001\u0005j]R,'O\\1m\u0015\t)b#A\u0002ba&T!a\u0006\r\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\tI\"$A\u0005yYJ,G.Z1tK*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017!G3nC&dgj\u001c;jM&\u001c\u0017\r^5p]N\u001cVM\u001d<jG\u0016\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\f\u0002\u000b\u0015l\u0017-\u001b7\n\u00051J#!G#nC&dgj\u001c;jM&\u001c\u0017\r^5p]N\u001cVM\u001d<jG\u0016\f1\u0002]3s[&\u001c8/[8ogB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007G\u0001\tg\u0016\u001cWO]5us&\u00111\u0007\r\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\u0018aE:feZ,'oQ8oM&<WO]1uS>t\u0007C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u001b\u0003!!W\r\u001d7ps&$\u0018B\u0001\u001e8\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q!Qh\u0010!B!\tq\u0004!D\u0001\u0013\u0011\u00151C\u00011\u0001(\u0011\u0015iC\u00011\u0001/\u0011\u0015!D\u00011\u00016Q\t!1\t\u0005\u0002E\u001f6\tQI\u0003\u0002G\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005!K\u0015a\u00024bGR|'/\u001f\u0006\u0003\u0015.\u000bQAY3b]NT!\u0001T'\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AT\u0001\u0004_J<\u0017B\u0001)F\u0005%\tU\u000f^8xSJ,G-A\u0005tKJ4XM]+sYV\t1\u000b\u0005\u0002U36\tQK\u0003\u0002W/\u0006!A.\u00198h\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW+\u0003\rM#(/\u001b8h\u0003)\u0019XM\u001d<feV\u0013H\u000eI\u0001\u001dO\u0016$X)\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8TKR$\u0018N\\4t+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1\u0017\u0003\u00151\u0018.Z<t\u0013\t\u0019\u0007MA\u000fF[\u0006LGNT8uS\u001aL7-\u0019;j_:\u001cV\r\u001e;j]\u001e\u001ch+[3xQ\u00119Qm\u001c9\u0011\u0005\u0019lW\"A4\u000b\u0005!L\u0017A\u0001:t\u0015\tQ7.\u0001\u0002xg*\tA.A\u0003kCZ\f\u00070\u0003\u0002oO\n!\u0001+\u0019;i\u0003\u00151\u0018\r\\;fC\u0005\t\u0018AB3nC&d7\u000f\u000b\u0002\bgB\u0011a\r^\u0005\u0003k\u001e\u00141aR#U\u0003})\b\u000fZ1uK\u0016k\u0017-\u001b7O_RLg-[2bi&|gnU3ui&twm\u001d\u000b\u0003=bDQ!\u001f\u0005A\u0002y\u000bQ$Z7bS2tu\u000e^5gS\u000e\fG/[8o'\u0016$H/\u001b8hgZKWm\u001e\u0015\u0005\u0011\u0015|\u0007\u000f\u000b\u0002\tyB\u0011a-`\u0005\u0003}\u001e\u0014A\u0001U(T)\u0006YR\u000f\u001d3bi\u0016,U.Y5m)\u0016l\u0007\u000f\\1uKN+G\u000f^5oON$B!a\u0001\u0002\nA\u0019\u0011%!\u0002\n\u0007\u0005\u001d!E\u0001\u0003V]&$\bbBA\u0006\u0013\u0001\u0007\u0011QB\u0001\u001c]>$\u0018NZ5dCRLwN\u001c+sS\u001e<WM]*fiRLgnZ:\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u00059AO]5hO\u0016\u0014(bAA\f-\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\u0007\u0002\u0012\tYbj\u001c;jM&\u001c\u0017\r^5p]R\u0013\u0018nZ4feN+G\u000f^5oONDS!C3p\u0003?\t#!!\t\u0002-\u0015l\u0017-\u001b7t_Q\u0014\u0018nZ4feN+G\u000f^5oOND#!\u0003?\u0002\u000fA\u0014XM^5foR1\u0011\u0011FA\u001f\u0003\u0017\u0002B!a\u000b\u0002:9!\u0011QFA\u001b!\r\tyCI\u0007\u0003\u0003cQ1!a\r\u001f\u0003\u0019a$o\\8u}%\u0019\u0011q\u0007\u0012\u0002\rA\u0013X\rZ3g\u0013\rQ\u00161\b\u0006\u0004\u0003o\u0011\u0003bBA \u0015\u0001\u0007\u0011\u0011F\u0001\tM>dG-\u001a:JI\":\u0011QHA\"_\u0006%\u0003c\u00014\u0002F%\u0019\u0011qI4\u0003\u0015E+XM]=QCJ\fW.\t\u0002\u0002@!9\u0011Q\n\u0006A\u0002\u0005=\u0013\u0001\u0002<jK^\u00042aXA)\u0013\r\t\u0019\u0006\u0019\u0002\u0011\u000b6\f\u0017\u000e\u001c)sKZLWm\u001e,jK^DSAC3p\u0003/\n#!!\u0017\u0002\u001d\u0015l\u0017-\u001b7t_A\u0014XM^5fo\"\u0012!\u0002 \u000b\u0004=\u0006}\u0003bBA1\u0017\u0001\u0007\u0011\u0011F\u0001\u000bg\u0016$H/\u001b8hg&#\u0007fBA0\u0003Kz\u00171\u000e\t\u0004M\u0006\u001d\u0014bAA5O\nI\u0001+\u0019;i!\u0006\u0014\u0018-\\\u0011\u0003\u0003CBSaC3p\u0003_\n#!!\u001d\u0002k\u0015l\u0017-\u001b7t_m\u001cX\r\u001e;j]\u001e\u001c\u0018\n\u001a\u001e/U=*U.Y5m\u001d>$\u0018NZ5dCRLwN\\*fiRLgnZ:\\=>j&& \u0015\u0004\u0017\u0005U\u0004\u0003BA<\u0003\u0007k!!!\u001f\u000b\u0007\u0019\u000bYH\u0003\u0003\u0002~\u0005}\u0014aB7fiJL7m\u001d\u0006\u0004\u0003\u0003c\u0012\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005\u0015\u0015\u0011\u0010\u0002\u0006)&lW\r\u001a\u0015\u0003\u0017M\fQeZ3u\u000b6\f\u0017\u000e\u001c(pi&4\u0017nY1uS>t7+\u001a;uS:<7OR8s\r>dG-\u001a:\u0015\u0007y\u000bi\tC\u0004\u0002@1\u0001\r!!\u000b)\u000f\u00055\u0015QM8\u0002J!*A\"Z8\u0002\u0014\u0006\u0012\u0011QS\u0001!K6\f\u0017\u000e\\:0w\u001a|G\u000eZ3s\u0013\u0012TdFK\u0018G_2$WM].__uSS\u0010K\u0002\r\u0003kB#\u0001D:\u00029\u0005$G-R7bS2tu\u000e^5gS\u000e\fG/[8o'\u0016$H/\u001b8hgR)a,a(\u0002$\"9\u0011qH\u0007A\u0002\u0005%\u0002fBAP\u0003Kz\u0017\u0011\n\u0005\u0006s6\u0001\rA\u0018\u0015\u0006\u001b\u0015|\u00171\u0013\u0015\u0004\u001b\u0005U\u0004FA\u0007})\u0015q\u0016QVAY\u0011\u001d\t\tG\u0004a\u0001\u0003SAs!!,\u0002f=\fY\u0007C\u0003z\u001d\u0001\u0007a\fK\u0003\u000fK>\fy\u0007K\u0002\u000f\u0003kB3ADA]!\r1\u00171X\u0005\u0004\u0003{;'a\u0001)V)R1\u00111AAa\u0003\u000bDq!!\u0019\u0010\u0001\u0004\tI\u0003K\u0004\u0002B\u0006\u0015t.a\u001b\t\u000f\u0005-q\u00021\u0001\u0002\u000e!*q\"Z8\u0002J\u0006\u0012\u00111Z\u0001FK6\f\u0017\u000e\\:0wN,G\u000f^5oONLEM\u000f\u0018+_\u0015k\u0017-\u001b7O_RLg-[2bi&|gnU3ui&twm].__uSSp\f;sS\u001e<WM]*fiRLgnZ:)\u0007=\t)\bK\u0002\u0010\u0003s\u000bq\u0004Z3mKR,W)\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8TKR$\u0018N\\4t)\u0011\t\u0019!!6\t\u000f\u0005\u0005\u0004\u00031\u0001\u0002*!:\u0011Q[A3_\u0006-\u0004&\u0002\tf_\u0006=\u0004f\u0001\t\u0002v!\u001a\u0001#a8\u0011\u0007\u0019\f\t/C\u0002\u0002d\u001e\u0014a\u0001R#M\u000bR+\u0005f\u0001\u0001\u0002hB!\u0011\u0011^Ax\u001b\t\tYOC\u0002\u0002n.\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\t0a;\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f\u000b\u0004\u0001\u0003k|\u00171 \t\u0004M\u0006]\u0018bAA}O\nA\u0001K]8ek\u000e,7\u000f\f\u0002\u0002~\u0006\u0012\u0011q`\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:DS\u0001A3p\u0005\u0007\t#A!\u0002\u0002/=\u001aX\r\u001e;j]\u001e\u001cxF\\8uS\u001aL7-\u0019;j_:\u001c\b")
public class NotificationsResource {
    private final EmailNotificationsService emailNotificationsService;
    private final PermissionChecker permissions;
    private final String serverUrl;

    private String serverUrl() {
        return this.serverUrl;
    }

    @GET
    @Path(value="emails")
    public EmailNotificationSettingsView getEmailNotificationSettings() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.getSettings("Configuration/mail/EmailNotificationSettings"));
    }

    @POST
    @Path(value="emails")
    public EmailNotificationSettingsView updateEmailNotificationSettings(EmailNotificationSettingsView emailNotificationSettingsView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        emailNotificationSettingsView.setId("Configuration/mail/EmailNotificationSettings");
        emailNotificationSettingsView.setFolderId(Ids.ROOT_FOLDER_ID);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.updateSettings(EmailNotificationSettingsConverter.fromView(emailNotificationSettingsView)));
    }

    @POST
    @Path(value="emails/triggerSettings")
    public void updateEmailTemplateSettings(NotificationTriggerSettings notificationTriggerSettings) {
        this.permissions.check(PlatformPermissions.ADMIN);
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings("Configuration/mail/EmailNotificationSettings");
        settings.setNotificationTriggerSettings(notificationTriggerSettings);
        this.emailNotificationsService.updateSettings(settings);
    }

    @POST
    @Path(value="emails/preview")
    public String preview(@QueryParam(value="folderId") String folderId, EmailPreviewView view) {
        if (!StringUtils.isEmpty((Object)folderId) && !Ids.isRoot((String)folderId)) {
            this.permissions.checkEditNotification(folderId);
        } else {
            this.permissions.check(PlatformPermissions.ADMIN);
        }
        return this.emailNotificationsService.createPreview(TriggerType$.MODULE$.withName(view.triggerType()), view.body(), this.serverUrl());
    }

    @GET
    @Timed
    @Path(value="emails/{settingsId:.*/EmailNotificationSettings[^/]*}")
    public EmailNotificationSettingsView getEmailNotificationSettings(@PathParam(value="settingsId") String settingsId) {
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings(settingsId);
        this.permissions.checkEditNotification(settings.getFolderId());
        return EmailNotificationSettingsConverter.toView(settings);
    }

    @GET
    @Timed
    @Path(value="emails/{folderId:.*/Folder[^/]*}")
    public EmailNotificationSettingsView getEmailNotificationSettingsForFolder(@PathParam(value="folderId") String folderId) {
        this.permissions.checkEditNotification(folderId);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.getSettings(folderId));
    }

    @POST
    @Timed
    @Path(value="emails/{folderId:.*/Folder[^/]*}")
    public EmailNotificationSettingsView addEmailNotificationSettings(@PathParam(value="folderId") String folderId, EmailNotificationSettingsView emailNotificationSettingsView) {
        this.permissions.checkEditNotification(folderId);
        emailNotificationSettingsView.setFolderId(folderId);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.create(EmailNotificationSettingsConverter.fromView(emailNotificationSettingsView)));
    }

    @PUT
    @Timed
    @Path(value="emails/{settingsId:.*/EmailNotificationSettings[^/]*}")
    public EmailNotificationSettingsView updateEmailNotificationSettings(@PathParam(value="settingsId") String settingsId, EmailNotificationSettingsView emailNotificationSettingsView) {
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings(settingsId);
        this.permissions.checkEditNotification(settings.getFolderId());
        emailNotificationSettingsView.setId(settingsId);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.updateSettings(EmailNotificationSettingsConverter.fromView(emailNotificationSettingsView)));
    }

    @PUT
    @Timed
    @Path(value="emails/{settingsId:.*/EmailNotificationSettings[^/]*}/triggerSettings")
    public void updateEmailTemplateSettings(@PathParam(value="settingsId") String settingsId, NotificationTriggerSettings notificationTriggerSettings) {
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings(settingsId);
        this.permissions.checkEditNotification(settings.getFolderId());
        settings.setNotificationTriggerSettings(notificationTriggerSettings);
        this.emailNotificationsService.updateSettings(settings);
    }

    @DELETE
    @Timed
    @Path(value="emails/{settingsId:.*/EmailNotificationSettings[^/]*}")
    public void deleteEmailNotificationSettings(@PathParam(value="settingsId") String settingsId) {
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings(settingsId);
        String string = settings.getId();
        String string2 = "Configuration/mail/EmailNotificationSettings";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("Can't delete the global email notification settings");
        }
        this.permissions.checkEditNotification(settings.getFolderId());
        this.emailNotificationsService.deleteSettings(settings);
    }

    @Autowired
    public NotificationsResource(EmailNotificationsService emailNotificationsService, PermissionChecker permissions, ServerConfiguration serverConfiguration) {
        this.emailNotificationsService = emailNotificationsService;
        this.permissions = permissions;
        this.serverUrl = serverConfiguration.getServerUrl();
    }
}

