/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.google.common.base.Strings;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.notifications.configuration.OAuth2SmtpAuthentication;
import com.xebialabs.xlrelease.notifications.configuration.SmtpAuthentication;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer$;
import com.xebialabs.xlrelease.script.EncryptionHelper$;
import com.xebialabs.xlrelease.service.ConfigurationService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0005y4AAC\u0006\u0001-!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003-\u0001\u0011\u0005Q\u0006C\u0004A\u0001\t\u0007I\u0011B!\t\r)\u0003\u0001\u0015!\u0003C\u0011\u001dY\u0005A1A\u0005\n1Ca\u0001\u0015\u0001!\u0002\u0013i\u0005\"B)\u0001\t\u0003\u0011\u0006\"\u00020\u0001\t\u0013y\u0006\"\u00025\u0001\t\u0013I'\u0001\u0007*fMJ,7\u000f\u001b+pW\u0016tw*Q;uQJBU\r\u001c9fe*\u0011A\"D\u0001\u0006K6\f\u0017\u000e\u001c\u0006\u0003\u001d=\tQB\\8uS\u001aL7-\u0019;j_:\u001c(B\u0001\t\u0012\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0013'\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0003tY\u001a$$NC\u0001#\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0013 \u0005\u001daunZ4j]\u001e\fAcY8oM&<WO]1uS>t7+\u001a:wS\u000e,\u0007CA\u0014+\u001b\u0005A#BA\u0015\u0010\u0003\u001d\u0019XM\u001d<jG\u0016L!a\u000b\u0015\u0003)\r{gNZ5hkJ\fG/[8o'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0011a\u0006\r\t\u0003_\u0001i\u0011a\u0003\u0005\u0006K\t\u0001\rA\n\u0015\u0003\u0005I\u0002\"a\r \u000e\u0003QR!!\u000e\u001c\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00028q\u00059a-Y2u_JL(BA\u001d;\u0003\u0015\u0011W-\u00198t\u0015\tYD(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005i\u0014aA8sO&\u0011q\b\u000e\u0002\n\u0003V$xn^5sK\u0012\f\u0011b\u00197pG.\u001c6.Z<\u0016\u0003\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\tQLW.\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEI\u0001\u0005EkJ\fG/[8o\u0003)\u0019Gn\\2l'.,w\u000fI\u0001\u0006G2|7m[\u000b\u0002\u001bB\u00111IT\u0005\u0003\u001f\u0012\u0013Qa\u00117pG.\faa\u00197pG.\u0004\u0013A\u0006:fMJ,7\u000f\u001b+pW\u0016t\u0017J\u001a*fcVL'/\u001a3\u0015\u0005M3\u0006C\u0001\rU\u0013\t)\u0016D\u0001\u0003V]&$\b\"B,\b\u0001\u0004A\u0016AC:niB\u001cVM\u001d<feB\u0011\u0011\fX\u0007\u00025*\u00111,D\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005uS&AC*niB\u001cVM\u001d<fe\u0006y\u0001.Y:U_.,g.\u0012=qSJ,G\r\u0006\u0002aGB\u0011\u0001$Y\u0005\u0003Ef\u0011qAQ8pY\u0016\fg\u000eC\u0003e\u0011\u0001\u0007Q-\u0001\rpCV$\bNM*niB\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004\"!\u00174\n\u0005\u001dT&\u0001G(BkRD'gU7ua\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0006IAm\u001c*fMJ,7\u000f\u001b\u000b\u0003UZ\u0004\"a\u001b;\u000e\u00031T!!\u001c8\u0002\u000bQ|7.\u001a8\u000b\u0005=\u0004\u0018aA:eW*\u0011\u0011O]\u0001\u0007_\u0006,H\u000f\u001b\u001a\u000b\u0005M\u001c\u0012\u0001\u00038j[\n,8\u000fZ:\n\u0005Ud'aC!dG\u0016\u001c8\u000fV8lK:DQ\u0001Z\u0005A\u0002\u0015D#\u0001\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005mT\u0014AC:uKJ,w\u000e^=qK&\u0011QP\u001f\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class RefreshTokenOAuth2Helper
implements Logging {
    private final ConfigurationService configurationService;
    private final Duration clockSkew;
    private final Clock clock;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RefreshTokenOAuth2Helper refreshTokenOAuth2Helper = this;
        synchronized (refreshTokenOAuth2Helper) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Duration clockSkew() {
        return this.clockSkew;
    }

    private Clock clock() {
        return this.clock;
    }

    public void refreshTokenIfRequired(SmtpServer smtpServer) {
        SmtpAuthentication smtpAuthentication = smtpServer.authentication();
        if (smtpAuthentication instanceof OAuth2SmtpAuthentication) {
            BoxedUnit boxedUnit;
            OAuth2SmtpAuthentication oAuth2SmtpAuthentication = (OAuth2SmtpAuthentication)smtpAuthentication;
            EncryptionHelper$.MODULE$.decrypt((ConfigurationItem)oAuth2SmtpAuthentication);
            if (Strings.isNullOrEmpty((String)oAuth2SmtpAuthentication.getRefreshToken())) {
                throw new IllegalArgumentException("The refresh token must not be null or empty");
            }
            if (Strings.isNullOrEmpty((String)oAuth2SmtpAuthentication.getAccessToken()) || this.hasTokenExpired(oAuth2SmtpAuthentication)) {
                this.logger().debug((Function0 & Serializable)() -> "Going to generate a new access token");
                AccessToken accessToken = this.doRefresh(oAuth2SmtpAuthentication);
                oAuth2SmtpAuthentication.setAccessToken(accessToken.getValue());
                if (accessToken.getLifetime() > 0L) {
                    oAuth2SmtpAuthentication.setExpiresAt(Date.from(Instant.now().plusSeconds(accessToken.getLifetime())));
                } else {
                    oAuth2SmtpAuthentication.setExpiresAt(Date.from(Instant.now().plusSeconds(1L)));
                }
                if (this.configurationService.exists(SmtpServer$.MODULE$.SMTP_SERVER_ID())) {
                    this.configurationService.createOrUpdate((BaseConfiguration)smtpServer);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private boolean hasTokenExpired(OAuth2SmtpAuthentication oauth2SmtpAuthentication) {
        return oauth2SmtpAuthentication.getExpiresAt() != null ? this.clock().instant().isAfter(oauth2SmtpAuthentication.getExpiresAt().toInstant().minus(this.clockSkew())) : true;
    }

    private AccessToken doRefresh(OAuth2SmtpAuthentication oauth2SmtpAuthentication) {
        RefreshToken refreshToken = new RefreshToken(oauth2SmtpAuthentication.getRefreshToken());
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
        ClientID clientID = new ClientID(oauth2SmtpAuthentication.getClientId());
        Secret clientSecret = new Secret(oauth2SmtpAuthentication.getClientSecret());
        ClientSecretPost clientAuth = new ClientSecretPost(clientID, clientSecret);
        URI tokenEndpoint = new URI(oauth2SmtpAuthentication.getAccessTokenUrl());
        TokenRequest request = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)refreshTokenGrant);
        TokenResponse response = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(36).append("Refresh token response from server: ").append(response.toHTTPResponse().getContent()).toString());
        if (!response.indicatesSuccess()) {
            TokenErrorResponse errorResponse = response.toErrorResponse();
            throw new RuntimeException(new StringBuilder(77).append("An error occurred while attempting to get the new OAuth 2.0 Access Token: [").append(errorResponse.getErrorObject().getCode()).append("] ").append(errorResponse.getErrorObject().getDescription()).toString());
        }
        AccessTokenResponse successResponse = response.toSuccessResponse();
        AccessToken accessToken = successResponse.getTokens().getAccessToken();
        return accessToken;
    }

    @Autowired
    public RefreshTokenOAuth2Helper(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        Logging.$init$((Logging)this);
        this.clockSkew = Duration.ofSeconds(60L);
        this.clock = Clock.systemUTC();
    }
}

