/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts;
import akka.io.Inet;
import akka.io.Tcp;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.BindFailedException;
import akka.stream.IOSettings;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.SourceShape;
import akka.stream.impl.fusing.GraphStages$;
import akka.stream.impl.io.ConnectionSourceStage$;
import akka.stream.impl.io.IncomingConnectionStage;
import akka.stream.impl.io.TcpIdleTimeout$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Tcp;
import akka.stream.scaladsl.Tcp$ServerBinding$;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.GraphStageWithMaterializedValue;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Iterable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mf!B\u0010!\u0001\u0011B\u0003\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011\u0001&\t\u0011E\u0003!\u0011!Q\u0001\n-C\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\t9\u0002\u0011\t\u0011)A\u0005)\"AQ\f\u0001BC\u0002\u0013\u0005a\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003`\u0011!!\u0007A!b\u0001\n\u0003)\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011y\u0004!Q1A\u0005\u0002}D!\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\tI\u0001\u0001BC\u0002\u0013\u0005\u00111\u0002\u0005\u000b\u00033\u0001!\u0011!Q\u0001\n\u00055\u0001BCA\u000e\u0001\t\u0015\r\u0011\"\u0001\u0002\u001e!Q\u0011Q\u0005\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u001d\u0002A!b\u0001\n\u0003\tI\u0003\u0003\u0006\u00022\u0001\u0011\t\u0011)A\u0005\u0003WAq!a\r\u0001\t\u0003\t)\u0004C\u0005\u0002L\u0001\u0011\r\u0011\"\u0001\u0002N!A\u0011Q\u000b\u0001!\u0002\u0013\ty\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u0013\u0005\u0005\u0004A1A\u0005\u0002\u0005\r\u0004bBA3\u0001\u0001\u0006Ia\f\u0005\b\u0003O\u0002A\u0011IA5\u000f!\t9\n\tE\u0001I\u0005eeaB\u0010!\u0011\u0003!\u00131\u0014\u0005\b\u0003gIB\u0011AAR\u0011%\t)+\u0007b\u0001\n\u0003\t9\u000b\u0003\u0005\u00026f\u0001\u000b\u0011BAU\u0011%\t9,\u0007b\u0001\n\u0003\t9\u000b\u0003\u0005\u0002:f\u0001\u000b\u0011BAU\u0005U\u0019uN\u001c8fGRLwN\\*pkJ\u001cWm\u0015;bO\u0016T!!\t\u0012\u0002\u0005%|'BA\u0012%\u0003\u0011IW\u000e\u001d7\u000b\u0005\u00152\u0013AB:ue\u0016\fWNC\u0001(\u0003\u0011\t7n[1\u0014\u0005\u0001I\u0003\u0003\u0002\u0016._uj\u0011a\u000b\u0006\u0003Y\u0011\nQa\u001d;bO\u0016L!AL\u0016\u0003?\u001d\u0013\u0018\r\u001d5Ti\u0006<WmV5uQ6\u000bG/\u001a:jC2L'0\u001a3WC2,X\rE\u00021cMj\u0011\u0001J\u0005\u0003e\u0011\u00121bU8ve\u000e,7\u000b[1qKB\u0011AG\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003o\u0011\n\u0001b]2bY\u0006$7\u000f\\\u0005\u0003sY\n1\u0001V2q\u0013\tYDH\u0001\nJ]\u000e|W.\u001b8h\u0007>tg.Z2uS>t'BA\u001d7!\rq4)R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u000bG>t7-\u001e:sK:$(\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011{$A\u0002$viV\u0014X\r\u0005\u00025\r&\u0011q\t\u0010\u0002\u000e'\u0016\u0014h/\u001a:CS:$\u0017N\\4\u0002\u0015Q\u001c\u0007/T1oC\u001e,'o\u0001\u0001\u0016\u0003-\u0003\"\u0001T(\u000e\u00035S!A\u0014\u0014\u0002\u000b\u0005\u001cGo\u001c:\n\u0005Ak%\u0001C!di>\u0014(+\u001a4\u0002\u0017Q\u001c\u0007/T1oC\u001e,'\u000fI\u0001\tK:$\u0007o\\5oiV\tA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006\u0019a.\u001a;\u000b\u0003e\u000bAA[1wC&\u00111L\u0016\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018!C3oIB|\u0017N\u001c;!\u0003\u001d\u0011\u0017mY6m_\u001e,\u0012a\u0018\t\u0003A\u0006l\u0011!Q\u0005\u0003E\u0006\u00131!\u00138u\u0003!\u0011\u0017mY6m_\u001e\u0004\u0013aB8qi&|gn]\u000b\u0002MB\u0019q\r\u001c8\u000e\u0003!T!!\u001b6\u0002\u0013%lW.\u001e;bE2,'BA6B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003[\"\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0003_jt!\u0001]<\u000f\u0005E4hB\u0001:v\u001b\u0005\u0019(B\u0001;J\u0003\u0019a$o\\8u}%\tq%\u0003\u0002\"M%\u0011\u00010_\u0001\u0005\u0013:,GO\u0003\u0002\"M%\u00111\u0010 \u0002\r'>\u001c7.\u001a;PaRLwN\u001c\u0006\u0003qf\f\u0001b\u001c9uS>t7\u000fI\u0001\nQ\u0006dgm\u00117pg\u0016,\"!!\u0001\u0011\u0007\u0001\f\u0019!C\u0002\u0002\u0006\u0005\u0013qAQ8pY\u0016\fg.\u0001\u0006iC247\t\\8tK\u0002\n1\"\u001b3mKRKW.Z8viV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C \u0002\u0011\u0011,(/\u0019;j_:LA!a\u0006\u0002\u0012\tAA)\u001e:bi&|g.\u0001\u0007jI2,G+[7f_V$\b%A\ncS:$7\u000b[;uI><h\u000eV5nK>,H/\u0006\u0002\u0002 A!\u0011qBA\u0011\u0013\u0011\t\u0019#!\u0005\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006!\"-\u001b8e'\",H\u000fZ8x]RKW.Z8vi\u0002\n!\"[8TKR$\u0018N\\4t+\t\tY\u0003E\u00021\u0003[I1!a\f%\u0005)IujU3ui&twm]\u0001\fS>\u001cV\r\u001e;j]\u001e\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003o\tY$!\u0010\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI\u0005E\u0002\u0002:\u0001i\u0011\u0001\t\u0005\u0006\u0011F\u0001\ra\u0013\u0005\u0006%F\u0001\r\u0001\u0016\u0005\u0006;F\u0001\ra\u0018\u0005\u0006IF\u0001\rA\u001a\u0005\u0007}F\u0001\r!!\u0001\t\u000f\u0005%\u0011\u00031\u0001\u0002\u000e!9\u00111D\tA\u0002\u0005}\u0001bBA\u0014#\u0001\u0007\u00111F\u0001\u0004_V$XCAA(!\u0011\u0001\u0014\u0011K\u001a\n\u0007\u0005MCE\u0001\u0004PkRdW\r^\u0001\u0005_V$\b%A\tj]&$\u0018.\u00197BiR\u0014\u0018NY;uKN,\"!a\u0017\u0011\u0007A\ni&C\u0002\u0002`\u0011\u0012!\"\u0011;ue&\u0014W\u000f^3t\u0003\u0015\u0019\b.\u00199f+\u0005y\u0013AB:iCB,\u0007%A\u0010de\u0016\fG/\u001a'pO&\u001c\u0017I\u001c3NCR,'/[1mSj,GMV1mk\u0016$B!a\u001b\u0002\u0006B9\u0001-!\u001c\u0002r\u0005]\u0014bAA8\u0003\n1A+\u001e9mKJ\u00022AKA:\u0013\r\t)h\u000b\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jGB!ahQA=!\r\tYH\u0012\b\u0004\u0003{Bd\u0002BA@\u0003\u0007s1!]AA\u0013\t)c%\u0003\u00028I!9\u0011qQ\fA\u0002\u0005m\u0013aE5oQ\u0016\u0014\u0018\u000e^3e\u0003R$(/\u001b2vi\u0016\u001c\bf\u0001\u0001\u0002\fB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012\u001a\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)*a$\u0003\u0017%sG/\u001a:oC2\f\u0005/[\u0001\u0016\u0007>tg.Z2uS>t7k\\;sG\u0016\u001cF/Y4f!\r\tI$G\n\u00043\u0005u\u0005c\u00011\u0002 &\u0019\u0011\u0011U!\u0003\r\u0005s\u0017PU3g)\t\tI*A\u0005CS:$G+[7feV\u0011\u0011\u0011\u0016\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*\u0019\u0011q\u0016-\u0002\t1\fgnZ\u0005\u0005\u0003g\u000biK\u0001\u0004TiJLgnZ\u0001\u000b\u0005&tG\rV5nKJ\u0004\u0013!\u0005\"j]\u0012\u001c\u0006.\u001e;e_^tG+[7fe\u0006\u0011\")\u001b8e'\",H\u000fZ8x]RKW.\u001a:!\u0001")
@InternalApi
public class ConnectionSourceStage
extends GraphStageWithMaterializedValue<SourceShape<Tcp.IncomingConnection>, Future<Tcp.ServerBinding>> {
    private final ActorRef tcpManager;
    private final InetSocketAddress endpoint;
    private final int backlog;
    private final Iterable<Inet.SocketOption> options;
    private final boolean halfClose;
    private final Duration idleTimeout;
    private final FiniteDuration bindShutdownTimeout;
    private final IOSettings ioSettings;
    private final Outlet<Tcp.IncomingConnection> out;
    private final SourceShape<Tcp.IncomingConnection> shape;

    public static String BindShutdownTimer() {
        return ConnectionSourceStage$.MODULE$.BindShutdownTimer();
    }

    public static String BindTimer() {
        return ConnectionSourceStage$.MODULE$.BindTimer();
    }

    public ActorRef tcpManager() {
        return this.tcpManager;
    }

    public InetSocketAddress endpoint() {
        return this.endpoint;
    }

    public int backlog() {
        return this.backlog;
    }

    public Iterable<Inet.SocketOption> options() {
        return this.options;
    }

    public boolean halfClose() {
        return this.halfClose;
    }

    public Duration idleTimeout() {
        return this.idleTimeout;
    }

    public FiniteDuration bindShutdownTimeout() {
        return this.bindShutdownTimeout;
    }

    public IOSettings ioSettings() {
        return this.ioSettings;
    }

    public Outlet<Tcp.IncomingConnection> out() {
        return this.out;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("ConnectionSource");
    }

    @Override
    public SourceShape<Tcp.IncomingConnection> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, Future<Tcp.ServerBinding>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise bindingPromise = Promise$.MODULE$.apply();
        TimerGraphStageLogic logic = new TimerGraphStageLogic(this, bindingPromise){
            private final AtomicLong connectionFlowsAwaitingInitialization;
            private ActorRef listener;
            private final Promise<BoxedUnit> unbindPromise;
            private boolean unbindStarted;
            private final /* synthetic */ ConnectionSourceStage $outer;
            private final Promise bindingPromise$1;

            public ActorRef self() {
                return this.stageActor().ref();
            }

            public AtomicLong connectionFlowsAwaitingInitialization() {
                return this.connectionFlowsAwaitingInitialization;
            }

            public ActorRef listener() {
                return this.listener;
            }

            public void listener_$eq(ActorRef x$1) {
                this.listener = x$1;
            }

            public Promise<BoxedUnit> unbindPromise() {
                return this.unbindPromise;
            }

            public boolean unbindStarted() {
                return this.unbindStarted;
            }

            public void unbindStarted_$eq(boolean x$1) {
                this.unbindStarted = x$1;
            }

            public void preStart() {
                this.getStageActor((Function1<Tuple2<ActorRef, Object>, BoxedUnit>)(Function1 & Serializable)evt -> {
                    $anon$1.$anonfun$preStart$1(this, evt);
                    return BoxedUnit.UNIT;
                });
                package$.MODULE$.actorRef2Scala(this.$outer.tcpManager()).$bang((Object)new Tcp.Bind(this.self(), this.$outer.endpoint(), this.$outer.backlog(), this.$outer.options(), true), this.self());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void receive(Tuple2<ActorRef, Object> evt) {
                ActorRef sender = (ActorRef)evt._1();
                Object msg = evt._2();
                Object object = msg;
                if (object instanceof Tcp.Bound) {
                    Tcp.Bound bound = (Tcp.Bound)object;
                    InetSocketAddress localAddress = bound.localAddress();
                    this.listener_$eq(sender);
                    this.stageActor().watch(this.listener());
                    if (this.isAvailable(this.$outer.out())) {
                        package$.MODULE$.actorRef2Scala(this.listener()).$bang((Object)new Tcp.ResumeAccepting(1), this.self());
                    }
                    ActorRef thisStage = this.self();
                    this.bindingPromise$1.success((Object)Tcp$ServerBinding$.MODULE$.apply(localAddress, (Function0<Future<BoxedUnit>>)(Function0 & Serializable)() -> {
                        block0: {
                            if (this.unbindPromise().isCompleted()) break block0;
                            thisStage.tell((Object)Tcp.Unbind$.MODULE$, thisStage);
                        }
                        return this.unbindPromise().future();
                    }, (Future<Done>)this.unbindPromise().future().map((Function1 & Serializable)x$1 -> Done$.MODULE$, (ExecutionContext)ExecutionContexts.sameThreadExecutionContext$.MODULE$)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (object instanceof Tcp.CommandFailed) {
                    Tcp.CommandFailed commandFailed = (Tcp.CommandFailed)object;
                    BindFailedException ex = new BindFailedException(null, commandFailed){
                        private final Tcp.CommandFailed x4$1;

                        public String getMessage() {
                            return new StringBuilder(11).append("Bind failed").append(this.x4$1.causedByString()).toString();
                        }
                        {
                            this.x4$1 = x4$1;
                        }
                    };
                    commandFailed.cause().foreach((Function1 & Serializable)x$1 -> ex.initCause((Throwable)x$1));
                    this.bindingPromise$1.failure((Throwable)ex);
                    this.unbindPromise().tryFailure((Throwable)ex);
                    this.failStage(ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (object instanceof Tcp.Connected) {
                    Tcp.Connected connected = (Tcp.Connected)object;
                    this.push(this.$outer.out(), this.connectionFor(connected, sender));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (Tcp.Unbind$.MODULE$.equals(object)) {
                    BoxedUnit boxedUnit;
                    if (!this.isClosed(this.$outer.out()) && this.listener() != null) {
                        this.akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                } else if (Tcp.Unbound$.MODULE$.equals(object)) {
                    this.unbindCompleted();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    BoxedUnit boxedUnit;
                    ActorRef ref;
                    if (!(object instanceof Terminated)) throw new MatchError(object);
                    Terminated terminated = (Terminated)object;
                    ActorRef actorRef2 = ref = terminated.actor();
                    ActorRef actorRef3 = this.listener();
                    if (actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null) throw new MatchError(object);
                    if (this.unbindStarted()) {
                        this.unbindCompleted();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        IllegalStateException ex = new IllegalStateException(new StringBuilder(65).append("IO Listener actor terminated unexpectedly for remote endpoint [").append(this.$outer.endpoint().getHostString()).append(":").append(this.$outer.endpoint().getPort()).append("]").toString());
                        this.unbindPromise().tryFailure((Throwable)ex);
                        this.failStage(ex);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                }
            }

            private Tcp.IncomingConnection connectionFor(Tcp.Connected connected, ActorRef connection) {
                Flow<ByteString, ByteString, NotUsed> flow;
                this.connectionFlowsAwaitingInitialization().incrementAndGet();
                Flow<ByteString, ByteString, NotUsed> tcpFlow = Flow$.MODULE$.fromGraph(new IncomingConnectionStage(connection, connected.remoteAddress(), this.$outer.halfClose(), this.$outer.ioSettings(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.connectionFlowsAwaitingInitialization().decrementAndGet())).via(GraphStages$.MODULE$.detacher());
                Duration duration = this.$outer.idleTimeout();
                if (duration instanceof FiniteDuration) {
                    FiniteDuration finiteDuration = (FiniteDuration)duration;
                    flow = tcpFlow.join(TcpIdleTimeout$.MODULE$.apply(finiteDuration, (Option<InetSocketAddress>)new Some((Object)connected.remoteAddress())));
                } else {
                    flow = tcpFlow;
                }
                Flow<ByteString, ByteString, NotUsed> handler = flow;
                return new Tcp.IncomingConnection(connected.localAddress(), connected.remoteAddress(), handler);
            }

            public void akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind() {
                block0: {
                    if (this.listener() == null || this.unbindStarted()) break block0;
                    this.unbindStarted_$eq(true);
                    this.setKeepGoing(true);
                    package$.MODULE$.actorRef2Scala(this.listener()).$bang((Object)Tcp.Unbind$.MODULE$, this.self());
                }
            }

            private void unbindCompleted() {
                this.stageActor().unwatch(this.listener());
                this.unbindPromise().trySuccess((Object)BoxedUnit.UNIT);
                if (this.connectionFlowsAwaitingInitialization().get() == 0L) {
                    this.completeStage();
                } else {
                    this.scheduleOnce((Object)ConnectionSourceStage$.MODULE$.BindShutdownTimer(), this.$outer.bindShutdownTimeout());
                }
            }

            public void onTimer(Object timerKey) {
                Object object = timerKey;
                String string = ConnectionSourceStage$.MODULE$.BindShutdownTimer();
                Object object2 = object;
                if (string != null ? !string.equals(object2) : object2 != null) {
                    throw new MatchError(object);
                }
                this.completeStage();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            public void postStop() {
                this.unbindPromise().trySuccess((Object)BoxedUnit.UNIT);
                this.bindingPromise$1.tryFailure((Throwable)new NoSuchElementException("Binding was unbound before it was completely finished"));
            }

            public static final /* synthetic */ void $anonfun$preStart$1($anon$1 $this, Tuple2 evt) {
                $this.receive((Tuple2<ActorRef, Object>)evt);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bindingPromise$1 = bindingPromise$1;
                super($outer.shape());
                this.connectionFlowsAwaitingInitialization = new AtomicLong();
                this.unbindPromise = Promise$.MODULE$.apply();
                this.unbindStarted = false;
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onPull() {
                        block0: {
                            if (this.$outer.listener() == null) break block0;
                            package$.MODULE$.actorRef2Scala(this.$outer.listener()).$bang((Object)new Tcp.ResumeAccepting(1), this.$outer.self());
                        }
                    }

                    public void onDownstreamFinish() {
                        this.$outer.akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        OutHandler.$init$(this);
                    }
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$connectionFor$1(akka.stream.impl.io.ConnectionSourceStage$$anon$1 ), $anonfun$preStart$1$adapted(akka.stream.impl.io.ConnectionSourceStage$$anon$1 scala.Tuple2 ), $anonfun$receive$1(akka.stream.impl.io.ConnectionSourceStage$$anon$1 akka.actor.ActorRef ), $anonfun$receive$2(scala.runtime.BoxedUnit ), $anonfun$receive$3(akka.stream.BindFailedException java.lang.Throwable )}, serializedLambda);
            }
        };
        return new Tuple2((Object)logic, (Object)bindingPromise.future());
    }

    public ConnectionSourceStage(ActorRef tcpManager, InetSocketAddress endpoint, int backlog, Iterable<Inet.SocketOption> options, boolean halfClose, Duration idleTimeout, FiniteDuration bindShutdownTimeout, IOSettings ioSettings) {
        this.tcpManager = tcpManager;
        this.endpoint = endpoint;
        this.backlog = backlog;
        this.options = options;
        this.halfClose = halfClose;
        this.idleTimeout = idleTimeout;
        this.bindShutdownTimeout = bindShutdownTimeout;
        this.ioSettings = ioSettings;
        this.out = Outlet$.MODULE$.apply("IncomingConnections.out");
        this.shape = new SourceShape<Tcp.IncomingConnection>(this.out());
    }
}

