/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;

public class OAuth2AuthenticationException
extends AuthenticationException {
    private final OAuth2Error error;

    public OAuth2AuthenticationException(OAuth2Error error) {
        this(error, error.getDescription());
    }

    public OAuth2AuthenticationException(OAuth2Error error, Throwable cause) {
        this(error, cause.getMessage(), cause);
    }

    public OAuth2AuthenticationException(OAuth2Error error, String message) {
        this(error, message, null);
    }

    public OAuth2AuthenticationException(OAuth2Error error, String message, Throwable cause) {
        super(message, cause);
        Assert.notNull((Object)error, (String)"error cannot be null");
        this.error = error;
    }

    public OAuth2Error getError() {
        return this.error;
    }
}

