/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.script.ScriptResult;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.service.PhaseService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseScriptTaskExecutor<T extends BaseScriptTask>
implements TaskExecutor<T> {
    protected ReleaseActorService releaseActorService;
    protected PhaseService phaseService;
    private Map<String, ScriptService> scriptServices = new HashMap<String, ScriptService>();

    protected BaseScriptTaskExecutor(ReleaseActorService releaseActorService, PhaseService phaseService, Collection<? extends ScriptService> scriptServices) {
        this.releaseActorService = releaseActorService;
        this.phaseService = phaseService;
        scriptServices.forEach(scriptService -> this.scriptServices.put(scriptService.engine(), (ScriptService)scriptService));
    }

    protected ScriptService scriptServiceFor(BaseScriptTask task) {
        return this.scriptServices.get(task.getEngine());
    }

    protected void saveScriptResults(ScriptResult scriptTaskResult) {
        scriptTaskResult.save(this.releaseActorService, this.phaseService);
    }
}

