/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.excel;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class Export {
    protected XSSFWorkbook workBook = new XSSFWorkbook();
    protected XSSFSheet sheet = this.workBook.createSheet();
    protected int rowIndex = 0;

    protected abstract void addContent();

    protected abstract void setColumnsWidth();

    protected abstract void addHeaderRow();

    public Workbook getWorkBook() {
        this.workBook = new XSSFWorkbook();
        this.sheet = this.workBook.createSheet();
        try {
            this.addHeaderRow();
            this.setColumnsWidth();
            this.addContent();
            Export.preventDynamicDataExchangeAttack(this.workBook);
        }
        finally {
            this.rowIndex = 0;
        }
        return this.workBook;
    }

    public static int numberOfCharacter(int number) {
        return number * 256;
    }

    public static void preventDynamicDataExchangeAttack(XSSFWorkbook workBook) {
        String pattern = "^(=|@|-|\"|\\+).+$";
        for (Sheet sheet : workBook) {
            for (Row row : sheet) {
                for (Cell cell : row) {
                    XSSFCell xssfcell = (XSSFCell)cell;
                    if (xssfcell.getCellTypeEnum() != CellType.STRING || !xssfcell.toString().trim().matches(pattern)) continue;
                    xssfcell.setCellValue("'" + xssfcell.getStringCellValue());
                }
            }
        }
    }
}

