/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.config.XlrConfig;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import java.security.cert.Certificate;
import org.springframework.stereotype.Component;

@Component
public class ScriptPermissionsProvider {
    public static final String SCRIPT_POLICY_FILE = "script.policy";
    private final PermissionCollection permissionCollection = this.loadPermissionCollection();

    public PermissionCollection getScriptPermissions() {
        XlrConfig conf = XlrConfig.getInstance();
        if (conf.isAutoRefreshScriptPolicy()) {
            return this.loadPermissionCollection();
        }
        return this.permissionCollection;
    }

    private PermissionCollection loadPermissionCollection() {
        try {
            URL policyFileUrl = ClassLoader.getSystemClassLoader().getResource(SCRIPT_POLICY_FILE);
            URIParameter params = policyFileUrl == null ? null : new URIParameter(policyFileUrl.toURI());
            Policy scriptPolicy = Policy.getInstance("JavaPolicy", params);
            return scriptPolicy.getPermissions(new ProtectionDomain(new CodeSource(null, (Certificate[])null), null));
        }
        catch (URISyntaxException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

