/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script.jython;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.script.Jsr223ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptPermissionsProvider;
import com.xebialabs.xlrelease.script.jython.JythonEngineInstance;
import com.xebialabs.xlrelease.script.jython.JythonScriptHelper;
import com.xebialabs.xlrelease.script.jython.JythonScriptValidator;
import java.security.AccessControlContext;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.Iterable;
import scala.jdk.javaapi.CollectionConverters;

@Component
public class JythonScriptExecutor
extends Jsr223ScriptExecutor {
    private JythonScriptValidator scriptValidator;

    @Autowired
    public JythonScriptExecutor(JythonEngineInstance jythonEngineInstance, ScriptPermissionsProvider scriptPermissionsProvider, XlrConfig xlrConfig, JythonScriptValidator scriptValidator) {
        super(jythonEngineInstance, scriptPermissionsProvider, xlrConfig);
        this.scriptValidator = scriptValidator;
    }

    @Override
    protected Object evalScriptPrivileged(ScriptEngine engine, String script, ScriptContext scriptContext, AccessControlContext accessControlContext) throws Exception {
        if (this.isRestricted(accessControlContext != null)) {
            this.scriptValidator.validate(script, "UTF-8");
        }
        try {
            this.wrapBindings(engine, scriptContext);
            Object result = this.doPrivileged(engine, script, scriptContext, accessControlContext);
            this.unwrapBindings(engine, scriptContext);
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new ScriptException(new SecurityException(e.getMessage()));
        }
    }

    private void wrapBindings(ScriptEngine engine, ScriptContext scriptContext) throws Exception {
        List bindingsToWrap = (List)scriptContext.getAttribute("_contextBindingsToWrap");
        if (bindingsToWrap != null) {
            this.doPrivileged(engine, JythonScriptHelper.wrapBindings((Iterable<String>)CollectionConverters.asScala((List)bindingsToWrap).toIterable()).scriptContent(), scriptContext, null);
        }
    }

    private void unwrapBindings(ScriptEngine engine, ScriptContext scriptContext) throws Exception {
        List bindingsToUnwrap = (List)scriptContext.getAttribute("_contextBindingsToUnWrap");
        if (bindingsToUnwrap != null) {
            this.doPrivileged(engine, JythonScriptHelper.unwrapBindings((Iterable<String>)CollectionConverters.asScala((List)bindingsToUnwrap).toIterable()).scriptContent(), scriptContext, null);
        }
    }
}

