/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.ssh.SshInteractiveSudoConnection;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshSftpCygwinConnection;
import com.xebialabs.overthere.ssh.SshSftpOpenSshdConnection;
import com.xebialabs.overthere.ssh.SshSftpUnixConnection;
import com.xebialabs.overthere.ssh.SshSftpWinSshdConnection;
import com.xebialabs.overthere.ssh.SshSuConnection;
import com.xebialabs.overthere.ssh.SshSudoConnection;

@Protocol(name="ssh")
public class SshConnectionBuilder
implements OverthereConnectionBuilder {
    public static final String SSH_PROTOCOL = "ssh";
    public static final int PORT_DEFAULT_SSH = 22;
    public static final String ALLOCATE_DEFAULT_PTY = "allocateDefaultPty";
    public static final boolean ALLOCATE_DEFAULT_PTY_DEFAULT = false;
    public static final String ALLOCATE_PTY = "allocatePty";
    public static final String HEARTBEAT_INTERVAL = "heartbeatInterval";
    public static final int HEARTBEAT_INTERVAL_DEFAULT = 0;
    public static final String CONNECTION_TYPE = "connectionType";
    public static final String DELETE_DIRECTORY_COMMAND = "deleteDirectoryCommand";
    public static final String DELETE_DIRECTORY_COMMAND_DEFAULT = "rmdir {0}";
    public static final String DELETE_FILE_COMMAND = "deleteFileCommand";
    public static final String DELETE_FILE_COMMAND_DEFAULT = "rm -f {0}";
    public static final String DELETE_RECURSIVELY_COMMAND = "deleteRecursivelyCommand";
    public static final String DELETE_RECURSIVELY_COMMAND_DEFAULT = "rm -rf {0}";
    public static final String GET_FILE_INFO_COMMAND = "getFileInfoCommand";
    public static final String GET_FILE_INFO_COMMAND_DEFAULT = "ls -ld {0}";
    public static final String INTERACTIVE_KEYBOARD_AUTH_PROMPT_REGEX = "interactiveKeyboardAuthRegex";
    public static final String INTERACTIVE_KEYBOARD_AUTH_PROMPT_REGEX_DEFAULT = ".*Password:[ ]?";
    public static final String LIST_FILES_COMMAND = "listFilesCommand";
    public static final String LIST_FILES_COMMAND_DEFAULT = "ls -a1 {0}";
    public static final String MKDIR_COMMAND = "mkdirCommand";
    public static final String MKDIR_COMMAND_DEFAULT = "mkdir {0}";
    public static final String MKDIRS_COMMAND = "mkdirsCommand";
    public static final String MKDIRS_COMMAND_DEFAULT = "mkdir -p {0}";
    public static final String OPEN_SHELL_BEFORE_EXECUTE = "openShellBeforeExecute";
    public static final boolean OPEN_SHELL_BEFORE_EXECUTE_DEFAULT = false;
    public static final String PASSPHRASE = ConnectionOptions.registerFilteredKey("passphrase");
    public static final String PRIVATE_KEY = ConnectionOptions.registerFilteredKey("privateKey");
    public static final String PRIVATE_KEY_FILE = "privateKeyFile";
    public static final String PORT_ALLOCATION_RANGE_START = "portAllocationRangeStart";
    public static final int PORT_ALLOCATION_RANGE_START_DEFAULT = 1024;
    public static final String RENAME_TO_COMMAND = "renameToCommand";
    public static final String RENAME_TO_COMMAND_DEFAULT = "mv {0} {1}";
    public static final String SET_EXECUTABLE_COMMAND = "setExecutableCommand";
    public static final String SET_EXECUTABLE_COMMAND_DEFAULT = "chmod a+x {0}";
    public static final String SET_NOT_EXECUTABLE_COMMAND = "setNotExecutableCommand";
    public static final String SET_NOT_EXECUTABLE_COMMAND_DEFAULT = "chmod a-x {0}";
    public static final String SU_COMMAND_PREFIX = "suCommandPrefix";
    public static final String SU_COMMAND_PREFIX_DEFAULT = "su - {0} -c";
    public static final String SU_COPY_FROM_TEMP_FILE_COMMAND = "suCopyFromTempFileCommand";
    public static final String SU_COPY_FROM_TEMP_FILE_COMMAND_DEFAULT_PRESERVE_ATTRIBUTES = "cp -pr {0} {1}";
    public static final String SU_COPY_FROM_TEMP_FILE_COMMAND_DEFAULT_NO_PRESERVE_ATTRIBUTES = "cp -r {0} {1}";
    public static final String SU_COPY_TO_TEMP_FILE_COMMAND = "suCopyToTempFileCommand";
    public static final String SU_COPY_TO_TEMP_FILE_COMMAND_DEFAULT_PRESERVE_ATTRIBUTES = "cp -pr {0} {1}";
    public static final String SU_COPY_TO_TEMP_FILE_COMMAND_DEFAULT_NO_PRESERVE_ATTRIBUTES = "cp -r {0} {1}";
    public static final String SU_OVERRIDE_UMASK = "suOverrideUmask";
    public static final boolean SU_OVERRIDE_UMASK_DEFAULT = true;
    public static final String SU_OVERRIDE_UMASK_COMMAND = "suOverrideUmaskCommand";
    public static final String SU_OVERRIDE_UMASK_COMMAND_DEFAULT = "chmod -R go+rX {0}";
    public static final String SU_PASSWORD = ConnectionOptions.registerFilteredKey("suPassword");
    public static final String SU_PASSWORD_PROMPT_REGEX = "suPasswordPromptRegex";
    public static final String SU_PASSWORD_PROMPT_REGEX_DEFAULT = ".*[Pp]assword.*:";
    public static final String SU_PRESERVE_ATTRIBUTES_ON_COPY_FROM_TEMP_FILE = "suPreserveAttributesOnCopyFromTempFile";
    public static final boolean SU_PRESERVE_ATTRIBUTES_ON_COPY_FROM_TEMP_FILE_DEFAULT = false;
    public static final String SU_PRESERVE_ATTRIBUTES_ON_COPY_TO_TEMP_FILE = "suPreserveAttributesOnCopyToTempFile";
    public static final boolean SU_PRESERVE_ATTRIBUTES_ON_COPY_TO_TEMP_FILE_DEFAULT = false;
    public static final String SU_QUOTE_COMMAND = "suQuoteCommand";
    public static final boolean SU_QUOTE_COMMAND_DEFAULT = true;
    public static final String SU_TEMP_MKDIR_COMMAND = "suTempMkdirCommand";
    public static final String SU_TEMP_MKDIR_COMMAND_DEFAULT = "mkdir -m 1777 {0}";
    public static final String SU_TEMP_MKDIRS_COMMAND = "suTempMkdirsCommand";
    public static final String SU_TEMP_MKDIRS_COMMAND_DEFAULT = "mkdir -p -m 1777 {0}";
    public static final String SU_USERNAME = "suUsername";
    public static final String SUDO_COMMAND_PREFIX = "sudoCommandPrefix";
    public static final String SUDO_COMMAND_PREFIX_DEFAULT = "sudo -u {0}";
    public static final String SUDO_COPY_FROM_TEMP_FILE_COMMAND = "sudoCopyFromTempFileCommand";
    public static final String SUDO_COPY_FROM_TEMP_FILE_COMMAND_DEFAULT_PRESERVE_ATTRIBUTES = "cp -pr {0} {1}";
    public static final String SUDO_COPY_FROM_TEMP_FILE_COMMAND_DEFAULT_NO_PRESERVE_ATTRIBUTES = "cp -r {0} {1}";
    public static final String SUDO_COPY_TO_TEMP_FILE_COMMAND = "sudoCopyToTempFileCommand";
    public static final String SUDO_COPY_TO_TEMP_FILE_COMMAND_DEFAULT_PRESERVE_ATTRIBUTES = "cp -pr {0} {1}";
    public static final String SUDO_COPY_TO_TEMP_FILE_COMMAND_DEFAULT_NO_PRESERVE_ATTRIBUTES = "cp -r {0} {1}";
    public static final String SUDO_OVERRIDE_UMASK = "sudoOverrideUmask";
    public static final boolean SUDO_OVERRIDE_UMASK_DEFAULT = true;
    public static final String SUDO_OVERRIDE_UMASK_COMMAND = "sudoOverrideUmaskCommand";
    public static final String SUDO_OVERRIDE_UMASK_COMMAND_DEFAULT = "chmod -R go+rX {0}";
    public static final String SUDO_PASSWORD_PROMPT_REGEX = "sudoPasswordPromptRegex";
    public static final String SUDO_PASSWORD_PROMPT_REGEX_DEFAULT = ".*[Pp]assword.*:";
    public static final String SUDO_PRESERVE_ATTRIBUTES_ON_COPY_FROM_TEMP_FILE = "sudoPreserveAttributesOnCopyFromTempFile";
    public static final boolean SUDO_PRESERVE_ATTRIBUTES_ON_COPY_FROM_TEMP_FILE_DEFAULT = false;
    public static final String SUDO_PRESERVE_ATTRIBUTES_ON_COPY_TO_TEMP_FILE = "sudoPreserveAttributesOnCopyToTempFile";
    public static final boolean SUDO_PRESERVE_ATTRIBUTES_ON_COPY_TO_TEMP_FILE_DEFAULT = false;
    public static final String SUDO_QUOTE_COMMAND = "sudoQuoteCommand";
    public static final boolean SUDO_QUOTE_COMMAND_DEFAULT = false;
    public static final String SUDO_TEMP_MKDIR_COMMAND = "sudoTempMkdirCommand";
    public static final String SUDO_TEMP_MKDIR_COMMAND_DEFAULT = "mkdir -m 1777 {0}";
    public static final String SUDO_TEMP_MKDIRS_COMMAND = "sudoTempMkdirsCommand";
    public static final String SUDO_TEMP_MKDIRS_COMMAND_DEFAULT = "mkdir -p -m 1777 {0}";
    public static final String SUDO_USERNAME = "sudoUsername";
    public static final String LOCAL_ADDRESS = "localAddress";
    public static final String LOCAL_PORT = "localPort";
    public static final String TRANSPORT_TIMEOUT_MILLIS = "transportTimeoutMillis";
    public static final int TRANSPORT_TIMEOUT_MILLIS_DEFAULT = 30000;
    protected SshConnection connection;

    public SshConnectionBuilder(String type, ConnectionOptions options, AddressPortMapper mapper) {
        SshConnectionType sshConnectionType = options.getEnum(CONNECTION_TYPE, SshConnectionType.class);
        switch (sshConnectionType) {
            case SFTP: {
                this.connection = new SshSftpUnixConnection(type, options, mapper);
                break;
            }
            case SFTP_CYGWIN: {
                this.connection = new SshSftpCygwinConnection(type, options, mapper);
                break;
            }
            case SFTP_WINSSHD: {
                this.connection = new SshSftpWinSshdConnection(type, options, mapper);
                break;
            }
            case SFTP_OpenSSHD: {
                this.connection = new SshSftpOpenSshdConnection(type, options, mapper);
                break;
            }
            case SCP: {
                this.connection = new SshScpConnection(type, options, mapper);
                break;
            }
            case SU: {
                this.connection = new SshSuConnection(type, options, mapper);
                break;
            }
            case SUDO: {
                this.connection = new SshSudoConnection(type, options, mapper);
                break;
            }
            case INTERACTIVE_SUDO: {
                this.connection = new SshInteractiveSudoConnection(type, options, mapper);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SSH connection type " + (Object)((Object)sshConnectionType));
            }
        }
    }

    @Override
    public OverthereConnection connect() {
        this.connection.connect();
        return this.connection;
    }

    public String toString() {
        return this.connection.toString();
    }
}

