/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scm.connector;

import com.google.common.net.UrlEscapers;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.scm.connector.GitLabScmConnectorConfig;
import com.xebialabs.xlrelease.scm.connector.Blobs;
import com.xebialabs.xlrelease.scm.connector.GitLabCommit;
import com.xebialabs.xlrelease.scm.connector.GitLabCommitAction;
import com.xebialabs.xlrelease.scm.connector.GitLabCommitResponse;
import com.xebialabs.xlrelease.scm.connector.GitLabProjectResponse;
import com.xebialabs.xlrelease.scm.connector.GitLabTree;
import com.xebialabs.xlrelease.scm.connector.HttpClientRequest$;
import com.xebialabs.xlrelease.scm.connector.RestApiScmConnector;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmHttpClientWrapper;
import com.xebialabs.xlrelease.scm.connector.ValidatedCommitInfo;
import java.io.Serializable;
import java.util.Base64;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001\u0002\b\u0010\u0001iA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006Y\u0001!\t&\f\u0005\u0006u\u0001!\tf\u000f\u0005\u00061\u0002!\t&\u0017\u0005\u0006A\u0002!\t!\u0019\u0005\u0006E\u0002!Ia\u0019\u0005\u0006[\u0002!IA\u001c\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\tY\u0002\u0001C\u0005\u0003;Aq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\t\u0011r)\u001b;MC\n\u001c6-\\\"p]:,7\r^8s\u0015\t\u0001\u0012#A\u0005d_:tWm\u0019;pe*\u0011!cE\u0001\u0004g\u000el'B\u0001\u000b\u0016\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0017/\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0007\t\u00039ui\u0011aD\u0005\u0003==\u00111CU3ti\u0006\u0003\u0018nU2n\u0007>tg.Z2u_J\faaY8oM&<\u0007CA\u0011'\u001b\u0005\u0011#B\u0001\t$\u0015\t\u0011BE\u0003\u0002&'\u00051Am\\7bS:L!a\n\u0012\u00031\u001dKG\u000fT1c'\u000el7i\u001c8oK\u000e$xN]\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0003U-\u0002\"\u0001\b\u0001\t\u000b}\u0011\u0001\u0019\u0001\u0011\u0002\u001dQ,7\u000f\u001e*fa>\u001c\u0018\u000e^8ssV\ta\u0006E\u00020iYj\u0011\u0001\r\u0006\u0003cI\nA!\u001e;jY*\t1'A\u0003tG\u0006d\u0017-\u0003\u00026a\t\u0019AK]=\u0011\u0005]BT\"\u0001\u001a\n\u0005e\u0012$\u0001B+oSR\fAbY8n[&$\u0018I\u001c3UC\u001e$B\u0001\u0010%N%B\u0019q\u0006N\u001f\u0011\u0005y*eBA D!\t\u0001%'D\u0001B\u0015\t\u0011\u0015$\u0001\u0004=e>|GOP\u0005\u0003\tJ\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011AI\r\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u0006E2|'m\u001d\t\u00039-K!\u0001T\b\u0003\u000b\tcwNY:\t\u000b9#\u0001\u0019A(\u0002\u0015\r|W.\\5u\u0013:4w\u000e\u0005\u0002\u001d!&\u0011\u0011k\u0004\u0002\u0014-\u0006d\u0017\u000eZ1uK\u0012\u001cu.\\7ji&sgm\u001c\u0005\u0006'\u0012\u0001\r\u0001V\u0001\u0005kN,'\u000f\u0005\u0002V-6\tA%\u0003\u0002XI\tYQk]3s!J|g-\u001b7f\u00035!\u0018m\u001a(piB\u0013Xm]3oiR\u0011!L\u0018\t\u0004_QZ\u0006CA\u001c]\u0013\ti&GA\u0004C_>dW-\u00198\t\u000b}+\u0001\u0019A\u001f\u0002\u0007Q\fw-\u0001\u0007de\u0016\fG/\u001a\"sC:\u001c\u0007\u000eF\u0001/\u00031\u0019'/Z1uK\u000e{W.\\5u)\t!\u0007\u000eE\u00020i\u0015\u0004\"\u0001\b4\n\u0005\u001d|!\u0001F$ji2\u000b'mQ8n[&$(+Z:q_:\u001cX\rC\u0003j\u000f\u0001\u0007!.A\u0006sKF,Xm\u001d;C_\u0012L\bC\u0001\u000fl\u0013\tawB\u0001\u0007HSRd\u0015MY\"p[6LG/A\u0005de\u0016\fG/\u001a+bOR)q.!\u0002\u0002\nA\u0019q\u0006\u000e9\u0011\u0007ED(0D\u0001s\u0015\t\u0019H/\u0001\u0003iiR\u0004(BA;w\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A<\u0002\u0007=\u0014x-\u0003\u0002ze\nq!+Z:q_:\u001cX-\u00128uSRL\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006!A.\u00198h\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001}\u0005\u00111v.\u001b3\t\r\u0005\u001d\u0001\u00021\u0001>\u0003\u001d!\u0018m\u001a(b[\u0016Da!a\u0003\t\u0001\u0004i\u0014aA:iC\u000612M]3bi\u0016$5\u000f\u001c*fcV,7\u000f^!di&|g\u000e\u0006\u0003\u0002\u0012\u0005e\u0001\u0003B\u00185\u0003'\u00012\u0001HA\u000b\u0013\r\t9b\u0004\u0002\u0013\u000f&$H*\u00192D_6l\u0017\u000e^!di&|g\u000eC\u0003J\u0013\u0001\u0007!*\u0001\u0010de\u0016\fG/Z!ui\u0006\u001c\u0007.\\3oiN\u0014V-];fgR\f5\r^5p]R!\u0011qDA\u001a!\u0011yC'!\t\u0011\r\u0005\r\u0012QFA\n\u001d\u0011\t)#!\u000b\u000f\u0007\u0001\u000b9#C\u00014\u0013\r\tYCM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty#!\r\u0003\t1K7\u000f\u001e\u0006\u0004\u0003W\u0011\u0004\"B%\u000b\u0001\u0004Q\u0015\u0001\u0003:fa>t\u0015-\\3\u0016\u0003u\n\u0011\"\u001e:m\u000b:\u001cw\u000eZ3\u0015\u0007u\ni\u0004\u0003\u0004\u0002@1\u0001\r!P\u0001\u0006m\u0006dW/Z\u0001\u000eO&$H*\u00192SKF,Xm\u001d;\u0016\u0005\u0005\u0015\u0003c\u0001\u000f\u0002H%\u0019\u0011\u0011J\b\u0003)M\u001bW\u000e\u0013;ua\u000ec\u0017.\u001a8u/J\f\u0007\u000f]3s\u0001")
public class GitLabScmConnector
extends RestApiScmConnector {
    private final GitLabScmConnectorConfig config;

    @Override
    public Try<BoxedUnit> testRepository() {
        return this.gitLabRequest().get(new StringBuilder(10).append("/projects/").append(this.repoName()).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$1 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$1).tried()).map((Function1 & Serializable)x$2 -> {
            GitLabScmConnector.$anonfun$testRepository$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return this.createBranch().flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            Try try_ = this.createDslRequestAction(blobs).flatMap((Function1 & Serializable)dslCommitAction -> this.createAttachmentsRequestAction(blobs).flatMap((Function1 & Serializable)attachmentCommitAction -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
                GitLabCommitAction gitLabCommitAction = dslCommitAction;
                return new GitLabCommit($this.config.branch(), commitInfo.message(), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)attachmentCommitAction.$colon$colon((Object)gitLabCommitAction)).asJavaCollection());
            }).flatMap((Function1 & Serializable)requestBody -> this.createCommit((GitLabCommit)requestBody).flatMap((Function1 & Serializable)gitCommitInfo -> this.createTag(commitInfo.tag().refName(), gitCommitInfo.id()).map((Function1 & Serializable)x$3 -> {
                ResponseEntity responseEntity = x$3;
                String string = gitCommitInfo.id();
                return string;
            })))));
            return try_;
        });
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this.gitLabRequest().get(new StringBuilder(27).append("/projects/").append(this.repoName()).append("/repository/tags/").append(tag).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GitLabScmConnector.$anonfun$tagNotPresent$1(x$5)));
    }

    public Try<BoxedUnit> createBranch() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ResponseEntity projectResponse = (ResponseEntity)this.gitLabRequest().get(new StringBuilder(10).append("/projects/").append(this.repoName()).toString()).doRequest(ClassTag$.MODULE$.apply(GitLabProjectResponse.class)).get();
            if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(projectResponse).isSuccessful()) {
                throw new ScmException("Unable to retrieve default branch", null, projectResponse.getStatusCodeValue());
            }
            boolean exist = HttpClientRequest$.MODULE$.ResponseEntityExtension((ResponseEntity)this.gitLabRequest().get(new StringBuilder(31).append("/projects/").append(this.repoName()).append("/repository/branches/").append($this.config.branch()).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).get()).isSuccessful();
            if (!exist) {
                ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("ref", ((GitLabProjectResponse)projectResponse.getBody()).default_branch()).addQueryParam("branch", $this.config.branch());
                String x$1 = new StringBuilder(30).append("/projects/").append(this.repoName()).append("/repository/branches").toString();
                Null$ x$2 = qual$1.post$default$2();
                ResponseEntity response = (ResponseEntity)qual$1.post(x$1, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
                if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    throw new ScmException("Unable to create branch", null, response.getStatusCodeValue());
                }
            }
        });
    }

    private Try<GitLabCommitResponse> createCommit(GitLabCommit requestBody) {
        return this.gitLabRequest().post(new StringBuilder(29).append("/projects/").append(this.repoName()).append("/repository/commits").toString(), requestBody).doRequest(ClassTag$.MODULE$.apply(GitLabCommitResponse.class)).flatMap((Function1 & Serializable)x$6 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$6).checkResponse("Error occured while trying to commit on GitLab")).map((Function1 & Serializable)x$7 -> (GitLabCommitResponse)x$7.getBody());
    }

    private Try<ResponseEntity<Void>> createTag(String tagName, String sha) {
        ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("tag_name", tagName).addQueryParam("ref", sha);
        String x$1 = new StringBuilder(26).append("/projects/").append(this.repoName()).append("/repository/tags").toString();
        Null$ x$2 = qual$1.post$default$2();
        return qual$1.post(x$1, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$8 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$8).checkResponse("Error occurred while trying to create tag"));
    }

    private Try<GitLabCommitAction> createDslRequestAction(Blobs blobs) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).get(new StringBuilder(28).append("/projects/").append(this.repoName()).append("/repository/files/").append(this.urlEncode(blobs.templateFilePath())).toString()).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
            HttpStatus httpStatus = response.getStatusCode();
            HttpStatus httpStatus2 = HttpStatus.UNAUTHORIZED;
            if (!(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null)) {
                throw new ScmException("Unable to connect to the repository.", null, response.getStatusCodeValue());
            }
            return HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful();
        }).collect((PartialFunction)new Serializable(null, blobs){
            private static final long serialVersionUID = 0L;
            private final Blobs blobs$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                GitLabCommitAction gitLabCommitAction = true == A1 ? new GitLabCommitAction("update", this.blobs$2.templateFilePath(), Base64.getEncoder().encodeToString((byte[])this.blobs$2.dsl().getContent().apply()), "base64") : new GitLabCommitAction("create", this.blobs$2.templateFilePath(), Base64.getEncoder().encodeToString((byte[])this.blobs$2.dsl().getContent().apply()), "base64");
                return (B1)gitLabCommitAction;
            }

            public final boolean isDefinedAt(boolean x1) {
                boolean bl = x1;
                boolean bl2 = bl ? true : true;
                return bl2;
            }
            {
                this.blobs$2 = blobs$2;
            }
        });
    }

    private Try<List<GitLabCommitAction>> createAttachmentsRequestAction(Blobs blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List list2;
            if (blobs.attachments().files().isEmpty()) {
                list2 = package$.MODULE$.List().empty();
            } else {
                Set set;
                ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).addQueryParam("path", blobs.attachments().folderName()).get(new StringBuilder(26).append("/projects/").append(this.repoName()).append("/repository/tree").toString()).doRequest(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(GitLabTree.class))).get();
                if (HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    set = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])response.getBody()), (Function1 & Serializable)x$9 -> x$9.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
                } else {
                    HttpStatus httpStatus = response.getStatusCode();
                    HttpStatus httpStatus2 = HttpStatus.NOT_FOUND;
                    if (!(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null)) {
                        set = Predef$.MODULE$.Set().empty();
                    } else {
                        throw new ScmException("Unable to list repository tree", null, response.getStatusCodeValue());
                    }
                }
                Set existingAttachments = set;
                list2 = (List)((IterableOnceOps)blobs.attachments().files().view().filterNot((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)existingAttachments.contains((Object)file.fileName())))).foldLeft((Object)package$.MODULE$.List().empty(), (Function2 & Serializable)(list, file) -> {
                    GitLabCommitAction gitLabCommitAction = new GitLabCommitAction("create", new StringBuilder(1).append(blobs.attachments().folderName()).append("/").append(file.fileName()).toString(), Base64.getEncoder().encodeToString((byte[])file.getContent().apply()), "base64");
                    return list.$colon$colon((Object)gitLabCommitAction);
                });
            }
            return list2;
        });
    }

    private String repoName() {
        return this.urlEncode(this.config.repository());
    }

    private String urlEncode(String value) {
        return UrlEscapers.urlPathSegmentEscaper().escape(value);
    }

    private ScmHttpClientWrapper gitLabRequest() {
        return HttpClientRequest$.MODULE$.newRequest(this.config.restApiUrl()).setUriEncoded(true).withAuth(this.config.credential());
    }

    public static final /* synthetic */ void $anonfun$testRepository$2(Void x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(ResponseEntity x$5) {
        HttpStatus httpStatus = x$5.getStatusCode();
        HttpStatus httpStatus2 = HttpStatus.NOT_FOUND;
        return !(httpStatus != null ? !httpStatus.equals(httpStatus2) : httpStatus2 != null);
    }

    public GitLabScmConnector(GitLabScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

