/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\n\u0014\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!i\u0004A!A!\u0002\u0013q\u0004\"\u0002#\u0001\t\u0003)\u0005\"\u0002/\u0001\t\u0003i\u0006\"B6\u0001\t\u0003a\u0007\"CA\r\u0001E\u0005I\u0011AA\u000e\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\tY\u000b\u0001C\u0005\u0003[\u0013a#R7bS2\u0014VmY5qS\u0016tGOU3t_24XM\u001d\u0006\u0003)U\tQ!Z7bS2T!AF\f\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\tA\u0012$A\u0005yYJ,G.Z1tK*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u0011M,7-\u001e:jifT!aK\r\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!\f\u0015\u0003\u0017I{G.Z*feZL7-Z\u0001\fi\u0016\fWnU3sm&\u001cW\r\u0005\u00021g5\t\u0011G\u0003\u00023/\u000591/\u001a:wS\u000e,\u0017B\u0001\u001b2\u0005-!V-Y7TKJ4\u0018nY3\u0002%U\u001cXM\u001d)s_\u001aLG.Z*feZL7-\u001a\t\u0003a]J!\u0001O\u0019\u0003%U\u001bXM\u001d)s_\u001aLG.Z*feZL7-Z\u0001\u0016aJLgnY5qC2LeNZ8SKN|GN^3s!\t\u00014(\u0003\u0002=c\t)\u0002K]5oG&\u0004\u0018\r\\%oM>\u0014Vm]8mm\u0016\u0014\u0018!\u0003=me\u000e{gNZ5h!\ty$)D\u0001A\u0015\t\tu#\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0007\u0002\u0013\u0011\u0002\u00177s\u0007>tg-[4\u0002\rqJg.\u001b;?)\u00191\u0005*\u0013&L\u0019B\u0011q\tA\u0007\u0002'!)QE\u0002a\u0001M!)aF\u0002a\u0001_!)QG\u0002a\u0001m!)\u0011H\u0002a\u0001u!)QH\u0002a\u0001}!\u0012aA\u0014\t\u0003\u001fjk\u0011\u0001\u0015\u0006\u0003#J\u000b!\"\u00198o_R\fG/[8o\u0015\t\u0019F+A\u0004gC\u000e$xN]=\u000b\u0005U3\u0016!\u00022fC:\u001c(BA,Y\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A-\u0002\u0007=\u0014x-\u0003\u0002\\!\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0011e\u0016\u001cx\u000e\u001c<f%\u0016\u001c\u0017\u000e]5f]R$\"AX5\u0011\u0005}3gB\u00011e!\t\t\u0017%D\u0001c\u0015\t\u0019W$\u0001\u0004=e>|GOP\u0005\u0003K\u0006\na\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q-\t\u0005\u0006U\u001e\u0001\rAX\u0001\u000eaJLgnY5qC2t\u0015-\\3\u0002#I,7o\u001c7wKJ+7-\u001b9jK:$8\u000fF\u0004nanlx0a\u0004\u0011\u0007}sg,\u0003\u0002pQ\n\u00191+\u001a;\t\u000bED\u0001\u0019\u0001:\u0002\u000bI|G.Z:\u0011\u0007MDhL\u0004\u0002um:\u0011\u0011-^\u0005\u0002E%\u0011q/I\u0001\ba\u0006\u001c7.Y4f\u0013\tI(P\u0001\u0003MSN$(BA<\"\u0011\u0015a\b\u00021\u0001s\u0003-9Gn\u001c2bYJ{G.Z:\t\u000byD\u0001\u0019\u0001:\u0002\u000bU\u001cXM]:\t\u000f\u0005\u0005\u0001\u00021\u0001\u0002\u0004\u0005A\u0001\u000f\\1o\u0013R,W\u000e\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIaF\u0001\u0007I>l\u0017-\u001b8\n\t\u00055\u0011q\u0001\u0002\t!2\fg.\u0013;f[\"I\u0011\u0011\u0003\u0005\u0011\u0002\u0003\u0007\u00111C\u0001\u000eKb\u001cG.\u001e3f\u0003V$\bn\u001c:\u0011\u0007\u0001\n)\"C\u0002\u0002\u0018\u0005\u0012qAQ8pY\u0016\fg.A\u000esKN|GN^3SK\u000eL\u0007/[3oiN$C-\u001a4bk2$H%N\u000b\u0003\u0003;QC!a\u0005\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\tY#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GM\u0003\u0002RC%!\u0011QFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000b]>$\u0018NZ=Vg\u0016\u0014H\u0003BA\n\u0003gAa!!\u000e\u000b\u0001\u0004q\u0016\u0001C;tKJt\u0017-\\3\u0002\u0015A\f'o]3S_2,7\u000fF\u0005n\u0003w\t9%!\u0013\u0002L!9\u0011QH\u0006A\u0002\u0005}\u0012aC1tg&<g.\\3oiN\u0004Ba\u001d=\u0002BA\u0019q%a\u0011\n\u0007\u0005\u0015\u0003F\u0001\u0003S_2,\u0007\"B9\f\u0001\u0004\u0011\bbBA\u0001\u0017\u0001\u0007\u00111\u0001\u0005\b\u0003\u001bZ\u0001\u0019AA(\u0003\u0015\u0019\u0017m\u00195f!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0004\u00033:\u0012aA1qS&!\u0011QLA*\u0005=!UmY8sCR|'o]\"bG\",\u0017A\u00049beN,G+Y:l%>dWm\u001d\u000b\n[\u0006\r\u0014QNA8\u0003cBq!!\u001a\r\u0001\u0004\t9'\u0001\u0003uCN\\\u0007\u0003BA\u0003\u0003SJA!a\u001b\u0002\b\t!A+Y:l\u0011\u0015\tH\u00021\u0001s\u0011\u001d\ti\u0004\u0004a\u0001\u0003\u007fAq!!\u0014\r\u0001\u0004\ty%A\tqCJ\u001cXMU3mK\u0006\u001cXMU8mKN$\u0012\"\\A<\u0003\u0003\u000b\u0019)!\"\t\u000f\u0005eT\u00021\u0001\u0002|\u00059!/\u001a7fCN,\u0007\u0003BA\u0003\u0003{JA!a \u0002\b\t9!+\u001a7fCN,\u0007\"B9\u000e\u0001\u0004\u0011\bbBA\u001f\u001b\u0001\u0007\u0011q\b\u0005\b\u0003\u001bj\u0001\u0019AA(\u0003E9W\r\u001e*fY\u0016\f7/Z'f[\n,'o\u001d\u000b\t\u0003\u0017\u000b\t*a%\u0002\u0016B!\u0001%!$n\u0013\r\ty)\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005ed\u00021\u0001\u0002|!9\u0011Q\b\bA\u0002\u0005}\u0002bBA'\u001d\u0001\u0007\u0011qJ\u0001\u0011a\u0006\u00148/Z$m_\n\fGNU8mKN$RA]AN\u0003;Cq!!\u0010\u0010\u0001\u0004\ty\u0004C\u0003}\u001f\u0001\u0007!/\u0001\tqCJ\u001cXMR8mI\u0016\u0014H+Z1ngRIQ.a)\u0002&\u0006\u001d\u0016\u0011\u0016\u0005\b\u0003{\u0001\u0002\u0019AA \u0011\u0015\t\b\u00031\u0001s\u0011\u001d\t\t\u0001\u0005a\u0001\u0003\u0007Aq!!\u0014\u0011\u0001\u0004\ty%A\u0007hKR\fE\u000e\\'f[\n,'o\u001d\u000b\u0006[\u0006=\u0016\u0011\u0018\u0005\b\u0003c\u000b\u0002\u0019AAZ\u0003\u0011!X-Y7\u0011\t\u0005\u0015\u0011QW\u0005\u0005\u0003o\u000b9A\u0001\u0003UK\u0006l\u0007bBA\u001f#\u0001\u0007\u0011q\b\u0015\u0004\u0001\u0005u\u0006\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\rg+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a2\u0002B\n91+\u001a:wS\u000e,\u0007")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;
    private final XlrConfig xlrConfig;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.readRoleAssignments()).asScala().toList();
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        Set allPrincipals = (Set)((SetOps)this.parseRoles((List<Role>)assignments, roles, planItem, cache).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(this.parseFolderTeams((List<Role>)assignments, roles, planItem, cache)).$plus$plus(users)).$minus$minus((IterableOnce)(excludeAuthor ? (IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : package$.MODULE$.Nil()));
        return (Set)((IterableOps)((IterableOps)allPrincipals.filter((Function1 & Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.notifyUser(username)))).map((Function1 & Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private boolean notifyUser(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        return profile != null ? profile.isLoginAllowed() || this.xlrConfig.isNotifyInactiveUsers() : true;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments, cache);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments, cache);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((IterableOnce)this.getReleaseMembers(task.getRelease(), assignments, cache).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil()));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = CollectionConverters$.MODULE$.SetHasAsScala(task.getWatchers()).asScala().toSet();
            watchers.foreach((Function1 & Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((IterableOnce)this.getReleaseMembers(release, assignments, cache).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil()));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments, DecoratorsCache cache) {
        Option effectiveTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(release, cache)).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        List list3 = !(nil$ != null ? !nil$.equals(list2) : list2 != null) ? (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : assignments.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName()))).flatMap((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7.getPrincipals()).asScala().toList());
        return list3;
    }

    private Set<String> parseFolderTeams(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        ObjectRef parsed;
        block0: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            List folderTeams = (List)roles.diff((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{RecipientSettings.RELEASE_ADMIN_ROLE_NAME, "Task Owner", "Task Team", "Watcher"})));
            String folderId = Ids.findFolderId((String)planItem.getId());
            if (!Strings.isNotEmpty((String)folderId) || Ids.isRoot((String)folderId)) break block0;
            this.teamService.findTeamsByNames(folderId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)folderTeams).asJava(), cache).forEach(x$8 -> {
                parsed$2.elem = (Set)((Set)parsed$2.elem).$plus$plus(this.getAllMembers((Team)x$8, assignments));
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = CollectionConverters$.MODULE$.ListHasAsScala(team.getMembers()).asScala().toSet();
        List roleMembers = CollectionConverters$.MODULE$.ListHasAsScala(team.getRoles()).asScala().toList().flatMap((Function1 & Serializable)roleName -> assignments.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$9))).toList().flatMap((Function1 & Serializable)role -> CollectionConverters$.MODULE$.ListHasAsScala(role.getPrincipals()).asScala().toList().map((Function1 & Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        })));
        return (Set)teamMembers.$plus$plus((IterableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim()))));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$9) {
        String string = x$9.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver, XlrConfig xlrConfig) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
        this.xlrConfig = xlrConfig;
    }
}

