/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.validators;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator$;
import com.xebialabs.xlrelease.notifications.configuration.BasicSmtpAuthentication;
import com.xebialabs.xlrelease.notifications.configuration.OAuth2SmtpAuthentication;
import com.xebialabs.xlrelease.notifications.configuration.SmtpAuthentication;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005E3A!\u0002\u0004\u0001#!)A\u0006\u0001C\u0001[!)\u0001\u0007\u0001C!c!)\u0001\u0007\u0001C\u0005\u007f!)\u0001\u0007\u0001C\u0005\u0015\n\u00192+\u001c;q'\u0016\u0014h/\u001a:WC2LG-\u0019;pe*\u0011q\u0001C\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u001c(BA\u0005\u000b\u00035qw\u000e^5gS\u000e\fG/[8og*\u00111\u0002D\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0004\b\u0002\u0013a,'-[1mC\n\u001c(\"A\b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0011\"\u0004\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!A.\u00198h\u0015\u00059\u0012\u0001\u00026bm\u0006L!!\u0007\u000b\u0003\r=\u0013'.Z2u!\rYBEJ\u0007\u00029)\u0011QDH\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\u0010!\u0003\r\t\u0007/\u001b\u0006\u0003C\t\na\u0001\u001d7vO&t'BA\u0012\r\u0003!!W\r\u001d7ps&$\u0018BA\u0013\u001d\u0005%1\u0016\r\\5eCR|'\u000f\u0005\u0002(U5\t\u0001F\u0003\u0002*\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!a\u000b\u0015\u0003\u0015MkG\u000f]*feZ,'/\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002\r\u0005Aa/\u00197jI\u0006$X\rF\u00023qi\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012A!\u00168ji\")\u0011H\u0001a\u0001M\u0005Q1/\u001c;q'\u0016\u0014h/\u001a:\t\u000bm\u0012\u0001\u0019\u0001\u001f\u0002\u000f\r|g\u000e^3yiB\u00111$P\u0005\u0003}q\u0011\u0011CV1mS\u0012\fG/[8o\u0007>tG/\u001a=u)\r\u0011\u0004)\u0012\u0005\u0006\u0003\u000e\u0001\rAQ\u0001\u0018E\u0006\u001c\u0018nY*niB\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004\"aJ\"\n\u0005\u0011C#a\u0006\"bg&\u001c7+\u001c;q\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0011\u001515\u00011\u0001H\u0003=)\u0007\u0010^3oI\u0016$7i\u001c8uKb$\bCA\u000eI\u0013\tIEDA\rFqR,g\u000eZ3e-\u0006d\u0017\u000eZ1uS>t7i\u001c8uKb$Hc\u0001\u001aL!\")A\n\u0002a\u0001\u001b\u0006Ar.Y;uQJ\u001aV\u000e\u001e9BkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0011\u0005\u001dr\u0015BA()\u0005ay\u0015)\u001e;ieMkG\u000f]!vi\",g\u000e^5dCRLwN\u001c\u0005\u0006\r\u0012\u0001\ra\u0012")
public class SmtpServerValidator
implements Validator<SmtpServer> {
    public void validate(SmtpServer smtpServer, ValidationContext context) {
        SmtpAuthentication smtpAuthentication;
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        if (Strings.isNullOrEmpty((String)smtpServer.host())) {
            extendedContext.error((ConfigurationItem)smtpServer, "host", "SMTP server host cannot be blank", new Object[0]);
        }
        if (smtpServer.port() < 0 || smtpServer.port() > 65535) {
            extendedContext.error((ConfigurationItem)smtpServer, "port", "SMTP server port is out of range", new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)smtpServer.fromAddress())) {
            extendedContext.error((ConfigurationItem)smtpServer, "fromAddress", "From address is required", new Object[0]);
        }
        if (!Strings.isNullOrEmpty((String)smtpServer.fromAddress()) && !UserAccountValidator$.MODULE$.isValidEmailAddress(smtpServer.fromAddress())) {
            extendedContext.error((ConfigurationItem)smtpServer, "fromAddress", new StringBuilder(29).append(smtpServer.fromAddress()).append(" is not a valid email address").toString(), new Object[0]);
        }
        if (!Strings.isNullOrEmpty((String)smtpServer.testAddress())) {
            List recipientsList = Predef$.MODULE$.wrapRefArray((Object[])smtpServer.getTestAddress().split(",")).toList();
            recipientsList.foreach((Function1 & Serializable)recipient -> {
                SmtpServerValidator.$anonfun$validate$1(extendedContext, smtpServer, recipient);
                return BoxedUnit.UNIT;
            });
        }
        if ((smtpAuthentication = smtpServer.authentication()) == null) {
            extendedContext.error((ConfigurationItem)smtpServer, "authentication", "Authentication method is required", new Object[0]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (smtpAuthentication instanceof BasicSmtpAuthentication) {
            BasicSmtpAuthentication basicSmtpAuthentication = (BasicSmtpAuthentication)smtpAuthentication;
            this.validate(basicSmtpAuthentication, extendedContext);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (smtpAuthentication instanceof OAuth2SmtpAuthentication) {
            OAuth2SmtpAuthentication oAuth2SmtpAuthentication = (OAuth2SmtpAuthentication)smtpAuthentication;
            this.validate(oAuth2SmtpAuthentication, extendedContext);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void validate(BasicSmtpAuthentication basicSmtpAuthentication, ExtendedValidationContext extendedContext) {
        block1: {
            if (Strings.isNullOrEmpty((String)basicSmtpAuthentication.username())) {
                extendedContext.error((ConfigurationItem)basicSmtpAuthentication, "username", "Username cannot be blank", new Object[0]);
            }
            if (!Strings.isNullOrEmpty((String)basicSmtpAuthentication.password())) break block1;
            extendedContext.error((ConfigurationItem)basicSmtpAuthentication, "password", "Password cannot be blank", new Object[0]);
        }
    }

    private void validate(OAuth2SmtpAuthentication oauth2SmtpAuthentication, ExtendedValidationContext extendedContext) {
        block3: {
            if (Strings.isNullOrEmpty((String)oauth2SmtpAuthentication.accessTokenUrl())) {
                extendedContext.error((ConfigurationItem)oauth2SmtpAuthentication, "accessTokenUrl", "Access Token URL cannot be blank", new Object[0]);
            }
            if (Strings.isNullOrEmpty((String)oauth2SmtpAuthentication.clientId())) {
                extendedContext.error((ConfigurationItem)oauth2SmtpAuthentication, "clientId", "Client ID cannot be blank", new Object[0]);
            }
            if (Strings.isNullOrEmpty((String)oauth2SmtpAuthentication.clientSecret())) {
                extendedContext.error((ConfigurationItem)oauth2SmtpAuthentication, "clientSecret", "Client secret cannot be blank", new Object[0]);
            }
            if (!Strings.isNullOrEmpty((String)oauth2SmtpAuthentication.refreshToken())) break block3;
            extendedContext.error((ConfigurationItem)oauth2SmtpAuthentication, "refreshToken", "Refresh token cannot be blank", new Object[0]);
        }
    }

    public static final /* synthetic */ void $anonfun$validate$1(ExtendedValidationContext extendedContext$1, SmtpServer smtpServer$1, String recipient) {
        block0: {
            if (UserAccountValidator$.MODULE$.isValidEmailAddress(recipient)) break block0;
            extendedContext$1.error((ConfigurationItem)smtpServer$1, "testAddress", new StringBuilder(29).append(recipient).append(" is not a valid email address").toString(), new Object[0]);
        }
    }
}

