/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.ws;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.parsing.HttpHeaderParser$;
import akka.http.impl.engine.parsing.HttpMessageParser;
import akka.http.impl.engine.parsing.HttpResponseParser;
import akka.http.impl.engine.parsing.ParserOutput;
import akka.http.impl.engine.parsing.ParserOutput$MessageEnd$;
import akka.http.impl.engine.parsing.ParserOutput$NeedMoreData$;
import akka.http.impl.engine.rendering.HttpRequestRendererFactory$;
import akka.http.impl.engine.rendering.RequestRenderingContext;
import akka.http.impl.engine.rendering.RequestRenderingContext$;
import akka.http.impl.engine.ws.Handshake;
import akka.http.impl.engine.ws.Handshake$Client$;
import akka.http.impl.engine.ws.WebSocket$;
import akka.http.impl.engine.ws.WebSocketClientBlueprint;
import akka.http.impl.engine.ws.WebSocketClientBlueprint$UpgradeStage$1$;
import akka.http.impl.util.LogByteStringTools$;
import akka.http.impl.util.SingletonException;
import akka.http.impl.util.StreamUtils;
import akka.http.impl.util.StreamUtils$OneTimeValve$;
import akka.http.scaladsl.model.AttributeKey;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Host$;
import akka.http.scaladsl.model.headers.Sec$minusWebSocket$minusKey;
import akka.http.scaladsl.model.ws.InvalidUpgradeResponse;
import akka.http.scaladsl.model.ws.Message;
import akka.http.scaladsl.model.ws.ValidUpgrade;
import akka.http.scaladsl.model.ws.WebSocketRequest;
import akka.http.scaladsl.model.ws.WebSocketUpgradeResponse;
import akka.http.scaladsl.settings.ClientConnectionSettings;
import akka.http.scaladsl.settings.WebSocketSettings;
import akka.stream.Attributes;
import akka.stream.BidiShape;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.Shape;
import akka.stream.SourceShape;
import akka.stream.TLSProtocol;
import akka.stream.UniformFanInShape;
import akka.stream.impl.fusing.GraphStages;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Concat$;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Source$;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Random;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@InternalApi
public final class WebSocketClientBlueprint$ {
    public static final WebSocketClientBlueprint$ MODULE$ = new WebSocketClientBlueprint$();

    public BidiFlow<Message, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, Message, Future<WebSocketUpgradeResponse>> apply(WebSocketRequest request, ClientConnectionSettings settings, LoggingAdapter log) {
        boolean x$1 = false;
        WebSocketSettings x$2 = settings.websocketSettings();
        LoggingAdapter x$3 = log;
        FiniteDuration x$4 = WebSocket$.MODULE$.stack$default$3();
        return LogByteStringTools$.MODULE$.logTLSBidiBySetting("client-plain-text", settings.logUnencryptedNetworkBytes()).reversed().atop(this.simpleTls()).atopMat(this.handshake(request, settings, log), Keep$.MODULE$.right()).atop(WebSocket$.MODULE$.framing()).atop(WebSocket$.MODULE$.stack(false, x$2, x$4, x$3)).reversed();
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, Future<WebSocketUpgradeResponse>> handshake(WebSocketRequest request, ClientConnectionSettings settings, LoggingAdapter log) {
        Promise result = Promise$.MODULE$.apply();
        StreamUtils.OneTimeValve valve = StreamUtils$OneTimeValve$.MODULE$.apply();
        List subprotocols = request.subprotocol().toList().flatMap((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])x$1.split(","))).map((Function1 & Serializable)x$2 -> x$2.trim());
        Tuple2<HttpRequest, Sec$minusWebSocket$minusKey> tuple2 = Handshake$Client$.MODULE$.buildRequest(request.uri(), request.extraHeaders(), (Seq<String>)subprotocols, (Random)settings.websocketRandomFactory().apply());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HttpRequest initialRequest = (HttpRequest)tuple2._1();
        Sec$minusWebSocket$minusKey key = (Sec$minusWebSocket$minusKey)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)initialRequest, (Object)key);
        Tuple2 tuple23 = tuple22;
        HttpRequest initialRequest2 = (HttpRequest)tuple23._1();
        Sec$minusWebSocket$minusKey key2 = (Sec$minusWebSocket$minusKey)tuple23._2();
        Host hostHeader = Host$.MODULE$.apply(request.uri().authority().normalizedFor(request.uri().scheme()));
        ByteString renderedInitialRequest = HttpRequestRendererFactory$.MODULE$.renderStrict(new RequestRenderingContext(initialRequest2, hostHeader, RequestRenderingContext$.MODULE$.apply$default$3()), settings, log);
        return BidiFlow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create(arg_0 -> WebSocketClientBlueprint$.$anonfun$handshake$3(renderedInitialRequest, valve, settings, log, (Seq)subprotocols, key2, result, request, arg_0))).mapMaterializedValue((Function1 & Serializable)x$4 -> result.future());
    }

    public BidiFlow<TLSProtocol.SslTlsInbound, ByteString, ByteString, TLSProtocol.SendBytes, NotUsed> simpleTls() {
        return BidiFlow$.MODULE$.fromFlowsMat((Graph)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TLSProtocol.SessionBytes) {
                    TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)A1;
                    ByteString bytes = sessionBytes.bytes();
                    object = bytes;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
                TLSProtocol.SslTlsInbound sslTlsInbound = x1;
                boolean bl = sslTlsInbound instanceof TLSProtocol.SessionBytes;
                return bl;
            }
        }), (Graph)Flow$.MODULE$.apply().map((Function1)TLSProtocol.SendBytes$.MODULE$), Keep$.MODULE$.none());
    }

    public static final /* synthetic */ BidiShape $anonfun$handshake$3(ByteString renderedInitialRequest$1, StreamUtils.OneTimeValve valve$1, ClientConnectionSettings settings$1, LoggingAdapter log$1, Seq subprotocols$1, Sec$minusWebSocket$minusKey key$1, Promise result$1, WebSocketRequest request$1, GraphDSL.Builder b) {
        public class Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1
        extends GraphStages.SimpleLinearGraphStage<ByteString> {
            public final ClientConnectionSettings settings$1;
            public final LoggingAdapter log$1;
            public final Seq subprotocols$1;
            public final Sec$minusWebSocket$minusKey key$1;
            public final Promise result$1;
            public final StreamUtils.OneTimeValve valve$1;
            public final WebSocketRequest request$1;

            public GraphStageLogic createLogic(Attributes attributes) {
                return new InHandler(this){
                    private final HttpResponseParser parser;
                    private final /* synthetic */ Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    private HttpResponseParser parser() {
                        return this.parser;
                    }

                    public void onPush() {
                        ParserOutput.ResponseOutput responseOutput = (ParserOutput.ResponseOutput)this.parser().parseBytes((ByteString)this.grab(this.$outer.in()));
                        if (ParserOutput$NeedMoreData$.MODULE$.equals(responseOutput)) {
                            this.pull(this.$outer.in());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (responseOutput instanceof ParserOutput.ResponseStart) {
                            Right right;
                            Handshake.Client.NegotiatedWebSocketSettings negotiatedWebSocketSettings;
                            ParserOutput.ResponseStart responseStart = (ParserOutput.ResponseStart)responseOutput;
                            StatusCode status = responseStart.statusCode();
                            HttpProtocol protocol = responseStart.protocol();
                            Map<AttributeKey<?>, ?> attributes = responseStart.attributes();
                            List<HttpHeader> headers2 = responseStart.headers();
                            HttpResponse response = new HttpResponse(status, (Seq<HttpHeader>)headers2, attributes, HttpEntity$.MODULE$.Empty(), protocol);
                            Either<String, Handshake.Client.NegotiatedWebSocketSettings> either = Handshake$Client$.MODULE$.validateResponse(response, (Seq<String>)this.$outer.subprotocols$1, this.$outer.key$1);
                            if (either instanceof Right && (negotiatedWebSocketSettings = (Handshake.Client.NegotiatedWebSocketSettings)(right = (Right)either).value()) != null) {
                                ParserOutput.ResponseOutput parseResult;
                                Option<String> protocol2 = negotiatedWebSocketSettings.subprotocol();
                                this.$outer.result$1.success((Object)new ValidUpgrade(response, protocol2));
                                this.setHandler(this.$outer.in(), new InHandler(this){
                                    private final /* synthetic */ WebSocketClientBlueprint$UpgradeStage$1$.anon.1 $outer;

                                    public void onUpstreamFinish() throws Exception {
                                        InHandler.onUpstreamFinish$((InHandler)this);
                                    }

                                    public void onUpstreamFailure(Throwable ex) throws Exception {
                                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                                    }

                                    public void onPush() {
                                        this.$outer.push(this.$outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().out(), this.$outer.grab(this.$outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().in()));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        InHandler.$init$((InHandler)this);
                                    }
                                });
                                this.$outer.valve$1.open();
                                ParserOutput.ResponseOutput responseOutput2 = parseResult = this.parser().onPull();
                                ParserOutput$MessageEnd$ parserOutput$MessageEnd$ = ParserOutput$MessageEnd$.MODULE$;
                                Predef$.MODULE$.require(!(responseOutput2 != null ? !responseOutput2.equals(parserOutput$MessageEnd$) : parserOutput$MessageEnd$ != null), (Function0 & Serializable)() -> new StringBuilder(41).append("parseResult should be MessageEnd but was ").append(parseResult).toString());
                                ParserOutput.ResponseOutput responseOutput3 = this.parser().onPull();
                                if (ParserOutput$NeedMoreData$.MODULE$.equals(responseOutput3)) {
                                    this.pull(this.$outer.in());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else if (responseOutput3 instanceof ParserOutput.RemainingBytes) {
                                    ParserOutput.RemainingBytes remainingBytes = (ParserOutput.RemainingBytes)responseOutput3;
                                    ByteString bytes = remainingBytes.bytes();
                                    this.push(this.$outer.out(), bytes);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    throw new IllegalStateException(new StringBuilder(27).append("unexpected element of type ").append(responseOutput3.getClass()).toString());
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else if (either instanceof Left) {
                                Left left = (Left)either;
                                String problem = (String)left.value();
                                this.$outer.result$1.success((Object)new InvalidUpgradeResponse(response, new StringBuilder(30).append("WebSocket server at ").append(this.$outer.request$1.uri()).append(" returned ").append(problem).toString()));
                                this.failStage(new IllegalArgumentException(new StringBuilder(46).append("WebSocket upgrade did not finish because of '").append(problem).append("'").toString()));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                throw new MatchError(either);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            if (responseOutput instanceof ParserOutput.MessageStartError) {
                                ParserOutput.MessageStartError messageStartError = (ParserOutput.MessageStartError)responseOutput;
                                StatusCode statusCode = messageStartError.status();
                                ErrorInfo errorInfo = messageStartError.info();
                                throw new IllegalStateException(new StringBuilder(46).append("Message failed with status code ").append(statusCode).append("; Error info: ").append(errorInfo).toString());
                            }
                            throw new IllegalStateException(new StringBuilder(27).append("unexpected element of type ").append(responseOutput.getClass()).toString());
                        }
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }

                    public void onUpstreamFailure(Throwable ex) {
                        this.$outer.result$1.tryFailure((Throwable)new RuntimeException("Connection failed.", ex));
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    public /* synthetic */ Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1 akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        InHandler.$init$((InHandler)this);
                        OutHandler.$init$((OutHandler)this);
                        this.parser = new HttpResponseParser(this){
                            private boolean first;

                            private boolean first() {
                                return this.first;
                            }

                            private void first_$eq(boolean x$1) {
                                this.first = x$1;
                            }

                            public boolean handleInformationalResponses() {
                                return false;
                            }

                            public HttpMessageParser.StateResult parseMessage(ByteString input, int offset) {
                                HttpMessageParser.StateResult stateResult;
                                if (this.first()) {
                                    try {
                                        this.first_$eq(false);
                                        stateResult = super.parseMessage(input, offset);
                                    }
                                    catch (SingletonException t) {
                                        this.first_$eq(true);
                                        throw t;
                                    }
                                } else {
                                    this.emit(new ParserOutput.RemainingBytes(input.drop(offset)));
                                    stateResult = this.terminate();
                                }
                                return stateResult;
                            }
                            {
                                super($outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().settings$1.parserSettings(), HttpHeaderParser$.MODULE$.apply($outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().settings$1.parserSettings(), $outer.akka$http$impl$engine$ws$WebSocketClientBlueprint$UpgradeStage$$anon$$$outer().log$1));
                                this.first = true;
                            }
                        };
                        this.parser().setContextForNextResponse(new HttpResponseParser.ResponseContext(HttpMethods$.MODULE$.GET(), (Option<Promise<BoxedUnit>>)None$.MODULE$));
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPush$1(akka.http.impl.engine.parsing.ParserOutput$ResponseOutput )}, serializedLambda);
                    }
                };
            }

            public String toString() {
                return "UpgradeStage";
            }

            public Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1(ClientConnectionSettings settings$1, LoggingAdapter log$1, Seq subprotocols$1, Sec$minusWebSocket$minusKey key$1, Promise result$1, StreamUtils.OneTimeValve valve$1, WebSocketRequest request$1) {
                this.settings$1 = settings$1;
                this.log$1 = log$1;
                this.subprotocols$1 = subprotocols$1;
                this.key$1 = key$1;
                this.result$1 = result$1;
                this.valve$1 = valve$1;
                this.request$1 = request$1;
            }
        }
        FlowShape networkIn = (FlowShape)b.add((Graph)Flow$.MODULE$.apply().via((Graph)new Akka_http_impl_engine_ws_WebSocketClientBlueprint$UpgradeStage$1(settings$1, log$1, subprotocols$1, key$1, result$1, valve$1, request$1)));
        FlowShape wsIn = (FlowShape)b.add((Graph)Flow$.MODULE$.apply());
        SourceShape handshakeRequestSource = (SourceShape)b.add((Graph)Source$.MODULE$.single((Object)renderedInitialRequest$1).$plus$plus(valve$1.source()));
        UniformFanInShape httpRequestBytesAndThenWSBytes = (UniformFanInShape)b.add(Concat$.MODULE$.apply(Concat$.MODULE$.apply$default$1()));
        new GraphDSL.Implicits$.SourceShapeArrow(GraphDSL.Implicits$.MODULE$.SourceShapeArrow(handshakeRequestSource)).$tilde$greater(httpRequestBytesAndThenWSBytes, b);
        GraphDSL.Implicits$.MODULE$.port2flow(GraphDSL.Implicits$.MODULE$.flow2flow(wsIn, b).outlet(), b).$tilde$greater(httpRequestBytesAndThenWSBytes, b);
        return new BidiShape(networkIn.in(), networkIn.out(), wsIn.in(), httpRequestBytesAndThenWSBytes.out());
    }

    private WebSocketClientBlueprint$() {
    }
}

