/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHSubscription;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHThread
extends GHObject {
    private GitHub root;
    private GHRepository repository;
    private Subject subject;
    private String reason;
    private boolean unread;
    private String last_read_at;
    private String url;
    private String subscription_url;

    private GHThread() {
    }

    public Date getLastReadAt() {
        return GitHubClient.parseDate(this.last_read_at);
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    public String getReason() {
        return this.reason;
    }

    public GHRepository getRepository() {
        return this.repository;
    }

    public boolean isRead() {
        return !this.unread;
    }

    public String getTitle() {
        return this.subject.title;
    }

    public String getType() {
        return this.subject.type;
    }

    public String getLastCommentUrl() {
        return this.subject.latest_comment_url;
    }

    public GHIssue getBoundIssue() throws IOException {
        if (!"Issue".equals(this.subject.type) && "PullRequest".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getIssue(Integer.parseInt(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1)));
    }

    public GHPullRequest getBoundPullRequest() throws IOException {
        if (!"PullRequest".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getPullRequest(Integer.parseInt(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1)));
    }

    public GHCommit getBoundCommit() throws IOException {
        if (!"Commit".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getCommit(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1));
    }

    GHThread wrap(GitHub root) {
        this.root = root;
        if (this.repository != null) {
            this.repository.wrap(root);
        }
        return this;
    }

    public void markAsRead() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("PATCH")).withUrlPath(this.url, new String[0])).send();
    }

    public GHSubscription subscribe(boolean subscribed, boolean ignored) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("PUT")).with("subscribed", subscribed)).with("ignored", ignored)).withUrlPath(this.subscription_url, new String[0])).fetch(GHSubscription.class).wrapUp(this.root);
    }

    public GHSubscription getSubscription() throws IOException {
        try {
            return ((Requester)((Requester)this.root.createRequest().method("POST")).withUrlPath(this.subscription_url, new String[0])).fetch(GHSubscription.class).wrapUp(this.root);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    static class Subject {
        String title;
        String url;
        String latest_comment_url;
        String type;

        Subject() {
        }
    }
}

