/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.event.EventStream;
import akka.event.Logging;
import akka.event.SubchannelClassification;
import akka.remote.FailureDetector;
import akka.remote.FailureDetector$;
import akka.remote.HeartbeatHistory;
import akka.remote.HeartbeatHistory$;
import akka.remote.PhiAccrualFailureDetector$State$;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t-f\u0001B\u001e=\u0001\u0005C\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0011)A\u0005\u001d\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003U\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\r\u0004!Q1A\u0005\u0002eC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\tK\u0002\u0011)\u0019!C\u00013\"Aa\r\u0001B\u0001B\u0003%!\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!\t\bA!A!\u0002\u0017\u0011\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0003\u0001A\u0011AA\f\u0011\u001d\t\t\u0001\u0001C\u0001\u0003OA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B!\"a\u0017\u0001\u0001\u0004%\tAPA/\u0011)\ty\u0007\u0001a\u0001\n\u0003q\u0014\u0011\u000f\u0005\t\u0003{\u0002\u0001\u0015)\u0003\u0002`\u00191\u0011q\u0010\u0001E\u0003\u0003C!\"a'\u0018\u0005+\u0007I\u0011AA#\u0011)\tij\u0006B\tB\u0003%\u0011q\t\u0005\u000b\u0003?;\"Q3A\u0005\u0002\u0005\u0005\u0006BCAS/\tE\t\u0015!\u0003\u0002$\"9\u0011\u0011A\f\u0005\u0002\u0005\u001d\u0006\"CAY/\u0005\u0005I\u0011AAZ\u0011%\tIlFI\u0001\n\u0003\tY\fC\u0005\u0002R^\t\n\u0011\"\u0001\u0002T\"I\u0011q[\f\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\t\u0003S<\u0012\u0011!C\u0001'\"I\u00111^\f\u0002\u0002\u0013\u0005\u0011Q\u001e\u0005\n\u0003o<\u0012\u0011!C!\u0003sD\u0011Ba\u0002\u0018\u0003\u0003%\tA!\u0003\t\u0013\tMq#!A\u0005B\tU\u0001\"\u0003B\r/\u0005\u0005I\u0011\tB\u000e\u0011%\u0011ibFA\u0001\n\u0003\u0012y\u0002C\u0005\u0003\"]\t\t\u0011\"\u0011\u0003$\u001dI!q\u0005\u0001\u0002\u0002#%!\u0011\u0006\u0004\n\u0003\u007f\u0002\u0011\u0011!E\u0005\u0005WAq!!\u0001+\t\u0003\u0011\u0019\u0005C\u0005\u0003\u001e)\n\t\u0011\"\u0012\u0003 !I!Q\t\u0016\u0002\u0002\u0013\u0005%q\t\u0005\n\u0005\u001bR\u0013\u0011!CA\u0005\u001fB\u0011B!\u0018\u0001\u0005\u0004%IAa\u0018\t\u0011\tM\u0004\u0001)A\u0005\u0005CBqA!\u001e\u0001\t\u0003\u00129\bC\u0004\u0003v\u0001!IA!\u001f\t\u000f\tu\u0004\u0001\"\u0011\u0003x!9!q\u0010\u0001\u0005F\t\u0005\u0005B\u0002BG\u0001\u0011\u0005Q\nC\u0004\u0003\u000e\u0002!IAa$\t\u0011\t5\u0005\u0001\"\u0001?\u0005'C\u0011B!)\u0001\u0005\u0004%I!!\u0015\t\u0011\t\r\u0006\u0001)A\u0005\u0003'BqA!*\u0001\t\u0013\u00119KA\rQQ&\f5m\u0019:vC24\u0015-\u001b7ve\u0016$U\r^3di>\u0014(BA\u001f?\u0003\u0019\u0011X-\\8uK*\tq(\u0001\u0003bW.\f7\u0001A\n\u0004\u0001\tC\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g\r\u0005\u0002J\u00156\tA(\u0003\u0002Ly\tya)Y5mkJ,G)\u001a;fGR|'/A\u0005uQJ,7\u000f[8mIV\ta\n\u0005\u0002D\u001f&\u0011\u0001\u000b\u0012\u0002\u0007\t>,(\r\\3\u0002\u0015QD'/Z:i_2$\u0007%A\u0007nCb\u001c\u0016-\u001c9mKNK'0Z\u000b\u0002)B\u00111)V\u0005\u0003-\u0012\u00131!\u00138u\u00039i\u0017\r_*b[BdWmU5{K\u0002\nq\"\\5o'R$G)\u001a<jCRLwN\\\u000b\u00025B\u00111\fY\u0007\u00029*\u0011QLX\u0001\tIV\u0014\u0018\r^5p]*\u0011q\fR\u0001\u000bG>t7-\u001e:sK:$\u0018BA1]\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0001#\\5o'R$G)\u001a<jCRLwN\u001c\u0011\u00021\u0005\u001c7-\u001a9uC\ndW\rS3beR\u0014W-\u0019;QCV\u001cX-A\rbG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016\u0004\u0013A\u00064jeN$\b*Z1si\n,\u0017\r^#ti&l\u0017\r^3\u0002/\u0019L'o\u001d;IK\u0006\u0014HOY3bi\u0016\u001bH/[7bi\u0016\u0004\u0013aC3wK:$8\u000b\u001e:fC6\u00042aQ5l\u0013\tQGI\u0001\u0004PaRLwN\u001c\t\u0003Y>l\u0011!\u001c\u0006\u0003]z\nQ!\u001a<f]RL!\u0001]7\u0003\u0017\u00153XM\u001c;TiJ,\u0017-\\\u0001\u0006G2|7m\u001b\t\u0003gvt!\u0001^>\u000f\u0005UThB\u0001<z\u001b\u00059(B\u0001=A\u0003\u0019a$o\\8u}%\tq(\u0003\u0002>}%\u0011A\u0010P\u0001\u0010\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe&\u0011ap \u0002\u0006\u00072|7m\u001b\u0006\u0003yr\na\u0001P5oSRtDCDA\u0003\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0011Q\u0003\u000b\u0005\u0003\u000f\tI\u0001\u0005\u0002J\u0001!)\u0011/\u0004a\u0002e\")A*\u0004a\u0001\u001d\")!+\u0004a\u0001)\")\u0001,\u0004a\u00015\")1-\u0004a\u00015\")Q-\u0004a\u00015\")q-\u0004a\u0001QRa\u0011\u0011DA\u000f\u0003?\t\t#a\t\u0002&Q!\u0011qAA\u000e\u0011\u0015\th\u0002q\u0001s\u0011\u0015ae\u00021\u0001O\u0011\u0015\u0011f\u00021\u0001U\u0011\u0015Af\u00021\u0001[\u0011\u0015\u0019g\u00021\u0001[\u0011\u0015)g\u00021\u0001[)\u0019\t9!!\u000b\u0002@!9\u00111F\bA\u0002\u00055\u0012AB2p]\u001aLw\r\u0005\u0003\u00020\u0005mRBAA\u0019\u0015\u0011\tY#a\r\u000b\t\u0005U\u0012qG\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011H\u0001\u0004G>l\u0017\u0002BA\u001f\u0003c\u0011aaQ8oM&<\u0007BBA!\u001f\u0001\u00071.\u0001\u0002fm\u0006qa-\u001b:ti\"+\u0017M\u001d;cK\u0006$XCAA$!\rI\u0015\u0011J\u0005\u0004\u0003\u0017b$\u0001\u0005%fCJ$(-Z1u\u0011&\u001cHo\u001c:z\u0003=1\u0017N]:u\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0013AH1dG\u0016\u0004H/\u00192mK\"+\u0017M\u001d;cK\u0006$\b+Y;tK6KG\u000e\\5t+\t\t\u0019\u0006E\u0002D\u0003+J1!a\u0016E\u0005\u0011auN\\4\u0002?\u0005\u001c7-\u001a9uC\ndW\rS3beR\u0014W-\u0019;QCV\u001cX-T5mY&\u001c\b%A\u0004bI\u0012\u0014Xm]:\u0016\u0005\u0005}\u0003\u0003BA1\u0003SrA!a\u0019\u0002fA\u0011a\u000fR\u0005\u0004\u0003O\"\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002l\u00055$AB*ue&twMC\u0002\u0002h\u0011\u000b1\"\u00193ee\u0016\u001c8o\u0018\u0013fcR!\u00111OA=!\r\u0019\u0015QO\u0005\u0004\u0003o\"%\u0001B+oSRD\u0011\"a\u001f\u0016\u0003\u0003\u0005\r!a\u0018\u0002\u0007a$\u0013'\u0001\u0005bI\u0012\u0014Xm]:!\u0005\u0015\u0019F/\u0019;f'\u00199\")a!\u0002\nB\u00191)!\"\n\u0007\u0005\u001dEIA\u0004Qe>$Wo\u0019;\u0011\t\u0005-\u0015Q\u0013\b\u0005\u0003\u001b\u000b\tJD\u0002w\u0003\u001fK\u0011!R\u0005\u0004\u0003'#\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003/\u000bIJ\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002\u0014\u0012\u000bq\u0001[5ti>\u0014\u00180\u0001\u0005iSN$xN]=!\u0003%!\u0018.\\3ti\u0006l\u0007/\u0006\u0002\u0002$B!1)[A*\u0003)!\u0018.\\3ti\u0006l\u0007\u000f\t\u000b\u0007\u0003S\u000bi+a,\u0011\u0007\u0005-v#D\u0001\u0001\u0011\u001d\tY\n\ba\u0001\u0003\u000fBq!a(\u001d\u0001\u0004\t\u0019+\u0001\u0003d_BLHCBAU\u0003k\u000b9\fC\u0005\u0002\u001cv\u0001\n\u00111\u0001\u0002H!I\u0011qT\u000f\u0011\u0002\u0003\u0007\u00111U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiL\u000b\u0003\u0002H\u0005}6FAAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-G)\u0001\u0006b]:|G/\u0019;j_:LA!a4\u0002F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001b\u0016\u0005\u0003G\u000by,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0004B!!8\u0002h6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019/\u0001\u0003mC:<'BAAs\u0003\u0011Q\u0017M^1\n\t\u0005-\u0014q\\\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty/!>\u0011\u0007\r\u000b\t0C\u0002\u0002t\u0012\u00131!\u00118z\u0011!\tYHIA\u0001\u0002\u0004!\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\bCBA\u007f\u0005\u0007\ty/\u0004\u0002\u0002\u0000*\u0019!\u0011\u0001#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0006\u0005}(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0003\u0003\u0012A\u00191I!\u0004\n\u0007\t=AIA\u0004C_>dW-\u00198\t\u0013\u0005mD%!AA\u0002\u0005=\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a7\u0003\u0018!A\u00111P\u0013\u0002\u0002\u0003\u0007A+\u0001\u0005iCND7i\u001c3f)\u0005!\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0003\f\t\u0015\u0002\"CA>Q\u0005\u0005\t\u0019AAx\u0003\u0015\u0019F/\u0019;f!\r\tYKK\n\u0006U\t5\"\u0011\b\t\u000b\u0005_\u0011)$a\u0012\u0002$\u0006%VB\u0001B\u0019\u0015\r\u0011\u0019\u0004R\u0001\beVtG/[7f\u0013\u0011\u00119D!\r\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0003<\t\u0005SB\u0001B\u001f\u0015\u0011\u0011y$a9\u0002\u0005%|\u0017\u0002BAL\u0005{!\"A!\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005%&\u0011\nB&\u0011\u001d\tY*\fa\u0001\u0003\u000fBq!a(.\u0001\u0004\t\u0019+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE#\u0011\f\t\u0005\u0007&\u0014\u0019\u0006E\u0004D\u0005+\n9%a)\n\u0007\t]CI\u0001\u0004UkBdWM\r\u0005\n\u00057r\u0013\u0011!a\u0001\u0003S\u000b1\u0001\u001f\u00131\u0003\u0015\u0019H/\u0019;f+\t\u0011\t\u0007\u0005\u0004\u0003d\t=\u0014\u0011V\u0007\u0003\u0005KRAAa\u001a\u0003j\u00051\u0011\r^8nS\u000eT1a\u0018B6\u0015\u0011\u0011i'a9\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005c\u0012)GA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f\u0003\u0019\u0019H/\u0019;fA\u0005Y\u0011n]!wC&d\u0017M\u00197f+\t\u0011Y\u0001\u0006\u0003\u0003\f\tm\u0004bBAPe\u0001\u0007\u00111K\u0001\rSNluN\\5u_JLgnZ\u0001\nQ\u0016\f'\u000f\u001e2fCR$\"!a\u001d)\u0007Q\u0012)\t\u0005\u0003\u0003\b\n%UBAAe\u0013\u0011\u0011Y)!3\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006\u0019\u0001\u000f[5\u0015\u00079\u0013\t\nC\u0004\u0002 Z\u0002\r!a\u0015\u0015\u000f9\u0013)J!'\u0003\u001e\"9!qS\u001cA\u0002\u0005M\u0013\u0001\u0003;j[\u0016$\u0015N\u001a4\t\r\tmu\u00071\u0001O\u0003\u0011iW-\u00198\t\r\t}u\u00071\u0001O\u00031\u0019H\u000f\u001a#fm&\fG/[8o\u0003Ui\u0017N\\*uI\u0012+g/[1uS>tW*\u001b7mSN\fa#\\5o'R$G)\u001a<jCRLwN\\'jY2L7\u000fI\u0001\u0018K:\u001cXO]3WC2LGm\u0015;e\t\u00164\u0018.\u0019;j_:$2A\u0014BU\u0011\u0019\u0011yJ\u000fa\u0001\u001d\u0002")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final long minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public String address() {
        return this.address;
    }

    public void address_$eq(String x$1) {
        this.address = x$1;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                HeartbeatHistory heartbeatHistory2;
                Some some = (Some)option;
                long latestTimestamp = BoxesRunTime.unboxToLong((Object)some.value());
                long interval = timestamp - latestTimestamp;
                if (this.isAvailable(timestamp)) {
                    if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
                        ((SubchannelClassification)this.eventStream.get()).publish((Object)new Logging.Warning(this.toString(), this.getClass(), (Object)new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString()));
                    }
                    heartbeatHistory2 = oldState.history().$colon$plus(interval);
                } else {
                    heartbeatHistory2 = oldState.history();
                }
                heartbeatHistory = heartbeatHistory2;
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        double d;
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            d = 0.0;
        } else {
            long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
            HeartbeatHistory history = oldState.history();
            double mean = history.mean();
            double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
            d = this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
        }
        return d;
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        return (double)timeDiff > mean ? -package$.MODULE$.log10(e / (1.0 + e)) : -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private long minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, (double)this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0 & Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0 & Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), (Option<EventStream>)new Some((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    public class State
    implements Product,
    Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        public final /* synthetic */ PhiAccrualFailureDetector $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.akka$remote$PhiAccrualFailureDetector$State$$$outer(), history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.history();
                    break;
                }
                case 1: {
                    object = this.timestamp();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "history";
                    break;
                }
                case 1: {
                    string = "timestamp";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).akka$remote$PhiAccrualFailureDetector$State$$$outer() != this.akka$remote$PhiAccrualFailureDetector$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ PhiAccrualFailureDetector akka$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

