/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport;

import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.AddressFromURIString$;
import akka.actor.InternalActorRef;
import akka.protobuf.ByteString;
import akka.protobuf.InvalidProtocolBufferException;
import akka.remote.Ack;
import akka.remote.RemoteActorRefProvider;
import akka.remote.SeqNo;
import akka.remote.WireFormats;
import akka.remote.transport.AkkaPduCodec;
import akka.remote.transport.AkkaPduCodec$Heartbeat$;
import akka.remote.transport.AssociationHandle;
import akka.remote.transport.AssociationHandle$Quarantined$;
import akka.remote.transport.AssociationHandle$Shutdown$;
import akka.remote.transport.AssociationHandle$Unknown$;
import akka.remote.transport.HandshakeInfo;
import akka.remote.transport.PduCodecException;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.ccompat.package;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AkkaPduProtobufCodec$
implements AkkaPduCodec {
    public static final AkkaPduProtobufCodec$ MODULE$ = new AkkaPduProtobufCodec$();
    private static final akka.util.ByteString DISASSOCIATE;
    private static final akka.util.ByteString DISASSOCIATE_SHUTTING_DOWN;
    private static final akka.util.ByteString DISASSOCIATE_QUARANTINED;
    private static final akka.util.ByteString constructHeartbeat;

    static {
        AkkaPduCodec.$init$(MODULE$);
        DISASSOCIATE = MODULE$.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE, (Option<WireFormats.AkkaHandshakeInfo.Builder>)None$.MODULE$);
        DISASSOCIATE_SHUTTING_DOWN = MODULE$.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE_SHUTTING_DOWN, (Option<WireFormats.AkkaHandshakeInfo.Builder>)None$.MODULE$);
        DISASSOCIATE_QUARANTINED = MODULE$.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE_QUARANTINED, (Option<WireFormats.AkkaHandshakeInfo.Builder>)None$.MODULE$);
        constructHeartbeat = MODULE$.constructControlMessagePdu(WireFormats.CommandType.HEARTBEAT, (Option<WireFormats.AkkaHandshakeInfo.Builder>)None$.MODULE$);
    }

    @Override
    public akka.util.ByteString encodePdu(AkkaPduCodec.AkkaPdu pdu) {
        return AkkaPduCodec.encodePdu$(this, pdu);
    }

    /*
     * WARNING - void declaration
     */
    private WireFormats.AcknowledgementInfo.Builder ackBuilder(Ack ack) {
        void var2_2;
        WireFormats.AcknowledgementInfo.Builder ackBuilder = WireFormats.AcknowledgementInfo.newBuilder();
        ackBuilder.setCumulativeAck(ack.cumulativeAck().rawValue());
        ack.nacks().foreach((Function1 & Serializable)nack -> ackBuilder.addNacks(nack.rawValue()));
        return var2_2;
    }

    @Override
    public akka.util.ByteString constructMessage(Address localAddress, ActorRef recipient, WireFormats.SerializedMessage serializedMessage, ActorRef senderOption, Option<SeqNo> seqOption, Option<Ack> ackOption) {
        Object object;
        ActorRef actorRef;
        WireFormats.AckAndEnvelopeContainer.Builder ackAndEnvelopeBuilder = WireFormats.AckAndEnvelopeContainer.newBuilder();
        WireFormats.RemoteEnvelope.Builder envelopeBuilder = WireFormats.RemoteEnvelope.newBuilder();
        envelopeBuilder.setRecipient(this.serializeActorRef(recipient.path().address(), recipient));
        ActorRef actorRef2 = senderOption;
        if (new OptionVal((Object)actorRef2) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(actorRef = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef2)))) {
            ActorRef sender = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef);
            object = envelopeBuilder.setSender(this.serializeActorRef(localAddress, sender));
        } else {
            OptionVal$.MODULE$.None();
            ActorRef actorRef3 = actorRef2;
            if (!(null != null ? !((Object)null).equals(actorRef3) : actorRef3 != null)) {
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)new OptionVal((Object)actorRef2));
            }
        }
        seqOption.foreach((Function1 & Serializable)seq -> envelopeBuilder.setSeq(seq.rawValue()));
        ackOption.foreach((Function1 & Serializable)ack -> ackAndEnvelopeBuilder.setAck(MODULE$.ackBuilder((Ack)ack)));
        envelopeBuilder.setMessage(serializedMessage);
        ackAndEnvelopeBuilder.setEnvelope(envelopeBuilder);
        return ByteString.ByteString1C$.MODULE$.apply(ackAndEnvelopeBuilder.build().toByteArray());
    }

    @Override
    public Option<SeqNo> constructMessage$default$5() {
        return None$.MODULE$;
    }

    @Override
    public Option<Ack> constructMessage$default$6() {
        return None$.MODULE$;
    }

    @Override
    public akka.util.ByteString constructPureAck(Ack ack) {
        return ByteString.ByteString1C$.MODULE$.apply(WireFormats.AckAndEnvelopeContainer.newBuilder().setAck(this.ackBuilder(ack)).build().toByteArray());
    }

    @Override
    public akka.util.ByteString constructPayload(akka.util.ByteString payload) {
        return ByteString.ByteString1C$.MODULE$.apply(WireFormats.AkkaProtocolMessage.newBuilder().setPayload(ByteString.copyFrom((ByteBuffer)payload.asByteBuffer())).build().toByteArray());
    }

    @Override
    public akka.util.ByteString constructAssociate(HandshakeInfo info) {
        WireFormats.AkkaHandshakeInfo.Builder handshakeInfo = WireFormats.AkkaHandshakeInfo.newBuilder().setOrigin(this.serializeAddress(info.origin())).setUid(info.uid());
        info.cookie().foreach((Function1 & Serializable)value -> handshakeInfo.setCookie((String)value));
        return this.constructControlMessagePdu(WireFormats.CommandType.ASSOCIATE, (Option<WireFormats.AkkaHandshakeInfo.Builder>)new Some((Object)handshakeInfo));
    }

    private akka.util.ByteString DISASSOCIATE() {
        return DISASSOCIATE;
    }

    private akka.util.ByteString DISASSOCIATE_SHUTTING_DOWN() {
        return DISASSOCIATE_SHUTTING_DOWN;
    }

    private akka.util.ByteString DISASSOCIATE_QUARANTINED() {
        return DISASSOCIATE_QUARANTINED;
    }

    @Override
    public akka.util.ByteString constructDisassociate(AssociationHandle.DisassociateInfo info) {
        akka.util.ByteString byteString;
        AssociationHandle.DisassociateInfo disassociateInfo = info;
        if (AssociationHandle$Unknown$.MODULE$.equals(disassociateInfo)) {
            byteString = this.DISASSOCIATE();
        } else if (AssociationHandle$Shutdown$.MODULE$.equals(disassociateInfo)) {
            byteString = this.DISASSOCIATE_SHUTTING_DOWN();
        } else if (AssociationHandle$Quarantined$.MODULE$.equals(disassociateInfo)) {
            byteString = this.DISASSOCIATE_QUARANTINED();
        } else {
            throw new MatchError((Object)disassociateInfo);
        }
        return byteString;
    }

    @Override
    public akka.util.ByteString constructHeartbeat() {
        return constructHeartbeat;
    }

    @Override
    public AkkaPduCodec.AkkaPdu decodePdu(akka.util.ByteString raw) {
        AkkaPduCodec.AkkaPdu akkaPdu;
        block4: {
            try {
                WireFormats.AkkaProtocolMessage pdu = WireFormats.AkkaProtocolMessage.parseFrom((byte[])raw.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                if (pdu.hasPayload()) {
                    akkaPdu = new AkkaPduCodec.Payload(ByteString$.MODULE$.apply(pdu.getPayload().asReadOnlyByteBuffer()));
                    break block4;
                }
                if (pdu.hasInstruction()) {
                    akkaPdu = this.decodeControlPdu(pdu.getInstruction());
                    break block4;
                }
                throw new PduCodecException("Error decoding Akka PDU: Neither message nor control message were contained", null);
            }
            catch (InvalidProtocolBufferException e) {
                throw new PduCodecException("Decoding PDU failed.", e);
            }
        }
        return akkaPdu;
    }

    @Override
    public Tuple2<Option<Ack>, Option<AkkaPduCodec.Message>> decodeMessage(akka.util.ByteString raw, RemoteActorRefProvider provider, Address localAddress) {
        None$ none$;
        None$ ackOption;
        WireFormats.AckAndEnvelopeContainer ackAndEnvelope = WireFormats.AckAndEnvelopeContainer.parseFrom((byte[])raw.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        Object object = ackOption = ackAndEnvelope.hasAck() ? new Some((Object)new Ack(new SeqNo(ackAndEnvelope.getAck().getCumulativeAck()), (Set<SeqNo>)((IterableOnceOps)package.JavaConverters$.MODULE$.ListHasAsScala(ackAndEnvelope.getAck().getNacksList()).asScala().map((Function1 & Serializable)x$1 -> new SeqNo(Predef$.MODULE$.Long2long(x$1)))).toSet())) : None$.MODULE$;
        if (ackAndEnvelope.hasEnvelope()) {
            ActorRef actorRef;
            WireFormats.RemoteEnvelope msgPdu = ackAndEnvelope.getEnvelope();
            InternalActorRef internalActorRef = provider.resolveActorRefWithLocalAddress(msgPdu.getRecipient().getPath(), localAddress);
            Address address = AddressFromURIString$.MODULE$.apply(msgPdu.getRecipient().getPath());
            WireFormats.SerializedMessage serializedMessage = msgPdu.getMessage();
            if (msgPdu.hasSender()) {
                actorRef = (ActorRef)OptionVal$.MODULE$.apply((Object)provider.resolveActorRefWithLocalAddress(msgPdu.getSender().getPath(), localAddress));
            } else {
                OptionVal$.MODULE$.None();
                actorRef = null;
            }
            none$ = new Some((Object)new AkkaPduCodec.Message(internalActorRef, address, serializedMessage, actorRef, (Option<SeqNo>)(msgPdu.hasSeq() ? new Some((Object)new SeqNo(msgPdu.getSeq())) : None$.MODULE$)));
        } else {
            none$ = None$.MODULE$;
        }
        None$ messageOption = none$;
        return new Tuple2((Object)ackOption, (Object)messageOption);
    }

    private AkkaPduCodec.AkkaPdu decodeControlPdu(WireFormats.AkkaControlMessage controlPdu) {
        AkkaPduCodec.AkkaPdu akkaPdu;
        WireFormats.CommandType commandType = controlPdu.getCommandType();
        if (((Object)((Object)WireFormats.CommandType.ASSOCIATE)).equals((Object)commandType) && controlPdu.hasHandshakeInfo()) {
            WireFormats.AkkaHandshakeInfo handshakeInfo = controlPdu.getHandshakeInfo();
            None$ cookie = handshakeInfo.hasCookie() ? new Some((Object)handshakeInfo.getCookie()) : None$.MODULE$;
            akkaPdu = new AkkaPduCodec.Associate(new HandshakeInfo(this.decodeAddress(handshakeInfo.getOrigin()), (int)handshakeInfo.getUid(), (Option<String>)cookie));
        } else if (((Object)((Object)WireFormats.CommandType.DISASSOCIATE)).equals((Object)commandType)) {
            akkaPdu = new AkkaPduCodec.Disassociate(AssociationHandle$Unknown$.MODULE$);
        } else if (((Object)((Object)WireFormats.CommandType.DISASSOCIATE_SHUTTING_DOWN)).equals((Object)commandType)) {
            akkaPdu = new AkkaPduCodec.Disassociate(AssociationHandle$Shutdown$.MODULE$);
        } else if (((Object)((Object)WireFormats.CommandType.DISASSOCIATE_QUARANTINED)).equals((Object)commandType)) {
            akkaPdu = new AkkaPduCodec.Disassociate(AssociationHandle$Quarantined$.MODULE$);
        } else if (((Object)((Object)WireFormats.CommandType.HEARTBEAT)).equals((Object)commandType)) {
            akkaPdu = AkkaPduCodec$Heartbeat$.MODULE$;
        } else {
            throw new PduCodecException(new StringBuilder(62).append("Decoding of control PDU failed, invalid format, unexpected: [").append((Object)commandType).append("]").toString(), null);
        }
        return akkaPdu;
    }

    private Address decodeAddress(WireFormats.AddressData encodedAddress) {
        return Address$.MODULE$.apply(encodedAddress.getProtocol(), encodedAddress.getSystem(), encodedAddress.getHostname(), encodedAddress.getPort());
    }

    private akka.util.ByteString constructControlMessagePdu(WireFormats.CommandType code, Option<WireFormats.AkkaHandshakeInfo.Builder> handshakeInfo) {
        WireFormats.AkkaControlMessage.Builder controlMessageBuilder = WireFormats.AkkaControlMessage.newBuilder();
        controlMessageBuilder.setCommandType(code);
        handshakeInfo.foreach((Function1 & Serializable)builderForValue -> controlMessageBuilder.setHandshakeInfo((WireFormats.AkkaHandshakeInfo.Builder)builderForValue));
        return ByteString.ByteString1C$.MODULE$.apply(WireFormats.AkkaProtocolMessage.newBuilder().setInstruction(controlMessageBuilder.build()).build().toByteArray());
    }

    private WireFormats.ActorRefData serializeActorRef(Address defaultAddress, ActorRef ref) {
        return WireFormats.ActorRefData.newBuilder().setPath(ref.path().address().host().isDefined() ? ref.path().toSerializationFormat() : ref.path().toSerializationFormatWithAddress(defaultAddress)).build();
    }

    private WireFormats.AddressData serializeAddress(Address address) {
        String host;
        Option option;
        String system;
        String protocol;
        block3: {
            block2: {
                Address address2 = address;
                if (address2 == null) break block2;
                protocol = address2.protocol();
                system = address2.system();
                Option option2 = address2.host();
                option = address2.port();
                if (!(option2 instanceof Some)) break block2;
                Some some = (Some)option2;
                host = (String)some.value();
                if (option instanceof Some) break block3;
            }
            throw new IllegalArgumentException(new StringBuilder(57).append("Address [").append(address).append("] could not be serialized: host or port missing.").toString());
        }
        Some some = (Some)option;
        int port = BoxesRunTime.unboxToInt((Object)some.value());
        WireFormats.AddressData addressData = WireFormats.AddressData.newBuilder().setHostname(host).setPort(port).setSystem(system).setProtocol(protocol).build();
        return addressData;
    }

    private AkkaPduProtobufCodec$() {
    }
}

