/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.activity.ActivityOps;
import com.xebialabs.xlrelease.domain.ActivityCategory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public enum ReleaseActivity implements ActivityOps
{
    TEMPLATE_CREATED("Created template", ActivityCategory.LIFECYCLE),
    TEMPLATE_DUPLICATED("Duplicated template to '%s'", ActivityCategory.RELEASE_EDIT),
    TEMPLATE_MOVED("Template moved from folder %s to folder %s", ActivityCategory.RELEASE_EDIT),
    RELEASE_TITLE_UPDATED("Changed title from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_DESCRIPTION_UPDATED("Changed description from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_DUE_DATE_UPDATED("Changed due date from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_OWNER_UPDATED("Changed owner from %s to %s", ActivityCategory.REASSIGN, ActivityCategory.RELEASE_EDIT),
    RELEASE_TAGS_UPDATED("Updated tags to:\n%s", ActivityCategory.RELEASE_EDIT),
    RELEASE_FLAG_STATUS_UPDATED("Changed flag status from '%s' to '%s'", ActivityCategory.RELEASE_EDIT, ActivityCategory.IMPORTANT),
    RELEASE_FLAG_COMMENT_UPDATED("Changed flag comment from '%s' to '%s'", ActivityCategory.RELEASE_EDIT, ActivityCategory.IMPORTANT, ActivityCategory.COMMENTS),
    RELEASE_ABORT_RELEASE_ON_FAILURE_UPDATED("Changed 'Abort release on failure' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_ALLOW_PASSWORDS_IN_ALL_FIELDS_ON_FAILURE_UPDATED("Changed 'Allow passwords in all fields' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_DISABLE_NOTIFICATIONS_UPDATED("Changed 'Disable notifications' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    COMMENT_ADDED("Added a comment '%s' on task '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.COMMENTS),
    COMMENT_UPDATED("Updated comment '%s' to '%s' on task '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.COMMENTS),
    COMMENT_DELETED("Deleted comment '%s' for task '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.COMMENTS),
    PHASE_CREATED("Created Phase '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_RENAMED("Renamed Phase '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DESCRIPTION_UPDATED("Changed description of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DURATION_UPDATED("Changed duration of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DUE_DATE_UPDATED("Changed due date of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_COLOR_CHANGED("Changed color of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_MOVED("Moved Phase '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DELETED("Deleted Phase '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DUPLICATED("Duplicated Phase to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_STARTED("Started Phase '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    PHASE_FAILED("Failed Phase '%s'", ActivityCategory.LIFECYCLE),
    PHASE_FAILING("Phase '%s' started failing", ActivityCategory.LIFECYCLE),
    PHASE_RESTARTED("Restarted Phase '%s'", ActivityCategory.LIFECYCLE),
    PHASE_COMPLETED("Completed Phase '%s'", ActivityCategory.LIFECYCLE),
    PHASE_CLOSED("Closed Phase '%s' and skipped all its tasks", ActivityCategory.LIFECYCLE),
    TASK_CREATED("Created Task '%s' of type '%s'", ActivityCategory.RELEASE_EDIT, ActivityCategory.TASK_EDIT),
    TASK_MOVED_BETWEEN_CONTAINERS("Moved Task '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    TASK_MOVED_WITHIN_CONTAINER("Moved Task '%s' within '%s'", ActivityCategory.RELEASE_EDIT),
    TASK_DELETED("Deleted Task '%s'", ActivityCategory.RELEASE_EDIT, ActivityCategory.IMPORTANT),
    TASK_TITLE_UPDATED("Changed title of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_DESCRIPTION_UPDATED("Changed description of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_DURATION_UPDATED("Changed duration of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_OWNER_UPDATED("Changed owner of Task '%s' from %s to %s", ActivityCategory.TASK_EDIT, ActivityCategory.REASSIGN),
    TASK_TASK_TEAM_UPDATED("Changed team of Task '%s' from %s to %s", ActivityCategory.TASK_EDIT, ActivityCategory.REASSIGN),
    TASK_DUE_DATE_UPDATED("Changed due date of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_WAIT_FOR_SCHEDULED_START_DATE_UPDATED("Changed wait for scheduled start date of Task '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_FLAG_STATUS_UPDATED("Flagged Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.IMPORTANT),
    TASK_FLAG_COMMENT_UPDATED("Changed flag status of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.IMPORTANT, ActivityCategory.COMMENTS),
    TASK_COPIED("Copied Task to '%s'", ActivityCategory.RELEASE_EDIT),
    TASK_NOTIFICATION_ADDRESSES_UPDATED("Changed Notification addresses of recipients of the Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_CC_UPDATED("Changed Notification list of email addresses that receive the message as CC of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_BCC_UPDATED("Changed Notification list of email addresses that receive the message as BCC of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_REPLY_TO_UPDATED("Changed Notification email address of the reply message recipient of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_FROM_UPDATED("Changed Notification email address of the message sender of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_SENDER_USERNAME_UPDATED("Changed Notification email username of the message sender of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_SENDER_PASSWORD_UPDATED("Changed Notification email password of the message sender of Task '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_PRIORITY_UPDATED("Changed Notification email priority of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_SUBJECT_UPDATED("Changed Notification subject of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_BODY_UPDATED("Changed Notification body of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_SCRIPT_UPDATED("Changed Script of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_INPUT_PROPERTY_UPDATED("Changed input property '%s' of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_INPUT_PROPERTY_PASSWORD_UPDATED("Changed input property '%s' of Task '%s'", ActivityCategory.TASK_EDIT),
    TASK_OUTPUT_PROPERTIES_UPDATED("Changed output property '%s' of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_PRECONDITION_UPDATED("Changed precondition of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_TYPE_CHANGED("Changed type of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_RELEASE_TITLE_UPDATED("Changed release title of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_RELEASE_TEMPLATE_UPDATED("Changed release template of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_START_RELEASE_FLAG_UPDATED("Changed start release flag of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_RELEASE_VARIABLE_UPDATED("Changed variable '%s' of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_RELEASE_PASSWORD_VARIABLE_UPDATED("Changed password variable '%s' of Task '%s'", ActivityCategory.TASK_EDIT),
    TASK_RELEASE_TAGS_UPDATED("Changed release tags of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASKS_LOCKED("Tasks '%s' locked", ActivityCategory.TASK_EDIT),
    TASKS_UNLOCKED("Tasks '%s' unlocked", ActivityCategory.TASK_EDIT),
    TASK_FAILURE_HANDLE_ENABLED("Changed task failure handle enabled of '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_RECOVER_OP_UPDATED("Changed task recovery operation of '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_RECOVER_SCRIPT_UPDATED("Changed task recovery script of '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_POSTPONE_BLACKOUT_UPDATED("Changed 'Postpone during blackout' of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_CHECK_ATTRIBUTES_UPDATED("Changed 'Check environment availability' of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_TAGS_UPDATED("Changed tags of Task '%s' from '%s' to: '%s'", ActivityCategory.TASK_EDIT),
    TEAM_CREATED("Created Team '%s'", ActivityCategory.SECURITY, ActivityCategory.RELEASE_EDIT),
    TEAM_UPDATED("Updated Team '%s' with members '%s' and roles '%s'", ActivityCategory.REASSIGN, ActivityCategory.SECURITY),
    TEAM_DELETED("Removed Team '%s'", ActivityCategory.SECURITY, ActivityCategory.RELEASE_EDIT),
    FOLDER_TEAM_MERGED("Merged teams and permissions from template %s into folder %s", ActivityCategory.SECURITY, ActivityCategory.RELEASE_EDIT),
    REMOVE_TEMPLATE_TEAMS("Removed teams from template %s. It will inherit teams and permissions from folder %s", ActivityCategory.SECURITY, ActivityCategory.RELEASE_EDIT),
    TASK_WATCHER_ADDED("Added watcher '%s' to task '%s'", ActivityCategory.TASK_EDIT),
    TASK_WATCHER_REMOVED("Removed watcher '%s' from task '%s'", ActivityCategory.TASK_EDIT),
    GATE_CONDITION_CREATED("Created Condition '%s' on gate '%s'", ActivityCategory.TASK_EDIT),
    GATE_CONDITION_TITLE_UPDATED("Updated title on Condition '%s' of gate '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    GATE_CONDITION_FULFILLED("Fulfilled Condition '%s' on gate '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.LIFECYCLE),
    GATE_CONDITION_UNFULFILLED("Unfulfilled Condition '%s' on gate '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.LIFECYCLE),
    GATE_CONDITION_DELETED("Deleted Condition '%s' from gate '%s'", ActivityCategory.TASK_EDIT),
    LINK_ADDED("Created Link on Group '%s' from Task '%s' to Task '%s'", ActivityCategory.TASK_EDIT),
    LINK_REMOVED("Removed Link on Group '%s' from Task '%s' to Task '%s'", ActivityCategory.TASK_EDIT),
    DEPENDENCY_CREATED("Added Dependency in gate '%s' on '%s'", ActivityCategory.TASK_EDIT),
    DEPENDENCY_UPDATED("Changed Dependency in gate '%s' on '%s' to '%s'", ActivityCategory.TASK_EDIT),
    DEPENDENCY_DELETED("Deleted Dependency in gate '%s' on '%s'", ActivityCategory.TASK_EDIT),
    RELEASE_CREATED_FROM_TEMPLATE("Created Release '%s' from template '%s'", ActivityCategory.LIFECYCLE),
    RELEASE_CREATED_FROM_CREATE_RELEASE_TASK("Created Release '%s' from create release task '%s' and template '%s'", ActivityCategory.LIFECYCLE),
    RELEASE_CREATED_FROM_DSL("Created Release '%s' from DSL", ActivityCategory.LIFECYCLE),
    RELEASE_RESTORED_FROM_REVISION("Template '%s' restored from revision '%s'", ActivityCategory.LIFECYCLE),
    RELEASE_CREATED("Created Empty Release '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.RELEASE_EDIT),
    RELEASE_STARTED("Started Release", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    RELEASE_STARTED_FROM_CREATE_RELEASE_TASK("Started Release '%s' from create release task '%s'", ActivityCategory.LIFECYCLE),
    RELEASE_FAILED("Failed Release", ActivityCategory.LIFECYCLE),
    RELEASE_FAILING("Release started failing", ActivityCategory.LIFECYCLE),
    RELEASE_RESTARTED("Restarted Release", ActivityCategory.LIFECYCLE),
    RELEASE_COMPLETED("Completed Release", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    RELEASE_ABORTED("Aborted Release with comment '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_STARTED("Started Task '%s'", ActivityCategory.LIFECYCLE),
    TASK_DELAYED("Activated Task '%s' with a scheduled start date of '%s'", ActivityCategory.LIFECYCLE),
    TASK_DELAYED_DUE_TO_BLACKOUT("Activated Task '%s' with a scheduled start date of '%s' due to a blackout", ActivityCategory.LIFECYCLE),
    TASK_COMPLETED("Completed Task '%s'", ActivityCategory.LIFECYCLE),
    TASK_COMPLETED_IN_ADVANCE("Completed in advance Task '%s'", ActivityCategory.LIFECYCLE),
    TASK_SKIPPED("Skipped Task '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_SKIPPED_IN_ADVANCE("Skipped in advance Task '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_FAILED("Failed Task '%s': %s", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_RESTARTED("Restarted Task '%s'", ActivityCategory.LIFECYCLE),
    TASK_FAILING("Task '%s' started failing", ActivityCategory.LIFECYCLE),
    TASK_REOPENED("Task '%s' reopened", ActivityCategory.LIFECYCLE),
    TASK_RECOVERY_STARTED("Task '%s' started recovering. Recovery operation: '%s', failure handler script is %s", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_RECOVERED("Task '%s' recovery complete. Recovery operation: '%s', failure handler script was %s", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_ABORT_SCRIPT_STARTED("Abort script of task '%s' started. Abort script is %s", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_ABORT_SCRIPT_COMPLETED("Abort script of task '%s' completed. Abort script is %s", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_WAITING_FOR_INPUT("Task %s' requires input for variables: %s", ActivityCategory.LIFECYCLE),
    TEMPLATE_IMPORTED("Imported template", ActivityCategory.RELEASE_EDIT),
    PERMISSIONS_UPDATED("Updated permissions to:\n%s", ActivityCategory.SECURITY),
    ATTACHMENT_ADDED("Added attachment: '%s' (%s)", ActivityCategory.RELEASE_EDIT),
    ATTACHMENT_ADDED_ON_TASK("Added attachment: '%s' (%s) on task: '%s'", ActivityCategory.RELEASE_EDIT),
    ATTACHMENT_DELETED("Deleted attachment: '%s'", ActivityCategory.RELEASE_EDIT),
    ATTACHMENT_DELETED_FROM_TASK("Deleted attachment: '%s' from task : '%s'", ActivityCategory.RELEASE_EDIT),
    TEMPLATE_ALLOW_CONCURRENT_RELEASES_FROM_TRIGGER_UPDATED("Changed 'Allow concurrent triggered releases' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_CREATED("Created variable %s", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_DELETED("Deleted variable %s", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_REPLACED("Replaced variable %s with %s", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_RENAMED("Renamed variable '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_VALUE_UPDATED("Changed value of variable %s from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_PASSWORD_VALUE_UPDATED("Changed value of password variable %s", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_NAME_UPDATED("Changed name of variable %s from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_LABEL_UPDATED("Changed label of variable %s from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_DESCRIPTION_UPDATED("Changed description of variable %s from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_REQUIRED_UPDATED("Changed required flag of variable %s from %s to %s", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_SHOW_ON_CREATE_UPDATED("Changed 'show on create release form' flag of variable %s from %s to %s", ActivityCategory.RELEASE_EDIT),
    GLOBAL_VARIABLE_CREATED("Created global variable %s", ActivityCategory.RELEASE_EDIT),
    GLOBAL_VARIABLE_VALUE_UPDATED("Changed value of global variable %s from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    GLOBAL_VARIABLE_PASSWORD_VALUE_UPDATED("Changed value of global password variable %s", ActivityCategory.RELEASE_EDIT),
    GLOBAL_VARIABLE_DELETED("Deleted global variable %s", ActivityCategory.RELEASE_EDIT),
    FOLDER_VARIABLE_CREATED("Created folder variable %s", ActivityCategory.RELEASE_EDIT),
    FOLDER_VARIABLE_VALUE_UPDATED("Changed value of folder variable %s from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    FOLDER_VARIABLE_PASSWORD_VALUE_UPDATED("Changed value of folder password variable %s", ActivityCategory.RELEASE_EDIT),
    FOLDER_VARIABLE_DELETED("Deleted folder variable %s", ActivityCategory.RELEASE_EDIT),
    RELEASE_RISK_PROFILE_UPDATED("Changed risk profile from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    TASK_REPORTING_RECORD_CREATED("Created reporting record of type %s", ActivityCategory.REPORTING_RECORD_EDIT),
    OTHER("", ActivityCategory.OTHER),
    CUSTOM("%s", ActivityCategory.OTHER);

    private String message;
    private Set<ActivityCategory> categories;
    private static final Map<String, ReleaseActivity> BY_NAME;

    private ReleaseActivity(String message, ActivityCategory ... categories) {
        this.message = message;
        LinkedHashSet myCategories = Sets.newLinkedHashSet();
        if (categories != null) {
            Collections.addAll(myCategories, categories);
        }
        this.categories = Collections.unmodifiableSet(myCategories);
    }

    public ActivityLogEntry create(Date eventTime, String username, Type targetType, String targetId, Object ... parameters) {
        return this.create(eventTime, this.name(), username, targetType, targetId, this.message, parameters);
    }

    public ActivityLogEntry create(XLReleaseEvent event, BaseConfigurationItem target, Object ... parameters) {
        return this.create(event.timestamp(), event.username(), target.getType(), target.getId(), parameters);
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Set<ActivityCategory> getCategories() {
        return this.categories;
    }

    public String toString() {
        return this.message;
    }

    public static ReleaseActivity safeValueOf(String name) {
        ReleaseActivity activity = BY_NAME.get(name);
        return activity == null ? OTHER : activity;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ReleaseActivity value : ReleaseActivity.values()) {
            builder.put((Object)value.name(), (Object)value);
        }
        BY_NAME = builder.build();
    }
}

