/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.AdaptiveReleaseId;
import com.xebialabs.xlrelease.domain.utils.FullReleaseId$;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicDataExt;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0005\u0011-t!B\u001d;\u0011\u0003\u0019e!B#;\u0011\u00031\u0005\"B+\u0002\t\u00031\u0006\"B,\u0002\t\u0003A\u0006\"B;\u0002\t\u00031h!B#;\u0001\u0005\u001d\u0001BCA\u0005\u000b\t\u0015\r\u0011\"\u0001\u0002\f!Q\u0011\u0011D\u0003\u0003\u0002\u0003\u0006I!!\u0004\t\u0015\u0005mQA!A!\u0002\u0013\ti\u0002\u0003\u0006\u0002$\u0015\u0011\t\u0011)A\u0005\u0003KA\u0011\"a\u000b\u0006\u0005\u0003\u0005\u000b\u0011\u00028\t\u0015\u00055RA!A!\u0002\u0013\ty\u0003\u0003\u0006\u00026\u0015\u0011\t\u0011)A\u0005\u0003oA!\"!\u0011\u0006\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\tI%\u0002B\u0001B\u0003%\u00111\n\u0005\u000b\u0003/*!\u0011!Q\u0001\n\u0005e\u0003BCA0\u000b\t\u0005\t\u0015!\u0003\u0002b!Q\u0011qM\u0003\u0003\u0002\u0003\u0006I!!\u001b\t\u0015\u0005=TA!A!\u0002\u0013\t\t\b\u0003\u0006\u0002x\u0015\u0011\t\u0011)A\u0005\u0003sBa!V\u0003\u0005\u0002\u0005}\u0004bBA\\\u000b\u0011\u0005\u0011\u0011\u0018\u0005\b\u00033,A\u0011BAn\u0011\u001d\t\t/\u0002C\u0005\u0003GDq!a:\u0006\t\u0003\tI\u000fC\u0004\u0002v\u0016!\t!a>\t\u000f\u0005uX\u0001\"\u0001\u0002\u0000\"9\u0011Q`\u0003\u0005\u0002\t\r\u0001b\u0002B\u0007\u000b\u0011\u0005!q\u0002\u0005\b\u0005+)A\u0011\u0001B\f\u0011\u001d\u0011)#\u0002C\u0001\u0005OAqA!\u000e\u0006\t\u0003\u00119\u0004C\u0004\u0003L\u0015!\tA!\u0014\t\u000f\tUS\u0001\"\u0001\u0003X!9!QL\u0003\u0005\u0002\t}\u0003b\u0002B4\u000b\u0011\u0005!\u0011\u000e\u0005\b\u0005_*A\u0011\u0001B9\u0011\u001d\u0011I(\u0002C\u0001\u0005wBqAa\"\u0006\t\u0003\u0011I\tC\u0004\u0003\u0016\u0016!\tAa&\t\u000f\tUU\u0001\"\u0001\u0003D\"9!q[\u0003\u0005\u0002\te\u0007\"CB\u0017\u000bE\u0005I\u0011AB\u0018\u0011%\u0019\u0019%BI\u0001\n\u0003\u0019y\u0003C\u0004\u0004F\u0015!\taa\u0012\t\u000f\r\u0015T\u0001\"\u0001\u0004h!91QN\u0003\u0005\u0002\r=\u0004bBBH\u000b\u0011\u00051\u0011\u0013\u0005\b\u0007/+A\u0011ABM\u0011\u001d\u0011)*\u0002C\u0005\u0007OCqaa,\u0006\t\u0003\u0019\t\fC\u0004\u0004:\u0016!\taa/\t\u000f\r5W\u0001\"\u0003\u0004P\"I1q[\u0003\u0012\u0002\u0013%1\u0011\u001c\u0005\b\u0007;,A\u0011BBp\u0011\u001d!i!\u0002C\u0005\t\u001fAq\u0001\"\u0006\u0006\t\u0013!9\"\u0001\tBe\u000eD\u0017N^5oON+'O^5dK*\u00111\bP\u0001\bg\u0016\u0014h/[2f\u0015\tid(A\u0005yYJ,G.Z1tK*\u0011q\bQ\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!Q\u0001\u0004G>l7\u0001\u0001\t\u0003\t\u0006i\u0011A\u000f\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u001c2!A$N!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u0019\te.\u001f*fMB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0006g24GG\u001b\u0006\u0002%\u0006AqM]5{u2,G-\u0003\u0002U\u001f\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001D\u0003i!Wm]3sS\u0006d\u0017N_3Be\u000eD\u0017N^3e%\u0016dW-Y:f)\rIv\f\u001c\t\u00035vk\u0011a\u0017\u0006\u00039r\na\u0001Z8nC&t\u0017B\u00010\\\u0005\u001d\u0011V\r\\3bg\u0016DQ\u0001Y\u0002A\u0002\u0005\f1B]3mK\u0006\u001cXMS:p]B\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001Z%\u000e\u0003\u0015T!A\u001a\"\u0002\rq\u0012xn\u001c;?\u0013\tA\u0017*\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015J\u0011\u0015i7\u00011\u0001o\u0003)\u0011X\r]8tSR|'/\u001f\t\u0003_Nl\u0011\u0001\u001d\u0006\u0003[FT!A\u001d \u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001\u001e9\u0003#I+\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0001\u0007hKRluN\u001c;i3\u0016\f'\u000f\u0006\u0002bo\")\u0001\u0010\u0002a\u0001s\u0006I1\u000f^1si\u0012\u000bG/\u001a\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018\u0001\u0002;j[\u0016T!A`@\u0002\t)|G-\u0019\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)a\u001f\u0002\t\t\u0006$X\rV5nKN\u0019QaR'\u0002!\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001cXCAA\u0007!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\ny\u0005\u0011AMY\u0005\u0005\u0003/\t\tB\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\u0006\t\u0012M]2iSZ,GMU3mK\u0006\u001cXm\u001d\u0011\u0002-\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c8+Z1sG\"\u0004B!a\u0004\u0002 %!\u0011\u0011EA\t\u0005Y\t%o\u00195jm\u0016$'+\u001a7fCN,7oU3be\u000eD\u0017AH1sG\"Lg/\u001a3BGRLg/\u001b;z\u0019><7oU3sS\u0006d\u0017N_3s!\r!\u0015qE\u0005\u0004\u0003SQ$AH!sG\"Lg/\u001a3BGRLg/\u001b;z\u0019><7oU3sS\u0006d\u0017N_3s\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u0001\u001fG>l\u0007\u000f\\3uK\u0012\u0014V\r\\3bg\u0016\u001cX\t\u001f9peR\u001cVM\u001d<jG\u0016\u00042\u0001RA\u0019\u0013\r\t\u0019D\u000f\u0002\u001e\u0007>l\u0007\u000f\\3uK\u0012\u0014V\r\\3bg\u0016,\u0005\u0010]8siN+'O^5dK\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\t\u0005e\u0012QH\u0007\u0003\u0003wQ!!\u001c\u001f\n\t\u0005}\u00121\b\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018\u0001\u00063fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002:\u0005\u0015\u0013\u0002BA$\u0003w\u0011A\u0003R3qK:$WM\\2z%\u0016\u0004xn]5u_JL\u0018a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005EC(\u0001\u0004bGR|'o]\u0005\u0005\u0003+\nyEA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-\u0001\buK\u0006l'+\u001a9pg&$xN]=\u0011\t\u0005e\u00121L\u0005\u0005\u0003;\nYD\u0001\bUK\u0006l'+\u001a9pg&$xN]=\u0002\u0015M,7-\u001e:fI\u000eK7\u000f\u0005\u0003\u0002:\u0005\r\u0014\u0002BA3\u0003w\u0011!bU3dkJ,GmQ5t\u0003m\u0011X\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ssB!\u0011\u0011HA6\u0013\u0011\ti'a\u000f\u00037I+G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:z\u00039\u0019w.\\7f]R\u001cVM\u001d<jG\u0016\u00042\u0001RA:\u0013\r\t)H\u000f\u0002\u000f\u0007>lW.\u001a8u'\u0016\u0014h/[2f\u0003e1\u0017mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0011\t\u0005e\u00121P\u0005\u0005\u0003{\nYDA\rGC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014H\u0003HAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0002\u0018\u0006e\u00151\u0014\t\u0003\t\u0016Aq!!\u0003\u0015\u0001\u0004\ti\u0001C\u0004\u0002\u001cQ\u0001\r!!\b\t\u000f\u0005\rB\u00031\u0001\u0002&!1\u00111\u0006\u000bA\u00029Dq!!\f\u0015\u0001\u0004\ty\u0003C\u0004\u00026Q\u0001\r!a\u000e\t\u000f\u0005\u0005C\u00031\u0001\u0002D!9\u0011\u0011\n\u000bA\u0002\u0005-\u0003bBA,)\u0001\u0007\u0011\u0011\f\u0005\b\u0003?\"\u0002\u0019AA1\u0011\u001d\t9\u0007\u0006a\u0001\u0003SBq!a\u001c\u0015\u0001\u0004\t\t\bC\u0004\u0002xQ\u0001\r!!\u001f)\u0007Q\ty\n\u0005\u0003\u0002\"\u0006MVBAAR\u0015\u0011\t)+a*\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002*\u0006-\u0016a\u00024bGR|'/\u001f\u0006\u0005\u0003[\u000by+A\u0003cK\u0006t7OC\u0002\u00022~\fqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0003k\u000b\u0019KA\u0005BkR|w/\u001b:fI\u0006q\u0011M]2iSZ,'+\u001a7fCN,G\u0003BA^\u0003\u0003\u00042\u0001SA_\u0013\r\ty,\u0013\u0002\u0005+:LG\u000f\u0003\u0004\u0002DV\u0001\r!Y\u0001\ne\u0016dW-Y:f\u0013\u0012D3!FAd!\u0011\tI-!6\u000e\u0005\u0005-'\u0002BAS\u0003\u001bTA!a4\u0002R\u00069Q.\u001a;sS\u000e\u001c(bAAj\u0001\u0006A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002X\u0006-'!\u0002+j[\u0016$\u0017AE1sG\"Lg/Z!ui\u0006\u001c\u0007.\\3oiN$B!a/\u0002^\"1\u0011q\u001c\fA\u0002e\u000bqA]3mK\u0006\u001cX-A\nbe\u000eD\u0017N^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0002<\u0006\u0015\bBBAp/\u0001\u0007\u0011,A\feK2,G/\u001a)sK\u0006\u00138\r[5wKJ+G.Z1tKR!\u00111^Ay!\rA\u0015Q^\u0005\u0004\u0003_L%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u0007D\u0002\u0019A1)\u0007a\t9-A\tqe\u0016\f%o\u00195jm\u0016\u0014V\r\\3bg\u0016$B!a/\u0002z\"1\u0011q\\\rA\u0002eC3!GAd\u0003)9W\r\u001e*fY\u0016\f7/\u001a\u000b\u00043\n\u0005\u0001BBAb5\u0001\u0007\u0011\rF\u0003Z\u0005\u000b\u00119\u0001\u0003\u0004\u0002Dn\u0001\r!\u0019\u0005\b\u0005\u0013Y\u0002\u0019AAv\u0003IIgn\u00197vI\u0016\u0004&/Z!sG\"Lg/\u001a3)\u0007m\t9-A\bhKR\u0014V\r\\3bg\u0016$\u0016\u000e\u001e7f)\r\t'\u0011\u0003\u0005\u0007\u0003\u0007d\u0002\u0019A1)\u0007q\t9-\u0001\u0005hKR\u0004\u0006.Y:f)\u0011\u0011IBa\b\u0011\u0007i\u0013Y\"C\u0002\u0003\u001em\u0013Q\u0001\u00155bg\u0016DaA!\t\u001e\u0001\u0004\t\u0017a\u00029iCN,\u0017\n\u001a\u0015\u0004;\u0005\u001d\u0017aB4fiR\u000b7o\u001b\u000b\u0005\u0005S\u0011y\u0003E\u0002[\u0005WI1A!\f\\\u0005\u0011!\u0016m]6\t\r\tEb\u00041\u0001b\u0003\u0019!\u0018m]6JI\"\u001aa$a2\u0002\u0017\u001d,GOV1sS\u0006\u0014G.\u001a\u000b\u0005\u0005s\u0011)\u0005\u0005\u0003\u0003<\t\u0005SB\u0001B\u001f\u0015\r\u0011ydW\u0001\nm\u0006\u0014\u0018.\u00192mKNLAAa\u0011\u0003>\tAa+\u0019:jC\ndW\r\u0003\u0004\u0003H}\u0001\r!Y\u0001\u000bm\u0006\u0014\u0018.\u00192mK&#\u0007fA\u0010\u0002H\u00061Q\r_5tiN$B!a;\u0003P!1!\u0011\u000b\u0011A\u0002\u0005\fAaY5JI\"\u001a\u0001%a2\u0002#\u0015D\u0018n\u001d;t!J,\u0017I]2iSZ,G\r\u0006\u0003\u0002l\ne\u0003B\u0002B)C\u0001\u0007\u0011\rK\u0002\"\u0003\u000f\fA\"\u001a=jgR\u001c()\u001f(b[\u0016$B!a;\u0003b!1!1\r\u0012A\u0002\u0005\f1B]3mK\u0006\u001cXMT1nK\"\u001a!%a2\u0002!\rDWmY6O_R\f%o\u00195jm\u0016$G\u0003BA^\u0005WBaA!\u0015$\u0001\u0004\t\u0007fA\u0012\u0002H\u0006\u0001\u0012\r\u001e;bG\"lWM\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0003W\u0014\u0019\b\u0003\u0004\u0003v\u0011\u0002\r!Y\u0001\rCR$\u0018m\u00195nK:$\u0018\n\u001a\u0015\u0004I\u0005\u001d\u0017!D4fi\u0006#H/Y2i[\u0016tG\u000f\u0006\u0003\u0003~\t\r\u0005c\u0001.\u0003\u0000%\u0019!\u0011Q.\u0003\u0015\u0005#H/Y2i[\u0016tG\u000f\u0003\u0004\u0003v\u0015\u0002\r!\u0019\u0015\u0004K\u0005\u001d\u0017aE4fi\u0006#H/Y2i[\u0016tGo\u00149uS>tG\u0003\u0002BF\u0005#\u0003R\u0001\u0013BG\u0005{J1Aa$J\u0005\u0019y\u0005\u000f^5p]\"1!Q\u000f\u0014A\u0002\u0005D3AJAd\u00039\u0019X-\u0019:dQJ+G.Z1tKN$BA!'\u0003*B)!1\u0014BS36\u0011!Q\u0014\u0006\u0005\u0005?\u0013\t+\u0001\u0003vi&d'B\u0001BR\u0003\u0011Q\u0017M^1\n\t\t\u001d&Q\u0014\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0003,\u001e\u0002\rA!,\u0002\u000f\u0019LG\u000e^3sgB!!q\u0016B_\u001b\t\u0011\tL\u0003\u0003\u00034\nU\u0016!\u00024pe6\u001c(\u0002\u0002B\\\u0005s\u000b!A^\u0019\u000b\u0007\tmF(A\u0002ba&LAAa0\u00032\ny!+\u001a7fCN,7OR5mi\u0016\u00148\u000fK\u0002(\u0003\u000f$\u0002B!'\u0003F\n\u001d'\u0011\u001b\u0005\b\u0005WC\u0003\u0019\u0001BW\u0011\u001d\u0011I\r\u000ba\u0001\u0005\u0017\fQ\u0001\\5nSR\u00042\u0001\u0013Bg\u0013\r\u0011y-\u0013\u0002\u0005\u0019>tw\rC\u0004\u0003T\"\u0002\rAa3\u0002\r=4gm]3uQ\rA\u0013qY\u00013M&tGm\u00155peR\u0014V\r\\3bg\u0016LEm],ji\"4u\u000e\u001c3fe:\u000bW.Z!oI>\u0013H-\u001a:De&$XM]5p]RQ!1\\B\u0002\u00073\u0019)c!\u000b\u0011\r\tu'q\u001dBv\u001d\u0011\u0011yNa9\u000f\u0007\u0011\u0014\t/C\u0001K\u0013\r\u0011)/S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119K!;\u000b\u0007\t\u0015\u0018\nE\u0004I\u0005[\u0014\tP!@\n\u0007\t=\u0018J\u0001\u0004UkBdWM\r\t\u0005\u0005g\u0014I0\u0004\u0002\u0003v*\u0019!q_.\u0002\u000bU$\u0018\u000e\\:\n\t\tm(Q\u001f\u0002\u0012\u0003\u0012\f\u0007\u000f^5wKJ+G.Z1tK&#\u0007c\u0001%\u0003\u0000&\u00191\u0011A%\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003,&\u0002\ra!\u0002\u0011\r\tu7qAB\u0006\u0013\u0011\u0019IA!;\u0003\u0007M+\u0017\u000f\u0005\u0003\u0004\u000e\rUQBAB\b\u0015\u0011\u0011Yk!\u0005\u000b\u0007\rMA(A\u0004sKB|'\u000f^:\n\t\r]1q\u0002\u0002\r%\u0016\u0004xN\u001d;GS2$XM\u001d\u0005\b\u00077I\u0003\u0019AB\u000f\u0003\u0015y'\u000fZ3s!\u0015A%QRB\u0010!\u0011\u0011yk!\t\n\t\r\r\"\u0011\u0017\u0002\u0011%\u0016dW-Y:f\u001fJ$WM]'pI\u0016D\u0011B!3*!\u0003\u0005\raa\n\u0011\u000b!\u0013iIa3\t\u0013\tM\u0017\u0006%AA\u0002\r\u001d\u0002fA\u0015\u0002H\u0006ad-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\tD\u000b\u0003\u0004(\rM2FAB\u001b!\u0011\u00199da\u0010\u000e\u0005\re\"\u0002BB\u001e\u0007{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0016*\u0003\u0003\u0004B\re\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006ad-\u001b8e'\"|'\u000f\u001e*fY\u0016\f7/Z%eg^KG\u000f\u001b$pY\u0012,'OT1nK\u0006sGm\u0014:eKJ\u001c%/\u001b;fe&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003U\u0019w.\u001e8u%\u0016dW-Y:fg\nK8\u000b^1ukN$Ba!\u0013\u0004bA9!ma\u0013\u0004P\rm\u0013bAB'W\n\u0019Q*\u00199\u0011\t\rE3qK\u0007\u0003\u0007'R1a!\u0016\\\u0003\u0019\u0019H/\u0019;vg&!1\u0011LB*\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vgB\u0019\u0001j!\u0018\n\u0007\r}\u0013JA\u0002J]RDqAa+-\u0001\u0004\u0011i\u000bK\u0002-\u0003\u000f\fQbY8v]R\u0014V\r\\3bg\u0016\u001cH\u0003BB%\u0007SBqAa+.\u0001\u0004\u0019)\u0001K\u0002.\u0003\u000f\f\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0019\tha\u001d\u0004~A)!Q\\B\u0004C\"91Q\u000f\u0018A\u0002\r]\u0014\u0001\u00023bi\u0016\u0004BAa'\u0004z%!11\u0010BO\u0005\u0011!\u0015\r^3\t\u000f\r}d\u00061\u0001\u0004\u0002\u0006A\u0001/Y4f'&TX\r\u0005\u0003\u0004\u0004\u000e%UBABC\u0015\u0011\u00199I!)\u0002\t1\fgnZ\u0005\u0005\u0007\u0017\u001b)IA\u0004J]R,w-\u001a:)\u00079\n9-\u0001\u0010be\u000eD\u0017N^3BY2LenY8nS:<G)\u001a9f]\u0012,gnY5fgR!\u00111XBJ\u0011\u0019\t\u0019m\fa\u0001C\"\u001aq&a2\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0004\u001c\u000e\u0005\u0006#\u0002BN\u0007;\u000b\u0017\u0002BBP\u0005;\u00131aU3u\u0011\u001d\u0019\u0019\u000b\ra\u0001\u00077\n1\u0002\\5nSRtU/\u001c2fe\"\u001a\u0001'a2\u0015\u0011\te5\u0011VBV\u0007[CqAa+2\u0001\u0004\u0011i\u000bC\u0004\u0003JF\u0002\raa\n\t\u000f\tM\u0017\u00071\u0001\u0004(\u0005Q2/Z1sG\"\u0014V\r\\3bg\u0016\u001c()\u001f*fY\u0016\f7/Z%egR!11WB[!\u0015\u0011ina\u0002Z\u0011\u001d\u00199L\ra\u0001\u0007c\n!B]3mK\u0006\u001cX-\u00133t\u0003\t\u001aX-\u0019:dQJ+G.Z1tKN\u0014\u0015m]5d\u000bb$()\u001f*fY\u0016\f7/Z%egR!1QXBf!\u0019\u0011ina\u0002\u0004@B!1\u0011YBd\u001b\t\u0019\u0019M\u0003\u0003\u0004F\u0006m\u0012!B9vKJL\u0018\u0002BBe\u0007\u0007\u00141CU3mK\u0006\u001cXMQ1tS\u000e$\u0015\r^1FqRDqaa.4\u0001\u0004\u0019\t(\u0001\thKR\u0014V\r\\3bg\u0016|\u0005\u000f^5p]R11\u0011[Bj\u0007+\u0004B\u0001\u0013BG3\"1\u00111\u0019\u001bA\u0002\u0005D\u0011B!\u00035!\u0003\u0005\r!a;\u00025\u001d,GOU3mK\u0006\u001cXm\u00149uS>tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rm'\u0006BAv\u0007g\tabZ3u%\u0016dW-Y:f\u0013R,W.\u0006\u0003\u0004b\u000e-H\u0003BBr\t\u0013!Ba!:\u0004~B)\u0001J!$\u0004hB!1\u0011^Bv\u0019\u0001!qa!<7\u0005\u0004\u0019yOA\u0001U#\u0011\u0019\tpa>\u0011\u0007!\u001b\u00190C\u0002\u0004v&\u0013qAT8uQ&tw\rE\u0002[\u0007sL1aa?\\\u0005!\u0001F.\u00198Ji\u0016l\u0007bBB\u0000m\u0001\u0007A\u0011A\u0001\bO\u0016$\u0018\n^3n!\u0019AE1A-\u0005\b%\u0019AQA%\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0002%\u0005\u0004\u0005\u001c9\u000f\u0003\u0004\u0005\fY\u0002\r!Y\u0001\u0007SR,W.\u00133\u0002#\u001d,GOV1sS\u0006\u0014G.Z(qi&|g\u000e\u0006\u0003\u0005\u0012\u0011M\u0001#\u0002%\u0003\u000e\ne\u0002B\u0002B$o\u0001\u0007\u0011-\u0001\u0010be\u000eD\u0017N^3BY2|U\u000f^4pS:<G)\u001a9f]\u0012,gnY5fgR!A\u0011\u0004C\u0011!\u0019\u0011ina\u0002\u0005\u001cA\u0019!\f\"\b\n\u0007\u0011}1L\u0001\u0006EKB,g\u000eZ3oGfDa!a89\u0001\u0004I\u0006fE\u0003\u0005&\u0011MBQ\u0007C\u001d\tw!)\u0005b\u0012\u0005R\u0011M\u0003\u0003\u0002C\u0014\t_i!\u0001\"\u000b\u000b\t\u0005\u0015F1\u0006\u0006\u0005\t[\ty+A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002C\u0019\tS\u0011Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017!\u0002<bYV,\u0017E\u0001C\u001c\u0003m\u0011X\r]8si&tw\r\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006Y\u0001O]8qC\u001e\fG/[8oI\t!i$\u0003\u0003\u0005@\u0011\u0005\u0013\u0001\u0003*F#VK%+\u0012#\u000b\t\u0011\rC\u0011F\u0001\f!J|\u0007/Y4bi&|g.A\u0005jg>d\u0017\r^5p]\u0012\u0012A\u0011J\u0005\u0005\t\u0017\"i%\u0001\bS\u000b\u0006#ulQ(N\u001b&#F+\u0012#\u000b\t\u0011=C\u0011F\u0001\n\u0013N|G.\u0019;j_:\f1B]8mY\n\f7m\u001b$pe2\u0012AQK\u0012\u0003\t/\u0002BA!8\u0005Z%!A1\fBu\u0005%!\u0006N]8xC\ndW\rK\u0002\u0006\t?\u0002B\u0001\"\u0019\u0005h5\u0011A1\r\u0006\u0005\tK\ny+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA\u0001\"\u001b\u0005d\t91+\u001a:wS\u000e,\u0007")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getMonthYear(DateTime dateTime) {
        return ArchivingService$.MODULE$.getMonthYear(dateTime);
    }

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter.read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (!this.releaseRepository.exists(releaseId) && this.existsPreArchived(releaseId)) {
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
                this.archivedReleases().setPreArchived(releaseId, false);
            }
        } else if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES), (Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
                this.releaseExtensionsRepository.decorate(release);
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
                CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                    task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveRelease$6(task, x$1)))).asJava()));
                    return BoxedUnit.UNIT;
                });
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
                } else {
                    this.archivedReleases().updateViewers(releaseId, (scala.collection.immutable.Seq<Team>)CollectionConverters$.MODULE$.ListHasAsScala(updatedTeams).asScala().toSeq());
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
                    this.releaseRepository.delete(releaseId);
                    ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).foreach((Function1 & Serializable)facet -> {
                        ArchivingService.$anonfun$archiveRelease$10(this, facet);
                        return BoxedUnit.UNIT;
                    });
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        CollectionConverters$.MODULE$.ListHasAsScala(release.getAttachments()).asScala().foreach((Function1 & Serializable)attachment -> {
            ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
            return BoxedUnit.UNIT;
        });
    }

    private void archiveDependencies(Release release) {
        scala.collection.immutable.Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public boolean deletePreArchiveRelease(String releaseId) {
        return this.archivedReleases().deleteReleaseFromArchive(releaseId);
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            scala.collection.immutable.Seq<Facet> facets = ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).genericRepository().findAllFacetsByRelease(release);
            CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
                task.setFacets(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$3(task, x$2)))).asJava()));
                return BoxedUnit.UNIT;
            });
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                scala.collection.immutable.Set<Type> specialTypes = this.facetRepositoryDispatcher.supportedTypes();
                ((IterableOnceOps)((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).findAllFacetsByRelease(release).filter((Function1 & Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$preArchiveRelease$5(specialTypes, facet)))).foreach((Function1 & Serializable)liveFacet -> $this.facetRepositoryDispatcher.archiveRepository().create((Facet)liveFacet));
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            } else {
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(51).append("Deleting tutorial release ").append(release).append(" instead of pre-archiving").toString());
                this.releaseRepository.delete(release.getId());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable)x$3 -> (Function1 & Serializable)x$1 -> x$3.getPhase(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable)x$4 -> (Function1 & Serializable)x$1 -> x$4.getTask(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$5 -> (Function1 & Serializable)x$1 -> x$5.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable)x$6 -> (Function1 & Serializable)x$1 -> x$6.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(56).append("You cannot perform this operation on archived release [").append(Ids.releaseIdFrom((String)ciId)).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public List<Tuple2<AdaptiveReleaseId, Object>> findShortReleaseIdsWithFolderNameAndOrderCriterion(scala.collection.immutable.Seq<ReportFilter> filters, Option<ReleaseOrderMode> order, Option<Object> limit, Option<Object> offset) {
        return this.archivedReleasesSearch.searchReleaseIdsAndOrderCriterion(filters, order, limit, offset);
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> findShortReleaseIdsWithFolderNameAndOrderCriterion$default$4() {
        return None$.MODULE$;
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleases(scala.collection.immutable.Seq<ReportFilter> filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        scala.collection.immutable.Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releaseJsons.map((Function1 & Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter))).asJava();
    }

    public scala.collection.immutable.Seq<Release> searchReleasesByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        scala.collection.immutable.Seq<String> releaseJsons = this.archivedReleasesSearch.searchReleasesByIds(releaseIds);
        return (scala.collection.immutable.Seq)releaseJsons.map((Function1 & Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter));
    }

    public scala.collection.immutable.Seq<ReleaseBasicDataExt> searchReleasesBasicExtByReleaseIds(scala.collection.immutable.Seq<String> releaseIds) {
        return this.archivedReleasesSearch.searchReleasesBasicInfoByIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIds.map((Function1 & Serializable)x$8 -> FullReleaseId$.MODULE$.apply((String)x$8).withOnlyOneParentOrApplicationsForArchiveDb())));
    }

    private Option<Release> getReleaseOption(String releaseId, boolean includePreArchived) {
        return this.archivedReleases().getRelease(releaseId, includePreArchived).map((Function1 & Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = this.archivedReleases().getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable)() -> new StringBuilder(63).append("Could not find attachment ").append(attachment.getId()).append(" of release ").append(releaseId).append(" in the attachments table").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private boolean getReleaseOption$default$2() {
        return false;
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable)release -> CollectionConverters$.MODULE$.ListHasAsScala(release.getVariables()).asScala().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$9))));
    }

    private scala.collection.immutable.Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        Buffer dependencies = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$10 -> CollectionConverters$.MODULE$.ListHasAsScala(x$10.getDependencies()).asScala())).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$11)));
        dependencies.foreach((Function1 & Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
        return dependencies.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$archiveRelease$6(Task task$1, Facet x$1) {
        String string = x$1.getTargetId();
        String string2 = task$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$10(ArchivingService $this, Facet facet) {
        ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete(facet.getId(), ((FacetRepository.FacetTypeDispatcher)((Object)$this.facetRepositoryDispatcher.liveRepository())).delete$default$2());
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, WorkDir workDir$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
            workDir$1.delete();
            WorkDirContext.clear();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        WorkDirContext.initWorkdir();
        WorkDir workDir = WorkDirContext.get();
        Try$.MODULE$.apply((Function0 & Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, workDir, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$3(Task task$2, Facet x$2) {
        String string = x$2.getTargetId();
        String string2 = task$2.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$preArchiveRelease$5(scala.collection.immutable.Set specialTypes$1, Facet facet) {
        Type type = facet.getType();
        return specialTypes$1.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)type.instanceOf(x$1)));
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        scala.collection.immutable.Seq rawDependenciesToArchive = (scala.collection.immutable.Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)rawDependenciesToArchive.map((Function1 & Serializable)x$7 -> x$7.getId())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$9) {
        String string = x$9.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$11) {
        return !x$11.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService, FacetRepositoryDispatcher facetRepositoryDispatcher) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        Logging.$init$((Logging)this);
        facetRepositoryDispatcher.setupGenericFacetArchiveRepository(this);
    }
}

