/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentStageService;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.service.FolderService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001B\t\u0013\u0001uA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\t\u0011M\u0003!\u0011!Q\u0001\n5CQ\u0001\u0016\u0001\u0005\u0002UCQ\u0001\u001c\u0001\u0005\u00025Dq!a\n\u0001\t\u0003\tI\u0003C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\u0012!#\u00128wSJ|g.\\3oiN+'O^5dK*\u00111\u0003F\u0001\bg\u0016\u0014h/[2f\u0015\t)b#\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002\u00181\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00033i\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003m\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0006g24GG\u001b\u0006\u0002S\u0005AqM]5{u2,G-\u0003\u0002,M\t9Aj\\4hS:<\u0017!F3om&\u0014xN\\7f]R\u0014V\r]8tSR|'/\u001f\t\u0003]Ej\u0011a\f\u0006\u0003aQ\t!B]3q_NLGo\u001c:z\u0013\t\u0011tFA\u000bF]ZL'o\u001c8nK:$(+\u001a9pg&$xN]=\u0002'\u0015tg/\u001b:p]6,g\u000e^*fGV\u0014\u0018\u000e^=\u0011\u0005U2T\"\u0001\n\n\u0005]\u0012\"aE#om&\u0014xN\\7f]R\u001cVmY;sSRL\u0018a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0011M,7-\u001e:jifT!A\u0010\r\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001Q\u001e\u0003\u0017I{G.Z*feZL7-Z\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0011\u0005\r+U\"\u0001#\u000b\u0005M1\u0012B\u0001$E\u000551u\u000e\u001c3feN+'O^5dK\u00069RM\u001c<je>tW.\u001a8u'R\fw-Z*feZL7-\u001a\t\u0003k%K!A\u0013\n\u0003/\u0015sg/\u001b:p]6,g\u000e^*uC\u001e,7+\u001a:wS\u000e,\u0017\u0001C3wK:$()^:\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001\u0015\f\u0002\r\u00154XM\u001c;t\u0013\t\u0011vJA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\rqJg.\u001b;?)\u001d1v\u000bW-[7r\u0003\"!\u000e\u0001\t\u000b1B\u0001\u0019A\u0017\t\u000bMB\u0001\u0019\u0001\u001b\t\u000baB\u0001\u0019A\u001d\t\u000b\u0005C\u0001\u0019\u0001\"\t\u000b\u001dC\u0001\u0019\u0001%\t\u000b-C\u0001\u0019A')\u0005!q\u0006CA0k\u001b\u0005\u0001'BA1c\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003G\u0012\fqAZ1di>\u0014\u0018P\u0003\u0002fM\u0006)!-Z1og*\u0011q\r[\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011.A\u0002pe\u001eL!a\u001b1\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AE:fCJ\u001c\u0007.\u00128wSJ|g.\\3oiN$\"A\\?\u0011\u0007=$h/D\u0001q\u0015\t\t(/\u0001\u0003vi&d'\"A:\u0002\t)\fg/Y\u0005\u0003kB\u0014A\u0001T5tiB\u0011qo_\u0007\u0002q*\u0011Q#\u001f\u0006\u0003uZ\ta\u0001Z8nC&t\u0017B\u0001?y\u0005-)eN^5s_:lWM\u001c;\t\u000byL\u0001\u0019A@\u0002%\u0015tg/\u001b:p]6,g\u000e\u001e$jYR,'o\u001d\t\u0005\u0003\u0003\ty!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u00191\u0017\u000e\u001c;fe*!\u0011\u0011BA\u0006\u0003\t1\u0018GC\u0002\u0002\u000eY\t1!\u00199j\u0013\u0011\t\t\"a\u0001\u0003%\u0015sg/\u001b:p]6,g\u000e\u001e$jYR,'o\u001d\u0015\u0004\u0013\u0005U\u0001\u0003BA\f\u0003Gi!!!\u0007\u000b\u0007\u0005\fYB\u0003\u0003\u0002\u001e\u0005}\u0011aB7fiJL7m\u001d\u0006\u0004\u0003CQ\u0012\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005\u0015\u0012\u0011\u0004\u0002\u0006)&lW\rZ\u0001\u0014M&tG-\u00128wSJ|g.\\3oi\nK\u0018\n\u001a\u000b\u0004m\u0006-\u0002bBA\u0017\u0015\u0001\u0007\u0011qF\u0001\u000eK:4\u0018N]8o[\u0016tG/\u00133\u0011\t\u0005E\u0012q\b\b\u0005\u0003g\tY\u0004E\u0002\u00026\u0001j!!a\u000e\u000b\u0007\u0005eB$\u0001\u0004=e>|GOP\u0005\u0004\u0003{\u0001\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002B\u0005\r#AB*ue&twMC\u0002\u0002>\u0001B3ACA\u000b\u0003E\u0019'/Z1uK\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0004m\u0006-\u0003BBA'\u0017\u0001\u0007a/A\u0006f]ZL'o\u001c8nK:$\bfA\u0006\u0002\u0016\u0005\tR\u000f\u001d3bi\u0016,eN^5s_:lWM\u001c;\u0015\u0007Y\f)\u0006\u0003\u0004\u0002N1\u0001\rA\u001e\u0015\u0004\u0019\u0005U\u0011!\u00053fY\u0016$X-\u00128wSJ|g.\\3oiR!\u0011QLA2!\ry\u0012qL\u0005\u0004\u0003C\u0002#\u0001B+oSRDq!!\f\u000e\u0001\u0004\ty\u0003K\u0002\u000e\u0003+\t\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\u0003;\nY\u0007\u0003\u0004\u0002N9\u0001\rA^\u0001\u000em\u0006d\u0017\u000eZ1uKRKG\u000f\\3\u0015\t\u0005u\u0013\u0011\u000f\u0005\u0007\u0003\u001bz\u0001\u0019\u0001<\u0002'Y\fG.\u001b3bi\u0016$Um]2sSB$\u0018n\u001c8\u0015\t\u0005u\u0013q\u000f\u0005\u0007\u0003\u001b\u0002\u0002\u0019\u0001<)\u0007\u0001\tY\b\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\tIZ\u0001\u000bgR,'/Z8usB,\u0017\u0002BAC\u0003\u007f\u0012qaU3sm&\u001cW\r")
public class EnvironmentService
implements Logging {
    private final EnvironmentRepository environmentRepository;
    private final EnvironmentSecurity environmentSecurity;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentService environmentService = this;
        synchronized (environmentService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public List<Environment> searchEnvironments(EnvironmentFilters environmentFilters) {
        this.environmentSecurity.checkView();
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentRepository.searchEnvironments(environmentFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Environment findEnvironmentById(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentRepository.findEnvironmentById(environmentId);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Environment createEnvironment(Environment environment) {
        void var2_2;
        this.environmentSecurity.checkCreate();
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment");
        this.validate(environment);
        Environment created = this.environmentRepository.createEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentCreatedEvent(created));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Environment updateEnvironment(Environment environment) {
        void var2_2;
        this.environmentSecurity.checkEdit();
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Updating environment [").append((Object)environment).append("]").toString());
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environment);
        Environment updated = this.environmentRepository.updateEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentUpdatedEvent(environment));
        return var2_2;
    }

    @Timed
    public void deleteEnvironment(String environmentId) {
        this.environmentSecurity.checkEdit();
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Deleting environment [").append(environmentId).append("]").toString());
        Environment environment = this.environmentRepository.findEnvironmentById(environmentId);
        this.environmentRepository.deleteEnvironment(environmentId);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentDeletedEvent(environment));
    }

    private void validate(Environment environment) {
        this.validateTitle(environment);
        this.validateDescription(environment);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environment.getStage()).exists((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$validate$1(stage))), (String)"Environment stage ID is required", (Object[])new Object[0]);
    }

    private void validateTitle(Environment environment) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateDescription(Environment environment) {
        block0: {
            if (environment.getDescription() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Description cannot be blank", (Object[])new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(EnvironmentStage stage) {
        return StringUtils.hasText((String)stage.getId());
    }

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, EnvironmentSecurity environmentSecurity, RoleService roleService, FolderService folderService, EnvironmentStageService environmentStageService, XLReleaseEventBus eventBus) {
        this.environmentRepository = environmentRepository;
        this.environmentSecurity = environmentSecurity;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

