/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.PhaseCloseOperation;
import com.xebialabs.xlrelease.events.PhaseCompleteOperation;
import com.xebialabs.xlrelease.events.PhaseFailOperation;
import com.xebialabs.xlrelease.events.PhaseRetryOperation;
import com.xebialabs.xlrelease.events.PhaseStartFailingOperation;
import com.xebialabs.xlrelease.events.PhaseStartOperation;
import com.xebialabs.xlrelease.events.ReleaseAbortScriptsExecution;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(description="A phase in a release that contains tasks.", versioned=false)
public class Phase
extends PlanItem
implements TaskContainer {
    private static final Logger logger = LoggerFactory.getLogger(Phase.class);
    @Property(asContainment=true, required=false, description="The list of tasks in this phase.")
    private List<Task> tasks = new ArrayList<Task>();
    @Property(asContainment=true, description="The release this phase belongs to.")
    private Release release;
    @Property(description="The state the phase is in.")
    protected PhaseStatus status;
    @Property(description="The color of the phase top bar in the UI. Format: #(hex value); for example '#009CDB'")
    protected String color;
    @Property(required=false, description="If given, then this phase has been copied as a part of restart phase operation based on this id")
    protected String originId;

    @Override
    @PublicApiMember
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public Task getCurrentTask() {
        return this.getTasks().stream().filter(task -> task.getStatus() != null && task.getStatus().isActive()).findFirst().orElse(null);
    }

    public boolean hasCurrentTask() {
        return this.getCurrentTask() != null;
    }

    @Override
    public Release getRelease() {
        return this.release;
    }

    @Override
    public String getDisplayPath() {
        return this.getRelease().getDisplayPath() + " / " + this.getTitle();
    }

    public void setRelease(Release release) {
        this.release = release;
    }

    @PublicApiMember
    public PhaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(PhaseStatus status) {
        this.status = status;
    }

    @PublicApiMember
    public String getColor() {
        return this.color;
    }

    @PublicApiMember
    public void setColor(String color) {
        this.color = color;
    }

    public String getOriginId() {
        return this.originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
    }

    @VisibleForTesting
    void complete(Changes changes) {
        this.setStatus(PhaseStatus.COMPLETED);
        this.setEndDate(new Date());
        this.freezeVariables();
        changes.update(this);
        changes.addOperation(new PhaseCompleteOperation(this));
    }

    private void freezeVariables() {
        if (this.getRelease() == null) {
            return;
        }
        Map<String, String> variables = this.getRelease().getAllStringVariableValues();
        if (variables == null || variables.isEmpty()) {
            return;
        }
        this.setTitle(VariableHelper.replaceAll(this.getTitle(), VariableHelper.filterOutBlankStringVariables(variables), new HashSet<String>(), false));
        this.setDescription(VariableHelper.replaceAll(this.getDescription(), variables, new HashSet<String>(), false));
    }

    private Task findTopLevelTask(String taskId) {
        for (Task task : this.tasks) {
            if (!Ids.getTopLevelTaskId(taskId).equals(task.getId())) continue;
            return task;
        }
        return null;
    }

    @VisibleForTesting
    Task findNextActivableTask() {
        for (Task task : this.tasks) {
            if (task.isDone()) continue;
            return task;
        }
        return null;
    }

    public Changes start() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.IN_PROGRESS);
        this.setStartDate(new Date());
        changes.update(this);
        changes.addOperation(new PhaseStartOperation(this));
        this.tryStartingNextTask(changes);
        return changes;
    }

    public Changes startPendingTask(String targetTaskId) {
        Changes changes = new Changes();
        Task task = this.findTopLevelTask(targetTaskId);
        if (task != null) {
            changes.addAll(task.startPending(targetTaskId));
            this.checkTaskStatus(task, changes);
        }
        return changes;
    }

    public Changes startWithInput(String targetTaskId) {
        Changes changes = new Changes();
        Task task = this.getTask(targetTaskId);
        if (task != null) {
            changes.addAll(task.startWithInput());
            this.checkTaskStatus(task, changes);
        }
        return changes;
    }

    public Changes taskPreconditionValidated(String targetTaskId) {
        Changes changes = new Changes();
        Task task = this.findTopLevelTask(targetTaskId);
        if (task != null) {
            changes.addAll(task.startNow(targetTaskId, false));
            this.checkTaskStatus(task, changes);
        }
        return changes;
    }

    private void startActivableTask(Task firstTask, Changes changes) {
        try {
            Changes newChanges = firstTask.start();
            changes.addAll(newChanges);
            this.checkTaskStatus(firstTask, changes);
        }
        catch (Exception e) {
            logger.error("Unable to start task '{}' with id:'{}'", new Object[]{firstTask.getTitle(), firstTask.getId(), e});
            changes.addAll(this.failTask(firstTask.getId(), e.getMessage(), User.SYSTEM));
        }
    }

    private void checkTaskStatus(Task firstTask, Changes changes) {
        if (firstTask.isDone()) {
            this.tryStartingNextTask(changes);
        } else if (firstTask.isFailed()) {
            changes.addAll(this.fail());
        }
    }

    private void tryStartingNextTask(Changes changes) {
        Task nextTask = this.findNextActivableTask();
        if (nextTask == null) {
            this.complete(changes);
        } else {
            this.startActivableTask(nextTask, changes);
        }
    }

    public Changes markTaskAsDone(String taskId, TaskStatus status) {
        Changes changes = new Changes();
        Task topLevelTask = this.findTopLevelTask(taskId);
        if (topLevelTask == null) {
            return changes;
        }
        changes.addAll(this.recoverPhaseIfNeeded());
        changes.addAll(topLevelTask.markAsDone(taskId, status));
        if (topLevelTask.isDone()) {
            this.tryStartingNextTask(changes);
        } else if (topLevelTask.isFailed()) {
            changes.addAll(this.fail());
        } else if (topLevelTask.isFailing()) {
            changes.addAll(this.failing());
        }
        return changes;
    }

    private Changes recoverPhaseIfNeeded() {
        Changes changes = new Changes();
        if (this.getStatus() == PhaseStatus.FAILED || this.getStatus() == PhaseStatus.FAILING) {
            this.setStatus(PhaseStatus.IN_PROGRESS);
            changes.update(this);
            changes.addOperation(new PhaseRetryOperation(this));
        }
        return changes;
    }

    public Changes failTask(String targetTaskId, String failReason, User user) {
        return this.failTask(targetTaskId, failReason, user, false);
    }

    public Changes failTask(String targetTaskId, String failReason, User user, boolean fromAbort) {
        Changes changes = new Changes();
        Task task = this.findTopLevelTask(targetTaskId);
        if (task == null) {
            return changes;
        }
        changes.addAll(task.fail(targetTaskId, failReason, user, fromAbort));
        if (task.isFailed()) {
            changes.addAll(this.fail());
        } else if (task.isFailing()) {
            changes.addAll(this.failing());
        }
        return changes;
    }

    public Changes retryTask(String taskId) {
        Changes changes = new Changes();
        Task task = this.findTopLevelTask(taskId);
        if (task == null) {
            return changes;
        }
        boolean taskWasInProgress = task.isInProgress();
        changes.addAll(task.retry(taskId));
        if (taskWasInProgress && task.isInProgress()) {
            return changes;
        }
        changes.update(this);
        changes.addOperation(new PhaseRetryOperation(this));
        if (!taskWasInProgress && task.isInProgress()) {
            this.setStatus(PhaseStatus.IN_PROGRESS);
        } else {
            this.recoverPhaseIfNeeded();
            this.checkTaskStatus(task, changes);
        }
        return changes;
    }

    public Changes abort() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.ABORTED);
        if (!this.hasStartDate()) {
            this.setStartDate(new Date());
        }
        this.setEndDate(new Date());
        changes.update(this);
        for (Task task : this.tasks) {
            changes.addAll(task.abort());
        }
        return changes;
    }

    public Changes fail() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.FAILED);
        changes.update(this);
        changes.addOperation(new PhaseFailOperation(this));
        return changes;
    }

    public Changes failing() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.FAILING);
        changes.update(this);
        changes.addOperation(new PhaseStartFailingOperation(this));
        return changes;
    }

    public Task getTask(Integer index) {
        return this.tasks.get(index);
    }

    public List<GateTask> getStartGates() {
        return this.getStartGates(this.tasks);
    }

    public List<GateTask> getEndGates() {
        ArrayList<Task> tasks = new ArrayList<Task>(this.tasks);
        Collections.reverse(tasks);
        List<GateTask> endGates = this.getStartGates(tasks);
        if (endGates.size() == this.tasks.size()) {
            return Collections.emptyList();
        }
        Collections.reverse(endGates);
        return endGates;
    }

    private List<GateTask> getStartGates(List<Task> tasks) {
        ArrayList<GateTask> gates = new ArrayList<GateTask>();
        for (Task task : tasks) {
            if (!task.isGate()) break;
            gates.add((GateTask)task);
        }
        return gates;
    }

    public boolean areStartGatesOpen() {
        return this.areGatesCompleted(this.getStartGates());
    }

    public boolean areEndGatesOpen() {
        return this.areGatesCompleted(this.getEndGates());
    }

    private boolean areGatesCompleted(Collection<GateTask> gates) {
        for (GateTask gate : gates) {
            if (gate.isDone()) continue;
            return false;
        }
        return true;
    }

    public Changes resetToPlanned() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.PLANNED);
        this.setStartDate(null);
        this.setEndDate(null);
        this.setOverdueNotified(false);
        changes.update(this);
        for (Task task : this.tasks) {
            changes.addAll(task.resetToPlanned());
        }
        return changes;
    }

    @Override
    public boolean hasBeenStarted() {
        return this.status != null && this.status.hasBeenStarted();
    }

    @Override
    public boolean isActive() {
        return this.status != null && this.status.isActive();
    }

    @Override
    public boolean isDone() {
        return this.status == PhaseStatus.COMPLETED || this.status == PhaseStatus.SKIPPED;
    }

    public boolean isDefunct() {
        return this.isAborted() || this.isDone();
    }

    @Override
    public boolean isUpdatable() {
        return !this.isDefunct();
    }

    @Override
    public boolean isAborted() {
        return this.status == PhaseStatus.ABORTED;
    }

    public boolean isPlanned() {
        return this.status == PhaseStatus.PLANNED;
    }

    public boolean isFailed() {
        return this.status == PhaseStatus.FAILED;
    }

    public boolean isFailing() {
        return this.status == PhaseStatus.FAILING;
    }

    public String getReleaseOwner() {
        return this.release.getOwner();
    }

    public List<GateTask> getAllGates() {
        return this.getAllTasks().stream().filter(task -> task instanceof GateTask).map(task -> (GateTask)task).collect(Collectors.toList());
    }

    public List<Task> getAllTasks() {
        ArrayList<Task> allTasks = new ArrayList<Task>();
        if (this.tasks != null) {
            for (Task task : this.tasks) {
                allTasks.addAll(task.getAllTasks());
            }
        }
        return allTasks;
    }

    @Override
    public List<PlanItem> getChildren() {
        ArrayList<PlanItem> children = new ArrayList<PlanItem>();
        children.addAll(this.getAllTasks());
        return children;
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
        for (Task task : this.tasks) {
            task.accept(visitor);
        }
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        return Arrays.asList(new PropertyUsagePoint(this, "title"), new PropertyUsagePoint(this, "description"));
    }

    public Changes close() {
        Changes changes = new Changes();
        this.setStatus(PhaseStatus.SKIPPED);
        this.setStartAndEndDatesIfEmpty();
        changes.update(this);
        Task currentTask = this.getCurrentTask();
        this.getAllTasks().stream().filter(task -> !task.isDone()).forEach(task -> {
            if (currentTask instanceof BaseScriptTask && currentTask.getId().equals(task.getId())) {
                if (currentTask instanceof CustomScriptTask && ((CustomScriptTask)currentTask).isUnknown()) {
                    task.setStatus(TaskStatus.SKIPPED);
                } else if (!task.getStatus().equals((Object)TaskStatus.FAILED)) {
                    task.setStatus(TaskStatus.COMPLETED);
                } else {
                    task.setStatus(TaskStatus.SKIPPED);
                }
            } else {
                task.setStatus(TaskStatus.SKIPPED);
            }
            task.setStartAndEndDatesIfEmpty();
            task.freezeVariables(changes, true);
            changes.update((ConfigurationItem)task);
        });
        changes.addOperation(new PhaseCloseOperation(this));
        changes.addOperation(new ReleaseAbortScriptsExecution(this.getRelease()));
        return changes;
    }

    public Task getTask(String taskId) {
        return this.getAllTasks().stream().filter(task -> Objects.equals(task.getId(), taskId)).findAny().orElse(null);
    }

    @Override
    public void addTask(Task task, int position) {
        this.getTasks().add(position, task);
        task.setContainer(this);
    }

    public void deleteTask(Task task) {
        if (!this.tasks.remove(task)) {
            this.tasks.forEach(t -> t.deleteTask(task));
        }
    }

    public boolean isOriginal() {
        return !StringUtils.hasText((String)this.originId);
    }

    public boolean isPhaseCopied() {
        List<Phase> phases = this.release.getPhases();
        if (phases == null) {
            return false;
        }
        for (Phase releasePhase : phases) {
            if (releasePhase.equals(this) || !this.getId().equals(releasePhase.getOriginId())) continue;
            return true;
        }
        return false;
    }

    public String getAncestorId() {
        if (StringUtils.hasText((String)this.getOriginId())) {
            return this.release.getPhase(this.getOriginId()).getAncestorId();
        }
        return this.getId();
    }

    public boolean isLatestCopy() {
        List<Phase> phases = this.release.getPhases();
        if (phases == null) {
            return false;
        }
        if (StringUtils.isEmpty((Object)this.originId)) {
            return !this.isPhaseCopied();
        }
        String ourAncestor = this.getAncestorId();
        ArrayList<Phase> copiesOfTheAncestorIHaveBeenCopiedFrom = new ArrayList<Phase>();
        for (Phase releasePhase : phases) {
            if (!ourAncestor.equals(releasePhase.getAncestorId())) continue;
            copiesOfTheAncestorIHaveBeenCopiedFrom.add(releasePhase);
        }
        if (copiesOfTheAncestorIHaveBeenCopiedFrom.isEmpty()) {
            return true;
        }
        Phase lastPhase = (Phase)copiesOfTheAncestorIHaveBeenCopiedFrom.get(copiesOfTheAncestorIHaveBeenCopiedFrom.size() - 1);
        return lastPhase == this;
    }
}

