/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskIds$;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001C\u0011!Y\u0005A!A!\u0002\u0013\u0019\u0005\"\u0002'\u0001\t\u0003i\u0005\"B2\u0001\t\u0003!\u0007\"\u0002<\u0001\t\u00039\bbBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007C\u0001\"!\"\u0001A\u0013%\u0011q\u0011\u0005\t\u0003\u0017\u0003\u0001\u0015\"\u0003\u0002\u000e\n\u0011\"+[:l!J|g-\u001b7f'\u0016\u0014h/[2f\u0015\t9\u0002$A\u0004tKJ4\u0018nY3\u000b\u0005eQ\u0012\u0001\u0002:jg.T!a\u0007\u000f\u0002\u0013ad'/\u001a7fCN,'BA\u000f\u001f\u0003%AXMY5bY\u0006\u00147OC\u0001 \u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013!B:mMRR'\"A\u0017\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\f\u0016\u0003\u000f1{wmZ5oO\u0006Y1-[%e'\u0016\u0014h/[2f!\t\u0011D'D\u00014\u0015\t9\"$\u0003\u00026g\tY1)[%e'\u0016\u0014h/[2f\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00029w5\t\u0011H\u0003\u0002;5\u0005Q!/\u001a9pg&$xN]=\n\u0005qJ$aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003q}J!\u0001Q\u001d\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t+\u0005\u0019\u0005C\u0001#J\u001b\u0005)%B\u0001$H\u0003\u0019)g/\u001a8ug*\u0011\u0001JG\u0001\u0007I>l\u0017-\u001b8\n\u0005)+%\u0001C#wK:$()^:\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013A\u0002\u001fj]&$h\bF\u0003O!F\u00136\u000b\u0005\u0002P\u00015\ta\u0003C\u00031\r\u0001\u0007\u0011\u0007C\u00037\r\u0001\u0007q\u0007C\u0003>\r\u0001\u0007a\bC\u0003B\r\u0001\u00071\t\u000b\u0002\u0007+B\u0011a+Y\u0007\u0002/*\u0011\u0001,W\u0001\u000bC:tw\u000e^1uS>t'B\u0001.\\\u0003\u001d1\u0017m\u0019;pefT!\u0001X/\u0002\u000b\t,\u0017M\\:\u000b\u0005y{\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0001\f1a\u001c:h\u0013\t\u0011wKA\u0005BkR|w/\u001b:fI\u000611M]3bi\u0016$\"!\u001a6\u0011\u0005\u0019DW\"A4\u000b\u0005!C\u0012BA5h\u0005-\u0011\u0016n]6Qe>4\u0017\u000e\\3\t\u000b-<\u0001\u0019A3\u0002\u0017IL7o\u001b)s_\u001aLG.\u001a\u0015\u0003\u000f5\u0004\"A\u001c;\u000e\u0003=T!\u0001\u00179\u000b\u0005E\u0014\u0018aB7fiJL7m\u001d\u0006\u0003gz\t\u0001bY8eC\"\fG.Z\u0005\u0003k>\u0014Q\u0001V5nK\u0012\fa!\u001a=jgR\u001cHC\u0001=|!\t\u0019\u00130\u0003\u0002{I\t9!i\\8mK\u0006t\u0007\"\u0002?\t\u0001\u0004i\u0018!\u0004:jg.\u0004&o\u001c4jY\u0016LE\rE\u0002\u007f\u0003\u0017q1a`A\u0004!\r\t\t\u0001J\u0007\u0003\u0003\u0007Q1!!\u0002!\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0002\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tI\u0001\n\u0015\u0003\u00115\f\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0004K\u0006]\u0001\"\u0002?\n\u0001\u0004i\bFA\u0005n\u00035)\u00070[:ug\nKH+\u001b;mKR\u0019\u00010a\b\t\r\u0005\u0005\"\u00021\u0001~\u0003\u0015!\u0018\u000e\u001e7fQ\tQQ.A\tgS:$')_%e\u001fJ$UMZ1vYR$2!ZA\u0015\u0011\u0015a8\u00021\u0001~Q\tYQ.A\u0004gS:$\u0017\t\u001c7\u0015\u0005\u0005E\u0002#BA\u001a\u0003{)WBAA\u001b\u0015\u0011\t9$!\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003w\tAA[1wC&!\u0011qHA\u001b\u0005\u0011a\u0015n\u001d;)\u00051i\u0017a\u00034j]\u0012\u0014\u0015\u0010V5uY\u0016$2!ZA$\u0011\u0019\tI%\u0004a\u0001{\u0006\u0001\"/[:l!J|g-\u001b7f)&$H.\u001a\u0015\u0003\u001b5\fa!\u001e9eCR,GcA3\u0002R!)1N\u0004a\u0001K\"\u0012a\"\\\u0001\u0007I\u0016dW\r^3\u0015\t\u0005e\u0013q\f\t\u0004G\u0005m\u0013bAA/I\t!QK\\5u\u0011\u0015ax\u00021\u0001~Q\tyQ.\u0001\u0003d_BLHcA3\u0002h!)A\u0010\u0005a\u0001{\"\u0012\u0001#\\\u0001\u000eO\u0016$(+\u001a4fe\u0016t7-Z:\u0015\t\u0005=\u0014Q\u0010\t\u0007\u0003g\ti$!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e:\u0003\u0015\tX/\u001a:z\u0013\u0011\tY(!\u001e\u0003!I+G.Z1tK\n\u000b7/[2ECR\f\u0007\"\u0002?\u0012\u0001\u0004i\bFA\tn\u0003i9WM\\3sCR,G)\u001a4bk2$(+[:l!J|g-\u001b7f+\u0005)\u0017AD2iK\u000e\\G)\u001e9mS\u000e\fG/\u001a\u000b\u0005\u00033\nI\t\u0003\u0004\u0002\"M\u0001\r!`\u0001\u0016O\u0016tWM]1uKJK7o\u001b)s_\u001aLG.Z%e+\u0005i\bf\u0001\u0001\u0002\u0012B!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018v\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tY*!&\u0003\u000fM+'O^5dK\u0002")
public class RiskProfileService
implements Logging {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskProfileService riskProfileService = this;
        synchronized (riskProfileService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public RiskProfile create(RiskProfile riskProfile) {
        this.checkDuplicate(riskProfile.getTitle());
        riskProfile.setId(this.generateRiskProfileId());
        this.configurationRepository.create((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationCreatedEvent((BaseConfiguration)riskProfile));
        return riskProfile;
    }

    @Timed
    public boolean exists(String riskProfileId) {
        return this.configurationRepository.exists(riskProfileId);
    }

    @Timed
    public RiskProfile findById(String riskProfileId) {
        return (RiskProfile)this.configurationRepository.read(riskProfileId);
    }

    @Timed
    public boolean existsByTitle(String title) {
        return this.configurationRepository.existsByTypeAndTitle(Type.valueOf(RiskProfile.class), title);
    }

    @Timed
    public RiskProfile findByIdOrDefault(String riskProfileId) {
        RiskProfile riskProfile;
        try {
            riskProfile = (RiskProfile)this.configurationRepository.read(riskProfileId);
        }
        catch (NotFoundException notFoundException) {
            riskProfile = this.generateDefaultRiskProfile();
        }
        return riskProfile;
    }

    @Timed
    public List<RiskProfile> findAll() {
        return this.configurationRepository.findAllByType(Type.valueOf(RiskProfile.class));
    }

    @Timed
    public RiskProfile findByTitle(String riskProfileTitle) {
        List profiles = this.configurationRepository.findAllByTypeAndTitle(Type.valueOf(RiskProfile.class), riskProfileTitle);
        int n = profiles.size();
        switch (n) {
            case 0: {
                throw new NotFoundException(new StringBuilder(40).append("Could not find risk profile for title [").append(riskProfileTitle).append("]").toString(), new Object[0]);
            }
        }
        return (RiskProfile)((Object)profiles.get(0));
    }

    @Timed
    public RiskProfile update(RiskProfile riskProfile) {
        RiskProfile currentRiskProfile = this.findById(riskProfile.getId());
        String string = currentRiskProfile.getTitle();
        String string2 = riskProfile.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkDuplicate(riskProfile.getTitle());
        }
        this.configurationRepository.update((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new RiskProfileUpdated(riskProfile));
        return riskProfile;
    }

    @Timed
    public void delete(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        this.configurationRepository.delete(riskProfileId);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationDeletedEvent((BaseConfiguration)riskProfile));
    }

    @Timed
    public RiskProfile copy(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        String copyRiskProfileTitle = riskProfile.getTitle();
        while (this.existsByTitle(copyRiskProfileTitle)) {
            copyRiskProfileTitle = RetryTitleGenerator.getNextTitle((String)copyRiskProfileTitle);
        }
        RiskProfile copyRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(this.generateRiskProfileId());
        copyRiskProfile.setTitle(copyRiskProfileTitle);
        copyRiskProfile.setRiskProfileAssessors(riskProfile.getRiskProfileAssessors());
        this.configurationRepository.create((BaseConfiguration)copyRiskProfile);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationCopiedEvent((BaseConfiguration)riskProfile, copyRiskProfile.getId()));
        return copyRiskProfile;
    }

    @Timed
    public List<ReleaseBasicData> getReferences(String riskProfileId) {
        return this.configurationRepository.getReferenceReleases(riskProfileId);
    }

    /*
     * WARNING - void declaration
     */
    public RiskProfile generateDefaultRiskProfile() {
        void var1_1;
        RiskProfile defaultRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(null);
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)RiskProfileService.$anonfun$generateDefaultRiskProfile$1(type)))).foreach((Function1 & Serializable)t -> {
            defaultRiskProfile.setValueFor(t, BoxesRunTime.unboxToInt((Object)t.getDescriptor().getPropertyDescriptor("score").getDefaultValue()));
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    private void checkDuplicate(String title) {
        if (this.existsByTitle(title)) {
            throw new ItemAlreadyExistsException("Risk profile '%s' already exist.", new Object[]{title});
        }
    }

    private String generateRiskProfileId() {
        return this.ciIdService.getUniqueId(Type.valueOf(RiskProfile.class), RiskIds$.MODULE$.RISK_PROFILE_CONFIGURATION_ROOT());
    }

    public static final /* synthetic */ boolean $anonfun$generateDefaultRiskProfile$1(Type type) {
        return !type.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskProfileService(CiIdService ciIdService, ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, EventBus eventBus) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

