/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesUserProfileResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesUserProfileResource.class);
    private PermissionChecker permissions;
    private UserProfileService userProfileService;

    public FixturesUserProfileResource(PermissionChecker permissions, UserProfileService userProfileService) {
        this.permissions = permissions;
        this.userProfileService = userProfileService;
    }

    @Path(value="/userProfile")
    @GET
    public Response searchUserProfile(@QueryParam(value="name") String username, @QueryParam(value="email") String userEmail, @QueryParam(value="fullName") String fullName) {
        this.permissions.check(PlatformPermissions.ADMIN);
        UserProfile profile = this.userProfileService.findByUsername(username);
        if (profile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        boolean sameEmail = Objects.equals(profile.getEmail(), userEmail);
        boolean sameFullName = Objects.equals(profile.getFullName(), fullName);
        return sameEmail && sameFullName ? Response.ok().build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="/userProfile")
    @POST
    public void createUserProfile(UserProfile userProfile) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating user profile: %s", userProfile.getName()));
        this.userProfileService.save(userProfile);
    }

    @Path(value="/userProfiles")
    @POST
    public void createUserProfiles(List<UserProfile> userProfiles) {
        logger.debug("Creating user profiles");
        userProfiles.forEach(this::createUserProfile);
    }

    @Path(value="/userProfile")
    @PUT
    public void updateUserProfile(UserProfile userProfile) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Updating user profile: %s", userProfile.getName()));
        this.userProfileService.save(userProfile);
    }

    @Path(value="/userProfile/{username:.*}")
    @DELETE
    public void deleteUserProfile(@PathParam(value="username") String username) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting user profile: %s", username));
        this.userProfileService.deleteByUsername(username);
    }
}

