import com.xhaus.jyson.JysonCodec as json

import re
from distutils.version import StrictVersion
class NexusV3:

    def __init__(self):
        self.data = []

    def processV3(self, request, context, resolution):
        # if continuation token is not null, performs this to get the remaining data before processing it
        if (resolution.get('continuationToken') is not None):
            return self.process_continuation_token(request, context, resolution)
        else:
            return resolution

    # handles logic to get data from pagination
    def process_continuation_token(self, request, context, resolution):
        finalResolution = resolution
        while (resolution.get('continuationToken') is not None):
            try:
                # create context from new token
                currContext = context + "&continuationToken=%s" % (resolution.get('continuationToken'))
                response = request.get(currContext, contentType='application/json')
                currResolution = json.loads(response.response)
                finalResolution.get('items').extend(currResolution.get('items'))
                resolution = currResolution
            except Exception as e:
                raise Exception(
                    "Error while processing continuationToken %s -> %s" % (resolution.get('continuationToken'), e))
        return finalResolution

    def get_latest_item(self, finalResolution):
        versionMap = {}
        print "Looking for highest version from results... "  # Debug
        for item in finalResolution.get('items'):
            versionMap[item.get('version')] = item
        versionList = list(versionMap.keys())
        try:
            versionList.sort(key=StrictVersion)  # Puts the largest at the back
        except:
            # if version has -snapshot uses this to sort and get latest item sent
            convert = lambda text: int(text) if text.isdigit() else text.lower()
            alphanum_key = lambda key: [convert(c) for c in re.split('([0-9]+)', key)]
            versionList.sort(key=alphanum_key)

        if versionList:  # If not empty
            version = versionList.pop()
            return versionMap[version]



