/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.CreateDeliveryStage;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.api.v1.forms.ValidatePattern;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/api/v1/delivery-patterns")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface DeliveryPatternApi
extends ApiService {
    @Override
    default public String serviceName() {
        return "deliveryPatternApi";
    }

    @POST
    @PublicApiMember
    public Delivery createPattern(Delivery var1);

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @PublicApiMember
    public Delivery getPattern(@PathParam(value="patternId") String var1);

    @GET
    @Path(value="/{patternIdOrTitle}")
    @PublicApiMember
    public Delivery getPatternByIdOrTitle(@PathParam(value="patternIdOrTitle") String var1);

    @POST
    @Path(value="/checkTitle")
    public boolean checkTitleUnique(ValidatePattern var1);

    @PUT
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @PublicApiMember
    public Delivery updatePattern(@PathParam(value="patternId") String var1, Delivery var2);

    @PublicApiMember
    public Delivery updatePattern(Delivery var1);

    @DELETE
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @PublicApiMember
    public void deletePattern(@PathParam(value="patternId") String var1);

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/duplicate")
    public Delivery duplicatePattern(@PathParam(value="patternId") String var1, DuplicateDeliveryPattern var2);

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/create")
    @PublicApiMember
    public Delivery createDeliveryFromPattern(@PathParam(value="patternId") String var1, CreateDelivery var2);

    @POST
    @Path(value="search")
    @PublicApiMember
    public List<Delivery> searchPatterns(DeliveryPatternFilters var1, @DefaultValue(value="0") @QueryParam(value="page") Long var2, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var3);

    @PublicApiMember
    public List<Delivery> searchPatterns(DeliveryPatternFilters var1);

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/stages")
    @PublicApiMember
    public Stage createStage(@PathParam(value="patternId") String var1, Stage var2);

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/stages/{position:\\d+}")
    @PublicApiMember
    public Stage createStage(@PathParam(value="patternId") String var1, Stage var2, @PathParam(value="position") Integer var3);

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/createStage")
    @PublicApiMember
    public Stage createStage(@PathParam(value="patternId") String var1, CreateDeliveryStage var2);

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}/stages")
    @PublicApiMember
    public List<Stage> getStages(@PathParam(value="patternId") String var1);

    @PublicApiMember
    public Stage updateStage(Stage var1);

    @PUT
    @Path(value="/{stageId:.*Stage[^/]*}")
    @PublicApiMember
    public Stage updateStage(@PathParam(value="stageId") String var1, Stage var2);

    @PUT
    @Path(value="/{stageId:.*Stage[^/]*}/batched")
    public Stage updateStageFromBatch(@PathParam(value="stageId") String var1, Stage var2);

    @DELETE
    @Path(value="/{stageId:.*Stage[^/]*}")
    @PublicApiMember
    public void deleteStage(@PathParam(value="stageId") String var1);

    @POST
    @Path(value="/{stageId:.*Stage[^/]*}/transitions")
    @PublicApiMember
    public Transition createTransition(@PathParam(value="stageId") String var1, Transition var2);

    @PUT
    @Path(value="/{transitionId:.*Transition[^/]*}")
    @PublicApiMember
    public Transition updateTransition(@PathParam(value="transitionId") String var1, Transition var2);

    @PublicApiMember
    public Transition updateTransition(Transition var1);

    @DELETE
    @Path(value="/{transitionId:.*Transition[^/]*}")
    @PublicApiMember
    public void deleteTransition(@PathParam(value="transitionId") String var1);

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    public TrackedItem createTrackedItem(@PathParam(value="patternId") String var1, TrackedItem var2);

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    public List<TrackedItem> getTrackedItems(@PathParam(value="patternId") String var1);

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    public TrackedItem updateTrackedItem(@PathParam(value="itemId") String var1, TrackedItem var2);

    @PublicApiMember
    public TrackedItem updateTrackedItem(TrackedItem var1);

    @DELETE
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    public void deleteTrackedItem(@PathParam(value="itemId") String var1);
}

