/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.principaldata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.principaldata.exceptions.GroupEmailNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class PrincipalDataProviderCache
implements PrincipalDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(PrincipalDataProviderCache.class);
    private static final int USER_DATA_TTL_IN_MINUTES = 30;
    private static final int USER_AUTHORITIES_TTL_IN_MINUTES = 30;
    private static final int USER_GROUP_EMAIL_TTL_IN_MINUTES = 1;
    private PrincipalDataProvider principalDataProvider;
    private LoadingCache<String, UserData> userDataCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, UserData>(){

        public UserData load(String username) throws Exception {
            return PrincipalDataProviderCache.this.principalDataProvider.getUserData(username);
        }
    });
    private LoadingCache<String, Collection<? extends GrantedAuthority>> authoritiesCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Collection<? extends GrantedAuthority>>(){

        public Collection<? extends GrantedAuthority> load(String username) {
            return PrincipalDataProviderCache.this.principalDataProvider.getAuthorities(username);
        }
    });
    private LoadingCache<String, String> groupEmailCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String groupName) throws Exception {
            String email = PrincipalDataProviderCache.this.principalDataProvider.getGroupEmail(groupName);
            if (email != null) {
                return email;
            }
            throw new GroupEmailNotFoundException(groupName);
        }
    });

    PrincipalDataProviderCache(PrincipalDataProvider principalDataProvider) {
        this.principalDataProvider = principalDataProvider;
    }

    public void clearCache() {
        this.userDataCache.invalidateAll();
        this.groupEmailCache.invalidateAll();
    }

    @Override
    public UserData getUserData(String username) {
        try {
            return (UserData)this.userDataCache.get((Object)username);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getGroupEmail(String groupName) {
        try {
            return (String)this.groupEmailCache.get((Object)groupName);
        }
        catch (ExecutionException e) {
            logger.warn("Cannot fetch group email: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities(String username) {
        try {
            return (Collection)this.authoritiesCache.get((Object)username);
        }
        catch (ExecutionException e) {
            logger.warn("Cannot fetch authorities: {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    @Override
    public void invalidate(String username) {
        this.userDataCache.invalidate((Object)username);
        this.authoritiesCache.invalidate((Object)username);
    }
}

