/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import akka.actor.Address;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.scheduler.Backpressure;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobQueueStopped;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.events.BroadcastJobEvent;
import com.xebialabs.xlrelease.scheduler.events.JobReservedEvent;
import com.xebialabs.xlrelease.scheduler.repository.DeleteById;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001\u0002\u000e\u001c\u0001\u0011B\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005y!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003F\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011I\u0003!Q1A\u0005\u0002MC\u0001B\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u00067\u0002!\t\u0001\u0018\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u0019\t\b\u0001)A\u0005I\"9!\u000f\u0001b\u0001\n\u0013\u0019\bB\u0002>\u0001A\u0003%A\u000fC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002BBA\u001a\u0001\u0011\u00051\rC\u0004\u00026\u0001!)%a\u000e\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u00111\n\u0001\u0005B\u00055\u0003bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003/\u0002A\u0011IA+\u0011\u001d\tI\u0006\u0001C!\u00037Bq!!\u001c\u0001\t\u0003\nyGA\bEK\u001a\fW\u000f\u001c;K_\n\fV/Z;f\u0015\taR$A\u0005tG\",G-\u001e7fe*\u0011adH\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001I\u0011\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0012\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001)3fL\u001c\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\taS&D\u0001\u001c\u0013\tq3D\u0001\u0005K_\n\fV/Z;f!\t\u0001T'D\u00012\u0015\t\u00114'A\u0003tY\u001a$$NC\u00015\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001c2\u0005\u001daunZ4j]\u001e\u0004\"\u0001\f\u001d\n\u0005eZ\"A\u0002(pI\u0016LE-A\u0007k_\n\u0014V\r]8tSR|'/_\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011qhG\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA!?\u00055QuN\u0019*fa>\u001c\u0018\u000e^8ss\u0006q!n\u001c2SKB|7/\u001b;pef\u0004\u0013\u0001\u00042bG.\u0004(/Z:tkJ,W#A#\u0011\u000512\u0015BA$\u001c\u00051\u0011\u0015mY6qe\u0016\u001c8/\u001e:f\u00035\u0011\u0017mY6qe\u0016\u001c8/\u001e:fA\u0005AQM^3oi\n+8/F\u0001L!\tau*D\u0001N\u0015\tqU$\u0001\u0004fm\u0016tGo]\u0005\u0003!6\u0013\u0001\"\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\n\u0011#Y2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s+\u0005!\u0006CA+Y\u001b\u00051&BA,\u001e\u0003\u0019\t7\r^8sg&\u0011\u0011L\u0016\u0002\u0012\u0003\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\u0018AE1di>\u00148+_:uK6Du\u000e\u001c3fe\u0002\na\u0001P5oSRtD#B/_?\u0002\f\u0007C\u0001\u0017\u0001\u0011\u0015Q\u0014\u00021\u0001=\u0011\u0015\u0019\u0015\u00021\u0001F\u0011\u0015I\u0015\u00021\u0001L\u0011\u0015\u0011\u0016\u00021\u0001U\u0003)yFn\\2bY*{'m]\u000b\u0002IB\u0019Q\r\u001c8\u000e\u0003\u0019T!a\u001a5\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002jU\u0006!Q\u000f^5m\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c4\u0003\u0015\u0011+G.Y=Rk\u0016,X\r\u0005\u0002-_&\u0011\u0001o\u0007\u0002\u0004\u0015>\u0014\u0017aC0m_\u000e\fGNS8cg\u0002\n!bX5t%Vtg.\u001b8h+\u0005!\bCA;y\u001b\u00051(BA<g\u0003\u0019\tGo\\7jG&\u0011\u0011P\u001e\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0017}K7OU;o]&tw\rI\u0001\u0007gV\u0014W.\u001b;\u0015\u0007u\f\t\u0001\u0005\u0002'}&\u0011qp\n\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u00049\u0001\rA\\\u0001\u0004U>\u0014\u0007f\u0001\b\u0002\bA!\u0011\u0011BA\f\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011AC1o]>$\u0018\r^5p]*!\u0011\u0011CA\n\u0003\u001diW\r\u001e:jGNT1!!\u0006\"\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\r\u0003\u0017\u0011Q\u0001V5nK\u0012\fab];c[&$X\t_5ti&tw\rF\u0002~\u0003?Aa!a\u0001\u0010\u0001\u0004q\u0017a\u0002:fa2\f7-\u001a\u000b\u0004{\u0006\u0015\u0002BBA\u0002!\u0001\u0007a\u000eK\u0002\u0011\u0003\u000f\t\u0011\"[:Sk:t\u0017N\\4\u0015\u0005\u00055\u0002c\u0001\u0014\u00020%\u0019\u0011\u0011G\u0014\u0003\u000f\t{w\u000e\\3b]\u0006IAn\\2bY*{'m]\u0001\u0004O\u0016$H#\u00018)\u0007M\tY\u0004\u0005\u0003\u0002>\u0005\u0005SBAA \u0015\r\tiaJ\u0005\u0005\u0003\u0007\nyDA\u0004uC&d'/Z2\u0002\t1|7m\u001b\u000b\u0004]\u0006%\u0003BBA\u0002)\u0001\u0007a.\u0001\u0004gS:L7\u000f\u001b\u000b\u0004{\u0006=\u0003BBA\u0002+\u0001\u0007a\u000eK\u0002\u0016\u0003\u000f\tQa\u001d;beR$\u0012!`\u0001\u0005gR|\u0007/\u0001\u0005dC:\u001cW\r\\%g)\ri\u0018Q\f\u0005\b\u0003?B\u0002\u0019AA1\u0003%\u0001(/\u001a3jG\u0006$X\rE\u0003\u0002d\u0005%d.\u0004\u0002\u0002f)\u0019\u0011q\r5\u0002\u0011\u0019,hn\u0019;j_:LA!a\u001b\u0002f\tI\u0001K]3eS\u000e\fG/Z\u0001\u0005g&TX\r\u0006\u0002\u0002rA\u0019a%a\u001d\n\u0007\u0005UtEA\u0002J]RDs\u0001AA=\u0003\u001f\u000b\t\n\u0005\u0003\u0002|\u0005-UBAA?\u0015\u0011\ti!a \u000b\t\u0005\u0005\u00151Q\u0001\bG>tG/\u001a=u\u0015\u0011\t))a\"\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!#\u0002\u0007=\u0014x-\u0003\u0003\u0002\u000e\u0006u$!B*d_B,\u0017!\u00039s_bLXj\u001c3fI\t\t\u0019*\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u0004+B%\u001e+EkX\"M\u0003N\u001b&\u0002BAM\u0003{\nqbU2pa\u0016$\u0007K]8ys6{G-\u001a\u0015\u0004\u0001\u0005u\u0005\u0003BAP\u0003Kk!!!)\u000b\t\u0005\r\u00161Q\u0001\u000bgR,'/Z8usB,\u0017\u0002BAT\u0003C\u0013\u0011bQ8na>tWM\u001c;")
public class DefaultJobQueue
implements JobQueue,
Logging,
NodeId {
    private final JobRepository jobRepository;
    private final Backpressure backpressure;
    private final EventBus eventBus;
    private final ActorSystemHolder actorSystemHolder;
    private final DelayQueue<Job> _localJobs;
    private final AtomicBoolean _isRunning;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        return !this.bitmap$0 ? this.nodeId$lzycompute() : this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public Backpressure backpressure() {
        return this.backpressure;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private DelayQueue<Job> _localJobs() {
        return this._localJobs;
    }

    private AtomicBoolean _isRunning() {
        return this._isRunning;
    }

    @Override
    @Timed
    public void submit(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("submitted job ").append(job).toString());
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            JobRow qual$1 = JobRow$.MODULE$.apply(taskJob);
            String x$1 = this.nodeId();
            long x$2 = qual$1.copy$default$1();
            JobType x$3 = qual$1.copy$default$3();
            JobStatus x$4 = qual$1.copy$default$4();
            long x$5 = qual$1.copy$default$5();
            Instant x$6 = qual$1.copy$default$6();
            Instant x$7 = qual$1.copy$default$7();
            Instant x$8 = qual$1.copy$default$8();
            String x$9 = qual$1.copy$default$9();
            Integer x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            taskJob.id_$eq(this.jobRepository().create(qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11)).id());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.localJobs().add(job);
    }

    @Override
    public void submitExisting(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("submitted existing job ").append(job).toString());
        this.cancelIf(x$1 -> x$1.id() == job.id());
        this.localJobs().add(job);
    }

    @Override
    @Timed
    public void replace(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(13).append("replaced job ").append(job).toString());
        JobRow qual$1 = JobRow$.MODULE$.apply(job);
        String x$1 = this.nodeId();
        long x$2 = qual$1.copy$default$1();
        JobType x$3 = qual$1.copy$default$3();
        JobStatus x$4 = qual$1.copy$default$4();
        long x$5 = qual$1.copy$default$5();
        Instant x$6 = qual$1.copy$default$6();
        Instant x$7 = qual$1.copy$default$7();
        Instant x$8 = qual$1.copy$default$8();
        String x$9 = qual$1.copy$default$9();
        Integer x$10 = qual$1.copy$default$10();
        String x$11 = qual$1.copy$default$11();
        job.id_$eq(this.jobRepository().replace(qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11)).id());
        this.localJobs().add(job);
    }

    @Override
    public boolean isRunning() {
        return this._isRunning().get();
    }

    public DelayQueue<Job> localJobs() {
        return this._localJobs();
    }

    @Override
    public final Job get() {
        Job job;
        block4: {
            Job job2;
            block6: {
                block5: {
                    Try try_;
                    block7: {
                        Throwable throwable;
                        Job job3;
                        while (true) {
                            if ((job3 = (Job)this.localJobs().take()) instanceof StopWorkerThread) {
                                StopWorkerThread stopWorkerThread;
                                job = stopWorkerThread = (StopWorkerThread)job3;
                                break block4;
                            }
                            this.backpressure().backpressureFn(job3);
                            if (!this.isRunning()) break block5;
                            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.lock(job3));
                            if (try_ instanceof Success) {
                                Success success = (Success)try_;
                                Job reservedJob = (Job)success.value();
                                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(7).append("giving ").append(reservedJob).toString());
                                job2 = reservedJob;
                                break block6;
                            }
                            if (!(try_ instanceof Failure)) break block7;
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            throwable = exception;
                            if (!(throwable instanceof OptimisticLockingFailureException)) break;
                            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(19).append("Unable to lock job ").append(job3).toString());
                        }
                        if (throwable == null) {
                            throw new MatchError((Object)throwable);
                        }
                        Throwable throwable2 = throwable;
                        this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                        FailJob failJob = new FailJob(job3, throwable2);
                        job2 = failJob;
                        break block6;
                    }
                    throw new MatchError((Object)try_);
                }
                throw new JobQueueStopped();
            }
            job = job2;
        }
        return job;
    }

    private Job lock(Job job) {
        job.version_$eq(job.version() + 1L);
        job.status_$eq(JobStatus.RESERVED);
        job.node_$eq(this.nodeId());
        job.startTime_$eq(Instant.now().truncatedTo(ChronoUnit.MILLIS));
        this.jobRepository().updateWithVersionCheck(JobRow$.MODULE$.apply(job));
        this.eventBus().publish((XLReleaseEvent)new BroadcastJobEvent(new JobReservedEvent(job.id())));
        return job;
    }

    @Override
    @Timed
    public void finish(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("finishing job ").append(job).toString());
        this.jobRepository().delete(new DeleteById(job.id()));
    }

    @Override
    public void start() {
        this.logger().debug((Function0 & Serializable)() -> "starting job queue");
        this._isRunning().set(true);
    }

    @Override
    public void stop() {
        this.logger().debug((Function0 & Serializable)() -> "stopping job queue");
        this._isRunning().set(false);
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.localJobs().removeIf(predicate);
    }

    @Override
    public int size() {
        return this.localJobs().size();
    }

    public DefaultJobQueue(JobRepository jobRepository, Backpressure backpressure, EventBus eventBus, ActorSystemHolder actorSystemHolder) {
        this.jobRepository = jobRepository;
        this.backpressure = backpressure;
        this.eventBus = eventBus;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        this._localJobs = new DelayQueue();
        this._isRunning = new AtomicBoolean(true);
    }
}

