/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.service;

import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.xlrelease.auth.oidc.exceptions.InternalUserExistsException;
import com.xebialabs.xlrelease.auth.oidc.policy.UserProfileCreationPolicy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class XlrOidcUserService
extends XLOidcUserService {
    private static final Logger logger = LoggerFactory.getLogger(XlrOidcUserService.class);
    private final UserProfileCreationPolicy userProfileCreationPolicy;

    public XlrOidcUserService(UserProfileCreationPolicy userProfileCreationPolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        super(claimsToGrantedAuthoritiesPolicy);
        this.userProfileCreationPolicy = userProfileCreationPolicy;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) {
        OidcUser user = super.loadUser(userRequest);
        Map oidcClaims = userRequest.getIdToken().getClaims();
        try {
            this.userProfileCreationPolicy.createProfile(user.getName(), oidcClaims);
        }
        catch (InternalUserExistsException e) {
            logger.warn("Unable to create profile for user [{}]. A local account exists.", (Object)e.getUserName());
            throw new BadCredentialsException(String.format("A local account exists for user %s", e.getUserName()), (Throwable)e);
        }
        return user;
    }
}

