/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.web.handlers;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;

public class OidcLoginFailureHandler
implements AuthenticationFailureHandler {
    private final Set<String> NON_STANDARD_OAUTH2_ERROR_CODES = Stream.of("authorization_request_not_found").collect(Collectors.toSet());

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        boolean isRedirectError;
        boolean isOAuth2Error = exception instanceof OAuth2AuthenticationException && !this.NON_STANDARD_OAUTH2_ERROR_CODES.contains(((OAuth2AuthenticationException)exception).getError().getErrorCode());
        boolean bl = isRedirectError = request.getRequestURI().contains("/oidc-login") && null == request.getQueryString();
        if (!isRedirectError && (exception instanceof BadCredentialsException || exception instanceof SessionAuthenticationException || isOAuth2Error)) {
            response.sendRedirect("login?error=" + exception.getMessage());
        } else {
            response.sendRedirect("oauth2/authorization/xl-release");
        }
    }
}

