import React from 'react';
import PropTypes from 'prop-types';

/**
 * Small version of https://github.com/react-bootstrap/react-bootstrap/blob/v0.32.4/src/MenuItem.js
 * where the parent is injecting onSelect and eventKey properties used to close the dropdown.
 */
export class PageSizeButton extends React.Component {
    static propTypes = {
        eventKey: PropTypes.any,
        onClick: PropTypes.func,
        onSelect: PropTypes.func,
        option: PropTypes.any,
    };

    handleClick = (event) => {
        const { onSelect, eventKey } = this.props;

        if (onSelect) {
            onSelect(eventKey, event);
        }
    };

    onButtonClick = (...args) => {
        this.props.onClick(args);
        this.handleClick(args);
    };

    render() {
        const { option } = this.props;
        return (
            <li key={option.text}>
                <button className="page-selector" key={option.text} onClick={this.onButtonClick}>
                    {option.text}
                </button>
            </li>
        );
    }
}
