/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;

public class ChecksResetCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "reset"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object2;
        Object object3 = commandResultsBuilder.getCommandScope();
        String string2 = ((CommandScope)object3).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksResetCommandStep.checkFileArgExistence(string2, "checks settings");
        object3 = ((CommandScope)object3).getConfiguredValue(CHECK_NAME_ARG).getValue();
        Object object4 = ChecksResetCommandStep.listAllRules();
        CheckSettingsConfigHelper checkSettingsConfigHelper = new CheckSettingsConfigHelper(string2);
        CheckSettingsConfig checkSettingsConfig = checkSettingsConfigHelper.read((List<AbstractLiquibaseRule>)object4);
        if (checkSettingsConfig == null) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        DynamicRule dynamicRule = checkSettingsConfig.getDynamicConfigurableRuleByShortName((String)object3, "has not been customized and is not a copy. It cannot be reset");
        object4 = ChecksResetCommandStep.findConfigurableParentRule(dynamicRule, object4, (String)object3, "does not have customization options");
        if (!((AbstractLiquibaseRule)object4).hasDefaultParameterValues() && !dynamicRule.isCopy()) {
            throw new CommandExecutionException("This check can not be reset because it is not a copy of a check or has no customization options.");
        }
        if (!((AbstractLiquibaseRule)object4).hasDefaultParameterValues() && dynamicRule.isCopy()) {
            throw new CommandExecutionException("This check can not be reset because the check from which it was copied does not include default values for one or more fields.  If you no longer need to run this check delete it or disable it.");
        }
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "Resetting check with short name '" + dynamicRule.getShortName() + "' to original configuration of its base check '" + ((AbstractLiquibaseRule)object4).getShortName() + "'");
        object4 = ((AbstractLiquibaseRule)object4).getParameters();
        ArrayList<DynamicRuleParameter> arrayList = new ArrayList<DynamicRuleParameter>(object4.size());
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            object2 = object5.next();
            DynamicRuleParameterEnum dynamicRuleParameterEnum = object2;
            arrayList.add(new DynamicRuleParameter(dynamicRuleParameterEnum, dynamicRuleParameterEnum.defaultValue));
        }
        object5 = new StringBuilder(System.lineSeparator() + "Current Customization Settings" + System.lineSeparator());
        for (DynamicRuleParameter object6 : dynamicRule.getParameters()) {
            ((StringBuilder)object5).append("  ");
            ((StringBuilder)object5).append(object6.getParameter().toString());
            ((StringBuilder)object5).append(" = '");
            ((StringBuilder)object5).append(object6.getValue());
            ((StringBuilder)object5).append("'");
            ((StringBuilder)object5).append(System.lineSeparator());
        }
        Scope.getCurrentScope().getUI().sendMessage(((StringBuilder)object5).toString());
        object2 = new StringBuilder("Default Settings" + System.lineSeparator());
        Iterator<DynamicRuleParameterEnum> iterator = object4.iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            ((StringBuilder)object2).append("  ");
            ((StringBuilder)object2).append(((Enum)object4).toString());
            ((StringBuilder)object2).append(" = '");
            ((StringBuilder)object2).append(((DynamicRuleParameterEnum)((Object)object4)).defaultValue);
            ((StringBuilder)object2).append("'");
            ((StringBuilder)object2).append(System.lineSeparator());
        }
        Scope.getCurrentScope().getUI().sendMessage(((StringBuilder)object2).toString());
        String string3 = Scope.getCurrentScope().getUI().prompt("Would you like to set '" + (String)object3 + "' to it's default settings? (Y/n)", "Y", (string, clazz) -> {
            if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("n")) {
                throw new IllegalArgumentException();
            }
            return string;
        }, String.class);
        if (string3 != null && string3.equalsIgnoreCase("y")) {
            dynamicRule.getParameters().clear();
            dynamicRule.getParameters().addAll(arrayList);
            checkSettingsConfigHelper.write(checkSettingsConfig);
            Scope.getCurrentScope().getUI().sendMessage("Reset complete. Review the table below to confirm your changes.");
        } else {
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to check configuration.");
        }
        ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string2, false);
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "TIP" + System.lineSeparator() + "  Test your changes by running checks against your changelog with 'liquibase checks run'" + System.lineSeparator());
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Reset the customization options for a check to defaults");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to reset").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

