/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Comparator;
import jnr.ffi.Memory;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.Env;
import org.lmdbjava.KeyVal;
import org.lmdbjava.Library;
import org.lmdbjava.LmdbException;
import org.lmdbjava.LmdbNativeException;
import org.lmdbjava.MaskedFlag;
import org.lmdbjava.ResultCodeMapper;
import org.lmdbjava.TxnFlags;

public final class Txn<T>
implements AutoCloseable {
    private final KeyVal<T> keyVal;
    private final Txn<T> parent;
    private final BufferProxy<T> proxy;
    private final Pointer ptr;
    private final boolean readOnly;
    private State state;

    Txn(Env<T> env, Txn<T> parent, BufferProxy<T> proxy, TxnFlags ... flags) {
        this.proxy = proxy;
        this.keyVal = proxy.keyVal();
        int flagsMask = MaskedFlag.mask(flags);
        this.readOnly = MaskedFlag.isSet(flagsMask, TxnFlags.MDB_RDONLY_TXN);
        if (env.isReadOnly() && !this.readOnly) {
            throw new EnvIsReadOnly();
        }
        this.parent = parent;
        if (parent != null && parent.isReadOnly() != this.readOnly) {
            throw new IncompatibleParent();
        }
        Pointer txnPtr = Memory.allocateDirect((Runtime)Library.RUNTIME, (NativeType)NativeType.ADDRESS);
        Pointer txnParentPtr = parent == null ? null : parent.ptr;
        ResultCodeMapper.checkRc(Library.LIB.mdb_txn_begin(env.pointer(), txnParentPtr, flagsMask, txnPtr));
        this.ptr = txnPtr.getPointer(0L);
        this.state = State.READY;
    }

    public void abort() {
        this.checkReady();
        this.state = State.DONE;
        Library.LIB.mdb_txn_abort(this.ptr);
    }

    @Override
    public void close() {
        if (this.state == State.RELEASED) {
            return;
        }
        if (this.state == State.READY) {
            Library.LIB.mdb_txn_abort(this.ptr);
        }
        this.keyVal.close();
        this.state = State.RELEASED;
    }

    public void commit() {
        this.checkReady();
        this.state = State.DONE;
        ResultCodeMapper.checkRc(Library.LIB.mdb_txn_commit(this.ptr));
    }

    public long getId() {
        return Library.LIB.mdb_txn_id(this.ptr);
    }

    public Txn<T> getParent() {
        return this.parent;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public T key() {
        return this.keyVal.key();
    }

    public void renew() {
        if (this.state != State.RESET) {
            throw new NotResetException();
        }
        this.state = State.DONE;
        ResultCodeMapper.checkRc(Library.LIB.mdb_txn_renew(this.ptr));
        this.state = State.READY;
    }

    public void reset() {
        this.checkReadOnly();
        if (this.state != State.READY && this.state != State.DONE) {
            throw new ResetException();
        }
        this.state = State.RESET;
        Library.LIB.mdb_txn_reset(this.ptr);
    }

    public T val() {
        return this.keyVal.val();
    }

    void checkReadOnly() {
        if (!this.readOnly) {
            throw new ReadOnlyRequiredException();
        }
    }

    void checkReady() {
        if (this.state != State.READY) {
            throw new NotReadyException();
        }
    }

    void checkWritesAllowed() {
        if (this.readOnly) {
            throw new ReadWriteRequiredException();
        }
    }

    Comparator<T> comparator() {
        return this.proxy::compare;
    }

    BufferProxy<T> getProxy() {
        return this.proxy;
    }

    State getState() {
        return this.state;
    }

    KeyVal<T> kv() {
        return this.keyVal;
    }

    KeyVal<T> newKeyVal() {
        return this.proxy.keyVal();
    }

    Pointer pointer() {
        return this.ptr;
    }

    static enum State {
        READY,
        DONE,
        RESET,
        RELEASED;

    }

    public static final class TxFullException
    extends LmdbNativeException {
        static final int MDB_TXN_FULL = -30788;
        private static final long serialVersionUID = 1L;

        TxFullException() {
            super(-30788, "Transaction has too many dirty pages");
        }
    }

    public static class ResetException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public ResetException() {
            super("Transaction has already been reset");
        }
    }

    public static class ReadWriteRequiredException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public ReadWriteRequiredException() {
            super("Not a read-write transaction");
        }
    }

    public static class ReadOnlyRequiredException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public ReadOnlyRequiredException() {
            super("Not a read-only transaction");
        }
    }

    public static class NotResetException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public NotResetException() {
            super("Transaction has not been reset");
        }
    }

    public static final class NotReadyException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public NotReadyException() {
            super("Transaction is not in ready state");
        }
    }

    public static class IncompatibleParent
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public IncompatibleParent() {
            super("Transaction incompatible with its parent transaction");
        }
    }

    public static class EnvIsReadOnly
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public EnvIsReadOnly() {
            super("Read-write Txn incompatible with read-only Env");
        }
    }

    public static final class BadReaderLockException
    extends LmdbNativeException {
        static final int MDB_BAD_RSLOT = -30783;
        private static final long serialVersionUID = 1L;

        BadReaderLockException() {
            super(-30783, "Invalid reuse of reader locktable slot");
        }
    }

    public static final class BadException
    extends LmdbNativeException {
        static final int MDB_BAD_TXN = -30782;
        private static final long serialVersionUID = 1L;

        BadException() {
            super(-30782, "Transaction must abort, has a child, or is invalid");
        }
    }
}

