/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables.reference;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.utils.Collectors;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class PropertyUsagePoint
implements UsagePoint {
    private CiProperty property;
    private VariableReference.VariableUsageType defaultType;

    public PropertyUsagePoint(CiProperty ciProperty) {
        this(ciProperty, VariableReference.VariableUsageType.DEFAULT);
    }

    public PropertyUsagePoint(CiProperty ciProperty, VariableReference.VariableUsageType defaultType) {
        this.property = ciProperty;
        this.defaultType = defaultType;
    }

    public PropertyUsagePoint(ConfigurationItem item, String property) {
        this(CiProperty.of(item, property).get());
    }

    public PropertyUsagePoint(ConfigurationItem item, String property, VariableReference.VariableUsageType defaultType) {
        this(CiProperty.of(item, property).get(), defaultType);
    }

    VariableReference.VariableUsageType getVariableUsageType(String variableName) {
        VariableReference.VariableUsageType type = this.defaultType;
        if (VariableHelper.isCiPropertyVariable(variableName)) {
            type = VariableReference.VariableUsageType.CI_PROPERTY;
        } else if (VariableHelper.isGlobalVariable(variableName)) {
            type = VariableReference.VariableUsageType.GLOBAL;
        } else if (VariableHelper.isFolderVariable(variableName)) {
            type = VariableReference.VariableUsageType.FOLDER;
        } else if (this.property.isPassword()) {
            type = VariableReference.VariableUsageType.PASSWORD;
        } else if ("output".equals(this.property.getCategory())) {
            type = VariableReference.VariableUsageType.SCRIPT_RESULT;
        } else if (this.property.getKind() == PropertyKind.STRING && !VariableHelper.containsOnlyVariable((String)this.property.getValue())) {
            type = VariableReference.VariableUsageType.DEFAULT;
        }
        return type;
    }

    @Override
    public Map<String, VariableReference.VariableUsageType> collectVariables() {
        return (Map)VariableHelper.collectVariables(this.property.getValue()).stream().collect(Collectors.toMap(Function.identity(), this::getVariableUsageType));
    }

    @Override
    public Set<ConfigurationItem> replaceVariable(Variable variable, VariableOrValue replacement) {
        this.property.replaceInValue(variable, replacement);
        return Sets.newHashSet((Object[])new ConfigurationItem[]{this.property.getParentCi()});
    }

    @Override
    public CiProperty getTargetProperty() {
        return this.property;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyUsagePoint that = (PropertyUsagePoint)o;
        return this.property.equals(that.property);
    }

    public int hashCode() {
        int result = this.property.hashCode();
        result = 31 * result + this.property.hashCode();
        return result;
    }
}

