/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.DelegateRegistry;
import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.VerificationConverter;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodVerification;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.VerificationContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalMethodDescriptor
implements MethodDescriptor {
    static final String CONTROL_TASK_DISPATCH_METHOD = "controlTaskDispatch";
    private String name;
    private String label;
    private String description;
    private String delegate;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Descriptor descriptor;
    private List<MethodVerification> verifications = new ArrayList<MethodVerification>();
    private Type parameterType;

    private LocalMethodDescriptor(Descriptor descriptor, String name) {
        this.descriptor = descriptor;
        this.name = name;
    }

    private LocalMethodDescriptor(Descriptor descriptor, Method method) {
        this.name = method.getName();
        this.delegate = "methodInvoker";
        this.descriptor = descriptor;
    }

    LocalMethodDescriptor(LocalMethodDescriptor copyOf, Descriptor newOwner) {
        this.name = copyOf.name;
        this.description = copyOf.description;
        this.label = copyOf.label;
        this.attributes = copyOf.attributes;
        this.delegate = copyOf.delegate;
        this.parameterType = copyOf.parameterType;
        this.descriptor = newOwner;
    }

    static MethodDescriptor from(Descriptor descriptor, Method method) {
        LocalMethodDescriptor methodDescriptor = new LocalMethodDescriptor(descriptor, method);
        methodDescriptor.initMetadata(method);
        LocalMethodDescriptor.initVerifications(methodDescriptor);
        return methodDescriptor;
    }

    public static MethodDescriptor from(Descriptor descriptor, MethodSpecification methodSpecification) {
        String name = methodSpecification.getName();
        LocalMethodDescriptor methodDescriptor = new LocalMethodDescriptor(descriptor, name);
        methodDescriptor.label = methodSpecification.getLabel().orElse(name);
        methodDescriptor.description = methodSpecification.getDescription().orElse("No description.");
        methodDescriptor.delegate = methodSpecification.getDelegate().orElse("dispatcherInvoker");
        Type parameterType = methodSpecification.getParameterType();
        if (parameterType != null) {
            methodDescriptor.parameterType = parameterType;
        } else if (!methodSpecification.getParameters().isEmpty()) {
            methodDescriptor.parameterType = TypeDefinitions.generatedParameterType(descriptor.getType(), name);
        }
        methodDescriptor.attributes = methodSpecification.getAttributes();
        LocalMethodDescriptor.initVerifications(methodDescriptor);
        return methodDescriptor;
    }

    private static void initVerifications(LocalMethodDescriptor methodDescriptor) {
        Method delegateMethod = (Method)OverthereUtils.checkNotNull((Object)DelegateRegistry.getDelegate(methodDescriptor.delegate), (String)(methodDescriptor.delegate + " is referenced, but not registered."), (Object[])new Object[0]);
        for (Annotation annotation : delegateMethod.getAnnotations()) {
            if (!VerificationConverter.isVerification(annotation)) continue;
            methodDescriptor.verifications.add((MethodVerification)VerificationConverter.makeVerification(annotation));
        }
    }

    private void initMetadata(Method method) {
        ControlTask annotation = method.getAnnotation(ControlTask.class);
        this.description = annotation.description();
        this.label = annotation.label().equals("") ? this.name : annotation.label();
        this.delegate = annotation.delegate();
        this.parameterType = annotation.parameterType().equals("") ? this.parameterType : Type.valueOf((String)annotation.parameterType());
    }

    void verify(final Verifications verifications) {
        verifications.verify(this.descriptor.getType(), DelegateRegistry.exists(this.delegate), "No delegate called [%s] available for control task [%s]", this.delegate, this.getFqn());
        Type superType = Type.valueOf(Parameters.class);
        verifications.verify(this.parameterType == null || this.parameterType.isSubTypeOf(superType), "The parameter type [%s] for control task [%s] should be a subtype of [%s]", this.parameterType, this.getFqn(), superType);
        for (MethodVerification verification : this.verifications) {
            verification.verify((MethodDescriptor)this, new VerificationContext(){

                public void error(String message, Object ... params) {
                    verifications.verify(LocalMethodDescriptor.this.descriptor.getType(), false, message, params);
                }
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Type getParameterObjectType() {
        return this.parameterType;
    }

    public <T> T invoke(ConfigurationItem item) {
        return this.invokeDelegate(item, null);
    }

    public <T> T invoke(ConfigurationItem item, Parameters params) {
        return this.invokeDelegate(item, params);
    }

    private <T> T invokeDelegate(ConfigurationItem item, Parameters params) {
        Method method = DelegateRegistry.getDelegate(this.delegate);
        Object o = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            Deprecations.deprecated((String)"**Deprecated** Non-static delegates are deprecated (Found while invoking [%s]).", (Object[])new Object[]{this.getFqn()});
            o = DelegateRegistry.instantiateDelegate(this.delegate);
        }
        try {
            if (method.getParameterTypes().length == 3) {
                return (T)method.invoke(o, item, this.name, this.attributes);
            }
            return (T)method.invoke(o, item, this.name, this.attributes, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + this.name + " on " + item, e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + this.name + " on " + item);
        }
    }

    public String getFqn() {
        return String.format("%s.%s", this.descriptor.getType(), this.name);
    }
}

