/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.api.v1.views.DeliveryTimeline;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/api/v1/deliveries")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PublicApi
@ShowOnlyPublicApiMembers
public interface DeliveryApi
extends ApiService {
    @Override
    default public String serviceName() {
        return "deliveryApi";
    }

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}")
    @PublicApiMember
    public Delivery getDelivery(@PathParam(value="deliveryId") String var1);

    @PUT
    @Path(value="/{deliveryId:.*Delivery[^/]*}")
    @PublicApiMember
    public Delivery updateDelivery(@PathParam(value="deliveryId") String var1, Delivery var2);

    @PublicApiMember
    public Delivery updateDelivery(Delivery var1);

    @DELETE
    @Path(value="/{deliveryId:.*Delivery[^/]*}")
    @PublicApiMember
    public void deleteDelivery(@PathParam(value="deliveryId") String var1);

    @POST
    @Path(value="search")
    @PublicApiMember
    public List<Delivery> searchDeliveries(DeliveryFilters var1, @DefaultValue(value="0") @QueryParam(value="page") Long var2, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var3, @DefaultValue(value="START_DATE") @QueryParam(value="orderBy") DeliveryOrderMode var4);

    @PublicApiMember
    public List<Delivery> searchDeliveries(DeliveryFilters var1, DeliveryOrderMode var2);

    @PublicApiMember
    public List<Delivery> searchDeliveries(DeliveryFilters var1);

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}/timeline")
    public DeliveryTimeline getDeliveryTimeline(@PathParam(value="deliveryId") String var1);

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}/releases")
    @PublicApiMember
    public List<DeliveryFlowReleaseInfo> getReleases(@PathParam(value="deliveryId") String var1);

    @PublicApiMember
    public SubscriptionResult registerSubscriber(String var1, Subscriber var2);

    @POST
    @Path(value="/{deliveryId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    public TrackedItem createTrackedItem(@PathParam(value="deliveryId") String var1, TrackedItem var2);

    @GET
    @Path(value="/{deliveryId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    public List<TrackedItem> getTrackedItems(@PathParam(value="deliveryId") String var1);

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    public TrackedItem updateTrackedItem(@PathParam(value="itemId") String var1, TrackedItem var2);

    @PublicApiMember
    public TrackedItem updateTrackedItem(TrackedItem var1);

    @DELETE
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    public void deleteTrackedItem(@PathParam(value="itemId") String var1);

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}/descope")
    @PublicApiMember
    public void descopeTrackedItem(@PathParam(value="itemId") String var1);

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}/rescope")
    @PublicApiMember
    public void rescopeTrackedItem(@PathParam(value="itemId") String var1);

    @PUT
    @Path(value="/{stageId:.*Stage[^/]*}/{itemId:.*TrackedItem[^/]*}/complete")
    @PublicApiMember
    public void completeTrackedItem(@PathParam(value="stageId") String var1, @PathParam(value="itemId") String var2);

    @PUT
    @Path(value="/{stageId:.*Stage[^/]*}/{itemId:.*TrackedItem[^/]*}/skip")
    @PublicApiMember
    public void skipTrackedItem(@PathParam(value="stageId") String var1, @PathParam(value="itemId") String var2);

    @PublicApiMember
    public void registerTrackedItems(String var1, List<String> var2, String var3);

    @PublicApiMember
    public List<TrackedItem> markTrackedItemsInStage(String var1, String var2, List<String> var3, TrackedItemStatus var4, boolean var5, String var6);

    @POST
    @Path(value="/{stageId:.*Stage[^/]*}/complete")
    @PublicApiMember
    public void completeStage(@PathParam(value="stageId") String var1);

    @POST
    @Path(value="/{stageId:.*Stage[^/]*}/reopen")
    @PublicApiMember
    public void reopenStage(@PathParam(value="stageId") String var1);

    @PUT
    @Path(value="/{transitionId:.*Transition[^/]*}")
    @PublicApiMember
    public Transition updateTransition(@PathParam(value="transitionId") String var1, Transition var2);

    @PublicApiMember
    public Transition updateTransition(Transition var1);

    @POST
    @Path(value="/{transitionId:.*Transition[^/]*}/complete")
    @PublicApiMember
    public void completeTransition(@PathParam(value="transitionId") String var1, CompleteTransition var2);
}

