import sys
import urllib
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult
from jenkins import JenkinsServer

"""
Print a nicely formatted Aborted build message
"""

def notifyBuildAborted(jobbuildnumber):
    task.setStatusLine("Aborted build #"+str(jobbuildnumber))

"""
Print a nicely formatted Aborted Build Queue message
"""

def notifyQueueAborted(queuenumber):
    task.setStatusLine("Aborted Build in Queue #"+str(queuenumber))


jenkinsURL = jenkinsServer['url']
contentType = 'application/json'
jobUrl = jenkinsURL
jobContext = '/job/' + urllib.quote(jobName) + '/'
# Jenkins instance
jenkins = JenkinsServer(jenkinsServer, username, password, apiToken)
# Do http request
request = jenkins.create_request()
headers = jenkins.create_api_token_header(request)

try:
    response = request.get(location + 'api/json', contentType=contentType, headers=headers)
    if response.isSuccessful():
        buildNumber = JsonPathResult(response.response, 'executable.number').get()
        if buildNumber:
            poststopurlcontext = jobContext + str(buildNumber)+ '/' + urllib.quote("stop");
            response = request.post(poststopurlcontext, '', contentType=contentType, headers=headers)
            if (response.isSuccessful()):
                notifyBuildAborted(buildNumber)
            else:
                print("unable to abort")
        else:
            queueId = JsonPathResult(response.response, 'id').get()
            if queueId:
                cancelStringContext='/queue/cancelItem?id='+str(queueId)
                response2 = request.post(cancelStringContext, '', contentType=contentType,headers=headers)
                if (response2.isSuccessful()):
                    notifyQueueAborted(queueId)
                else:
                    print("unable to abort")
except Exception as e:
    print("Abort build failed")
    print(e)
    sys.exit(1)
