/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class MustacheRenderer {
    private static final Logger logger = LoggerFactory.getLogger(MustacheRenderer.class);
    private final Resource templateResource;
    private final Map<String, Resource> partials;
    private final Map<String, String> context;
    private final Mustache.Compiler compiler;

    public MustacheRenderer(Resource templateResource, Map<String, Resource> partials, Map<String, String> context) {
        this.templateResource = templateResource;
        this.context = context;
        this.partials = partials;
        this.compiler = Mustache.compiler().escapeHTML(true).emptyStringIsFalse(true).defaultValue("").withLoader(this::getPartialTemplate);
    }

    protected Template createTemplate(Resource template) throws IOException {
        InputStreamReader reader = new InputStreamReader(template.getInputStream());
        return this.compiler.compile((Reader)reader);
    }

    public void render(HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        response.setContentType("text/html");
        Template template = this.createTemplate(this.templateResource);
        template.execute(this.context, (Writer)writer);
    }

    private Reader getPartialTemplate(String name) throws IOException {
        Resource partial = this.partials.get(name);
        if (partial == null) {
            logger.error("Missing partial template '{}'", (Object)name);
            return new StringReader(String.format("<missing partial template '%s'>", name));
        }
        return new InputStreamReader(partial.getInputStream());
    }
}

