/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.forms;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@PublicApiRef
public class DeliveryFilters
extends AbstractDeliveryFilters {
    private String originPatternId = "";
    private List<DeliveryStatus> statuses = new ArrayList<DeliveryStatus>();
    private static final List<DeliveryStatus> ALL_STATUSES = Arrays.stream(DeliveryStatus.values()).filter(value -> value != DeliveryStatus.TEMPLATE).collect(Collectors.toList());

    public DeliveryFilters withOriginPatternId(String originPatternId) {
        this.originPatternId = originPatternId;
        return this;
    }

    public DeliveryFilters withStatuses(DeliveryStatus ... statuses) {
        this.statuses = Arrays.asList(statuses);
        return this;
    }

    public String getOriginPatternId() {
        return this.originPatternId;
    }

    public void setOriginPatternId(String originPatternId) {
        this.originPatternId = originPatternId;
    }

    @Override
    public List<DeliveryStatus> getStatuses() {
        if (this.statuses.isEmpty()) {
            return ALL_STATUSES;
        }
        return this.statuses;
    }

    public void setStatuses(List<DeliveryStatus> statuses) {
        this.statuses = statuses;
    }
}

