from base64 import b64encode
import sys
from xlrelease.HttpRequest import HttpRequest
from com.xebialabs.xlrelease.plugin.webhook import JsonPathResult

class JenkinsServer:
    def __init__(self, jenkins_server, username, password, api_token):
        if jenkins_server is None:
            print "No server provided."
            sys.exit(1)
        self.jenkins_server = jenkins_server
        self.username = username
        self.password = password
        self.api_token = api_token

    def create_request(self):
        params = self.jenkins_server.copy()
        if params['apiToken'] and params['password']:
            print("\nYou have set both password and API Token but only one is allowed(either Password or API Token)")
            sys.exit(1)
        if params['apiToken']:
            params.pop('username')
            params.pop('password')
        if self.username and self.password and not self.api_token:
            params['username'] = self.username
            params['password'] = self.password
        return HttpRequest(params)

    # Headers for CSRF protection due to some securities improvement at Jenkins's side
    def get_headers(self, request):
        # CSRF Protection
        response = request.get('crumbIssuer/api/json')
        if response.isSuccessful():
            crumb = JsonPathResult(response.response, 'crumb').get()
            headers = {'Jenkins-Crumb': crumb}
            response_headers = response.getHeaders()
            if 'Set-Cookie' in response_headers:
                cookie = response.getHeaders()['Set-Cookie'].split(';')[0]
                headers['Cookie'] = cookie
            return headers            
        else:
            return None

    # Headers for apiToken based authentication
    def create_api_token_header(self, request):
        headers = None
        if self.api_token and self.username:
            headers = {'Authorization': 'Basic %s' % b64encode('%s:%s' % (self.username, self.api_token))}
        elif self.password and self.username or self.jenkins_server['username'] and self.jenkins_server['password']:
            headers = self.get_headers(request)
        elif self.jenkins_server['apiToken']:
            headers = {'Authorization': 'Basic %s' % b64encode('%s:%s' % (self.jenkins_server['username'], self.jenkins_server['apiToken']))}
        return headers