/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.api.clients;

import com.cyberark.conjur.api.Credentials;
import com.cyberark.conjur.api.Endpoints;
import com.cyberark.conjur.api.ResourceProvider;
import com.cyberark.conjur.api.Token;
import com.cyberark.conjur.api.clients.AuthnClient;
import com.cyberark.conjur.api.clients.AuthnTokenClient;
import com.cyberark.conjur.util.EncodeUriComponent;
import com.cyberark.conjur.util.rs.TokenAuthFilter;
import javax.net.ssl.SSLContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class ResourceClient
implements ResourceProvider {
    private WebTarget secrets;
    private final Endpoints endpoints;

    public ResourceClient(Credentials credentials, Endpoints endpoints) {
        this(credentials, endpoints, null);
    }

    public ResourceClient(Credentials credentials, Endpoints endpoints, SSLContext sslContext) {
        this.endpoints = endpoints;
        this.init(credentials, sslContext);
    }

    public ResourceClient(Token token, Endpoints endpoints) {
        this(token, endpoints, null);
    }

    public ResourceClient(Token token, Endpoints endpoints, SSLContext sslContext) {
        this.endpoints = endpoints;
        this.init(token, sslContext);
    }

    @Override
    public String retrieveSecret(String variableId) {
        Response response = (Response)this.secrets.path(this.encodeVariableId(variableId)).request().get(Response.class);
        this.validateResponse(response);
        return (String)response.readEntity(String.class);
    }

    @Override
    public void addSecret(String variableId, String secret) {
        Response response = (Response)this.secrets.path(this.encodeVariableId(variableId)).request().post(Entity.text((Object)secret), Response.class);
        this.validateResponse(response);
    }

    private String encodeVariableId(String variableId) {
        return EncodeUriComponent.encodeUriComponent(variableId).replaceAll("\\+", "%20");
    }

    private Endpoints getEndpoints() {
        return this.endpoints;
    }

    private void init(Credentials credentials, SSLContext sslContext) {
        ClientBuilder builder = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)new TokenAuthFilter(new AuthnClient(credentials, this.endpoints, sslContext)))).sslContext(sslContext);
        Client client = builder.build();
        this.secrets = client.target(this.getEndpoints().getSecretsUri());
    }

    private void init(Token token, SSLContext sslContext) {
        ClientBuilder builder = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)new TokenAuthFilter(new AuthnTokenClient(token)))).sslContext(sslContext);
        Client client = builder.build();
        this.secrets = client.target(this.getEndpoints().getSecretsUri());
    }

    private void validateResponse(Response response) {
        int status = response.getStatus();
        if (status < 200 || status >= 400) {
            String errorMessage = String.format("Error code: %d, Error message: %s", status, response.readEntity(String.class));
            throw new WebApplicationException(errorMessage, status);
        }
    }
}

