/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;

public final class JwtValidators {
    private JwtValidators() {
    }

    public static OAuth2TokenValidator<Jwt> createDefaultWithIssuer(String issuer) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(issuer));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    public static OAuth2TokenValidator<Jwt> createDefault() {
        return new DelegatingOAuth2TokenValidator(Arrays.asList(new JwtTimestampValidator()));
    }
}

