/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.LimitOffset;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.ApplicationPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.Mappers$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.EnvironmentsWithReservationsSqlBuilder$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATIONS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentReservationSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentReservationSchema$ENV_RESERVATIONS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentReservationSchema$ENV_RES_TO_APP$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENVIRONMENTS$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t}c\u0001\u0002\r\u001a\u0001!B\u0001\"\u0010\u0001\u0003\u0006\u0004%\u0019A\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u007f!AA\n\u0001BC\u0002\u0013\rQ\n\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003O\u0011!\u0019\u0007A!b\u0001\n\u0007!\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u00111\u0004!Q1A\u0005\u00025D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\tg\u0002\u0011)\u0019!C\u0001i\"A\u0001\u0010\u0001B\u0001B\u0003%Q\u000fC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\tY\r\u0001C\u0001\u0003\u001bDq!!8\u0001\t\u0003\ty\u000eC\u0004\u0003\u0002\u0001!\tAa\u0001\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0005\u0005*eN^5s_:lWM\u001c;SKN,'O^1uS>t\u0007+\u001a:tSN$XM\\2f\u0015\tQ2$A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'B\u0001\u000f\u001e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003=}\t!B]3q_NLGo\u001c:z\u0015\t\u0001\u0013%\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002#G\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003I\u0015\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0019\n1aY8n\u0007\u0001\u0019B\u0001A\u00150mA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u0004\"\u0001\r\u001b\u000e\u0003ER!A\u0007\u001a\u000b\u0005q\u0019$B\u0001\u0010\"\u0013\t)\u0014G\u0001\nQKJ\u001c\u0018n\u001d;f]\u000e,7+\u001e9q_J$\bCA\u001c<\u001b\u0005A$B\u0001\u000f:\u0015\tQ\u0014%\u0001\u0002eE&\u0011A\b\u000f\u0002\f\u0019&l\u0017\u000e^(gMN,G/\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001@!\t\u0001\u0015*D\u0001B\u0015\t\u00115)\u0001\u0003d_J,'B\u0001#F\u0003\u0011QGMY2\u000b\u0005\u0019;\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003!\u000b1a\u001c:h\u0013\tQ\u0015I\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\bI&\fG.Z2u+\u0005q\u0005CA(`\u001d\t\u0001VL\u0004\u0002R9:\u0011!k\u0017\b\u0003'js!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005];\u0013A\u0002\u001fs_>$h(C\u0001'\u0013\t!S%\u0003\u0002#G%\u0011!(I\u0005\u00039eJ!A\u0018\u001d\u0002\u0015M\u000bHNQ;jY\u0012,'/\u0003\u0002aC\n9A)[1mK\u000e$(B\u000109\u0003!!\u0017.\u00197fGR\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u0006\nqa]3sm&\u001cW-\u0003\u0002kO\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003Y)gN^5s_:lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00018\u0011\u0005=\u0004X\"A\r\n\u0005EL\"AF#om&\u0014xN\\7f]R\u0004VM]:jgR,gnY3\u0002/\u0015tg/\u001b:p]6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\u0013AF1qa2L7-\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0003U\u0004\"a\u001c<\n\u0005]L\"AF!qa2L7-\u0019;j_:\u0004VM]:jgR,gnY3\u0002/\u0005\u0004\b\u000f\\5dCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0001|))aX0!\u0007\u0002\"\u0005\r\u0012Q\u0005\t\u0003_\u0002AQ!P\u0006A\u0004}Bc!`@\u0002\u0014\u0005U\u0001\u0003BA\u0001\u0003\u001fi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0005\u0003\u0017\tqAZ1di>\u0014\u0018PC\u0002\u0002\u000e\u0015\u000bQAY3b]NLA!!\u0005\u0002\u0004\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003/\t\u0011\u0004\u001f7s%\u0016\u0004xn]5u_JL(\n\u001a2d)\u0016l\u0007\u000f\\1uK\")Aj\u0003a\u0002\u001d\":\u0011\u0011D@\u0002\u0014\u0005u\u0011EAA\u0010\u0003]AHN\u001d*fa>\u001c\u0018\u000e^8ssN\u000bH\u000eR5bY\u0016\u001cG\u000fC\u0003d\u0017\u0001\u000fQ\rC\u0003m\u0017\u0001\u0007a\u000eC\u0003t\u0017\u0001\u0007Q\u000fK\u0002\f\u0003S\u0001B!!\u0001\u0002,%!\u0011QFA\u0002\u0005%\tU\u000f^8xSJ,G-\u0001\u0004j]N,'\u000f\u001e\u000b\u0005\u0003g\ti\u0005\u0005\u0003\u00026\u0005\u001dc\u0002BA\u001c\u0003\u0007rA!!\u000f\u0002B9!\u00111HA \u001d\r\u0011\u0016QH\u0005\u0003=\u0005J!\u0001H\u001a\n\u0005i\u0011\u0014bAA#c\u0005!1)[%e\u0013\u0011\tI%a\u0013\u0003\t\rK\u0017\n\u001a\u0006\u0004\u0003\u000b\n\u0004bBA(\u0019\u0001\u0007\u0011\u0011K\u0001\fe\u0016\u001cXM\u001d<bi&|g\u000e\u0005\u0003\u0002T\u0005mSBAA+\u0015\r\u0001\u0013q\u000b\u0006\u0004\u00033\n\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002^\u0005U#AF#om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$B!a\u0019\u0002jA)!&!\u001a\u0002R%\u0019\u0011qM\u0016\u0003\r=\u0003H/[8o\u0011\u001d\tY'\u0004a\u0001\u0003g\t\u0001$\u001a8wSJ|g.\\3oiJ+7/\u001a:wCRLwN\\%e\u0003-1\u0017N\u001c3VS\u0012\u0014\u00150\u00133\u0015\t\u0005E\u0014\u0011\u0011\t\u0006U\u0005\u0015\u00141\u000f\t\u0005\u0003k\nYH\u0004\u0003\u00028\u0005]\u0014bAA=c\u00059\u0001/Y2lC\u001e,\u0017\u0002BA?\u0003\u007f\u0012QaQ5VS\u0012T1!!\u001f2\u0011\u001d\t\u0019I\u0004a\u0001\u0003g\tQB]3tKJ4\u0018\r^5p]&#\u0017AB;qI\u0006$X\r\u0006\u0003\u0002\n\u0006=\u0005c\u0001\u0016\u0002\f&\u0019\u0011QR\u0016\u0003\u000f\t{w\u000e\\3b]\"9\u0011qJ\bA\u0002\u0005E\u0013AB:fCJ\u001c\u0007\u000e\u0006\u0003\u0002\u0016\u0006m\u0006\u0003CAL\u0003?\u000b)+a+\u000f\t\u0005e\u00151\u0014\t\u0003+.J1!!(,\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011UAR\u0005\ri\u0015\r\u001d\u0006\u0004\u0003;[\u0003\u0003BA*\u0003OKA!!+\u0002V\tYQI\u001c<je>tW.\u001a8u!\u0019\ti+!.\u0002R9!\u0011qVAZ\u001d\r)\u0016\u0011W\u0005\u0002Y%\u0019\u0011\u0011P\u0016\n\t\u0005]\u0016\u0011\u0018\u0002\u0004'\u0016\f(bAA=W!9\u0011Q\u0018\tA\u0002\u0005}\u0016!E:rY^KG\u000f\u001b)be\u0006lW\r^3sgB!\u0011\u0011YAc\u001d\r\u0001\u00161Y\u0005\u0004\u0003sB\u0014\u0002BAd\u0003\u0013\u0014\u0011cU9m/&$\b\u000eU1sC6,G/\u001a:t\u0015\r\tI\bO\u0001\u0007I\u0016dW\r^3\u0015\t\u0005=\u00171\u001c\t\u0007\u0003#\f9.!#\u000e\u0005\u0005M'bAAkW\u0005!Q\u000f^5m\u0013\u0011\tI.a5\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002lE\u0001\r!a\r\u0002\r\u0015D\u0018n\u001d;t)!\tI)!9\u0002l\u0006=\bbBAr%\u0001\u0007\u0011Q]\u0001\u000eK:4\u0018N]8o[\u0016tG/\u00133\u0011\t\u0005]\u0015q]\u0005\u0005\u0003S\f\u0019K\u0001\u0004TiJLgn\u001a\u0005\b\u0003[\u0014\u0002\u0019AAs\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI\"9\u0011\u0011\u001f\nA\u0002\u0005M\u0018\u0001\u00023bi\u0016\u0004B!!>\u0002~6\u0011\u0011q\u001f\u0006\u0005\u0003+\fIP\u0003\u0002\u0002|\u0006!!.\u0019<b\u0013\u0011\ty0a>\u0003\t\u0011\u000bG/Z\u0001\u0012M&tGMT3be\u0016\u001cHoQ8nS:<G\u0003\u0003B\u0003\u0005\u000f\u0011IAa\u0003\u0011\u000b)\n)'a=\t\u000f\u0005\r8\u00031\u0001\u0002f\"9\u0011Q^\nA\u0002\u0005\u0015\bbBAy'\u0001\u0007\u00111_\u0001\u0013O\u0016$\u0018\t\u001d9mS\u000e\fG/[8o+&$7\u000f\u0006\u0003\u0003\u0012\tM\u0001\u0003CAL\u0003?\u000b\u0019$a\u001d\t\u000f\u0005=C\u00031\u0001\u0002R\u0005Y\u0012N\\:feR,eN\u001e*fgR{\u0017\t\u001d9SK\u001a,'/\u001a8dKN$bA!\u0007\u0003\"\t\u0015\u0002CBAW\u0003k\u0013Y\u0002E\u0002+\u0005;I1Aa\b,\u0005\rIe\u000e\u001e\u0005\b\u0005G)\u0002\u0019AA:\u00039\u0011Xm]3sm\u0006$\u0018n\u001c8VS\u0012DqAa\n\u0016\u0001\u0004\u0011I#A\u0004baB,\u0016\u000eZ:\u0011\r\u0005]%1FA:\u0013\u0011\u0011i#a)\u0003\u0007M+G/A\u000eva\u0012\fG/Z#omJ+7\u000fV8BaB\u0014VMZ3sK:\u001cWm\u001d\u000b\u0007\u00053\u0011\u0019D!\u000e\t\u000f\u0005=c\u00031\u0001\u0002R!9!1\u0005\fA\u0002\u0005M\u0014\u0001G:b]&$\u0018N_3SKN,'O^1uS>t\u0017J\u001c9viR!!1\bB!!\rQ#QH\u0005\u0004\u0005\u007fY#\u0001B+oSRDq!a\u0014\u0018\u0001\u0004\t\t\u0006K\u0002\u0001\u0005\u000b\u0002BAa\u0012\u0003N5\u0011!\u0011\n\u0006\u0004\u0005\u0017B\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:LAAa\u0014\u0003J\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eK\u0002\u0001\u0005'\u0002BA!\u0016\u0003\\5\u0011!q\u000b\u0006\u0004\u00053*\u0015AC:uKJ,w\u000e^=qK&!!Q\fB,\u0005)\u0011V\r]8tSR|'/\u001f")
public class EnvironmentReservationPersistence
implements PersistenceSupport,
LimitOffset {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final EnvironmentPersistence environmentPersistence;
    private final ApplicationPersistence applicationPersistence;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public String addLimitAndOffset(String query, long limitNumber, long offsetNumber) {
        return LimitOffset.addLimitAndOffset$((LimitOffset)this, (String)query, (long)limitNumber, (long)offsetNumber);
    }

    public String addLimitAndOffset(String query, Option<Object> limitNumber, Option<Object> offsetNumber) {
        return LimitOffset.addLimitAndOffset$((LimitOffset)this, (String)query, limitNumber, offsetNumber);
    }

    public Option<Object> addLimitAndOffset$default$2() {
        return LimitOffset.addLimitAndOffset$default$2$((LimitOffset)this);
    }

    public Option<Object> addLimitAndOffset$default$3() {
        return LimitOffset.addLimitAndOffset$default$3$((LimitOffset)this);
    }

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, scala.collection.immutable.Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        EnvironmentReservationPersistence environmentReservationPersistence = this;
        synchronized (environmentReservationPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public EnvironmentPersistence environmentPersistence() {
        return this.environmentPersistence;
    }

    public ApplicationPersistence applicationPersistence() {
        return this.applicationPersistence;
    }

    public String insert(EnvironmentReservation reservation) {
        this.sanitizeReservationInput(reservation);
        Integer environmentUid = (Integer)this.environmentPersistence().findUidById(reservation.getEnvironment().getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Environment [").append(reservation.getEnvironment().getId()).append("] not found").toString(), new Object[0]);
        });
        Map<String, Integer> applicationIdsToUids = this.getApplicationUids(reservation);
        String insertReservationStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(166).append("INSERT INTO ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE()).append(" (\n         |").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()).append(",\n         |").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()).append(",\n         |").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()).append(",\n         |").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()).append(",\n         |").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE()).append(")\n         |VALUES (\n         |:").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()).append(",\n         |:").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()).append(",\n         |:").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()).append(",\n         |:").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()).append(",\n         |:").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE()).append(")\n       ").toString()));
        String resId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(EnvironmentReservation.class), this.ciIdService());
        this.sqlInsert(this.pkName(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()), insertReservationStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()), (Object)resId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()), (Object)reservation.getStartDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()), (Object)reservation.getEndDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE()), (Object)reservation.getNote())})), (Function1 & Serializable)ciUid -> this.insertEnvResToAppReferences((Integer)ciUid, (scala.collection.immutable.Set<Integer>)applicationIdsToUids.valuesIterator().toSet()));
        return package$.MODULE$.toDisplayId(resId);
    }

    public Option<EnvironmentReservation> findById(String environmentReservationId) {
        Tuple2<String, Seq<Object>> tuple2 = EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply(EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).withReservationId(package$.MODULE$.toPersistedId(environmentReservationId)).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.reservationResultSetExtractor());
    }

    public Option<Integer> findUidById(String reservationId) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(47).append("|SELECT ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()).append("\n          |FROM ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE()).append("\n          |WHERE ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()).append(" = :").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()).toString()));
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(reservationId))})), (Function1 & Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()))).headOption();
    }

    public boolean update(EnvironmentReservation reservation) {
        Integer reservationUid = (Integer)this.findUidById(reservation.getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Reservation [").append(reservation.getId()).append("] not found").toString(), new Object[0]);
        });
        Integer environmentUid = (Integer)this.environmentPersistence().findUidById(reservation.getEnvironment().getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Environment [").append(reservation.getEnvironment().getId()).append("] not found").toString(), new Object[0]);
        });
        this.sanitizeReservationInput(reservation);
        this.updateEnvResToAppReferences(reservation, reservationUid);
        String updateReservationStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(149).append("\n         |UPDATE ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE()).append("\n         | SET\n         |  ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()).append(" = :").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()).append(",\n         |  ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()).append(" = :").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()).append(",\n         |  ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE()).append(" = :").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE()).append(",\n         |  ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()).append(" = :").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()).append("\n         | WHERE\n         |  ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()).append(" = :").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()).append("\n         |").toString()));
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(updateReservationStmt, this.paramMap2MapSqlParameterSource((Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()), (Object)reservation.getStartDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()), (Object)reservation.getEndDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE()), (Object)reservation.getNote()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()), (Object)reservationUid)}))), (Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 == 1));
    }

    public Map<Environment, Seq<EnvironmentReservation>> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Map)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.reservationSearchResultSetExtractor());
    }

    public Try<Object> delete(String environmentReservationId) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(66).append("\n         |DELETE FROM ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE()).append("\n         | WHERE ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()).append(" = :reservationId\n       ").toString()));
        return (Try)this.sqlExec(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reservationId"), (Object)package$.MODULE$.toPersistedId(environmentReservationId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> ps.execute()));
    }

    public boolean exists(String environmentId, String applicationId, Date date) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(401).append("\n         |SELECT 1\n         |FROM ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE()).append("\n         |WHERE ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()).append(" <= :dateToSearch\n         | AND ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()).append(" >= :dateToSearch\n         | AND ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()).append(" = (\n         |  SELECT ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append("\n         |  FROM ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE()).append("\n         |  WHERE ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()).append(" = :environmentId\n         | )\n         | AND ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()).append(" IN (\n         |  SELECT ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()).append("\n         |  FROM ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE()).append("\n         |  WHERE ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID()).append(" = (\n         |   SELECT ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n         |   FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n         |   WHERE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append(" = :applicationId\n         |  )\n         | )\n     ").toString()));
        return BoxesRunTime.unboxToBoolean((Object)this.findOne((Function0 & Serializable)() -> this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationId"), (Object)package$.MODULE$.toPersistedId(applicationId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateToSearch"), (Object)date)})), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentReservationPersistence.$anonfun$exists$2(x$4)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public Option<Date> findNearestComing(String environmentId, String applicationId, Date date) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(391).append("\n         |SELECT ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()).append("\n         |FROM ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE()).append("\n         |WHERE ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()).append(" >= :dateToSearch\n         | AND ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()).append(" = (\n         |  SELECT ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append("\n         |  FROM ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE()).append("\n         |  WHERE ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()).append(" = :environmentId\n         | )\n         | AND ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()).append(" IN (\n         |  SELECT ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()).append("\n         |  FROM ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE()).append("\n         |  WHERE ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID()).append(" = (\n         |   SELECT ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n         |   FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n         |   WHERE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append(" = :applicationId\n         |  )\n         | )\n         |ORDER BY ").append(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()).append(" ASC\n     ").toString()));
        return (Option)this.findOne((Function0 & Serializable)() -> this.sqlQuery(this.addLimitAndOffset(stmt, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), this.addLimitAndOffset$default$3()), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationId"), (Object)package$.MODULE$.toPersistedId(applicationId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateToSearch"), (Object)date)})), (Function1 & Serializable)r -> Option$.MODULE$.apply((Object)r.getTimestamp(1)))).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
    }

    private Map<String, Integer> getApplicationUids(EnvironmentReservation reservation) {
        Map<String, Integer> applicationIdsToUids;
        if (CollectionUtils.isEmpty((Collection)reservation.getApplications())) {
            return Predef$.MODULE$.Map().empty();
        }
        scala.collection.immutable.Set applicationIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(reservation.getApplications()).asScala().map((Function1 & Serializable)x$5 -> x$5.getId())).toSet();
        scala.collection.immutable.Set applicationDiff = (scala.collection.immutable.Set)applicationIds.diff((Set)(applicationIdsToUids = this.applicationPersistence().getUidsByIds((Iterable<String>)applicationIds)).keySet());
        if (applicationDiff.nonEmpty()) {
            throw new NotFoundException(new StringBuilder(25).append("Applications [").append(applicationDiff.mkString(", ")).append("] not found").toString(), new Object[0]);
        }
        return applicationIdsToUids;
    }

    private Seq<Object> insertEnvResToAppReferences(Integer reservationUid, scala.collection.immutable.Set<Integer> appUids) {
        String insertEnvResToAppStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(116).append("INSERT INTO ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE()).append(" (\n         |").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()).append(",\n         |").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID()).append("\n         |)\n         |VALUES (\n         |:").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()).append(",\n         |:").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID()).append("\n         |)\n         |").toString()));
        return this.sqlBatch(insertEnvResToAppStmt, (scala.collection.immutable.Set<Map<String, Object>>)((scala.collection.immutable.Set)appUids.map((Function1 & Serializable)appUid -> Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()), (Object)reservationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID()), appUid)})))));
    }

    private Seq<Object> updateEnvResToAppReferences(EnvironmentReservation reservation, Integer reservationUid) {
        Map<String, Integer> applicationIdsToUids = this.getApplicationUids(reservation);
        String deleteEnvResToAppRefsStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n         |DELETE FROM ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE()).append("\n         | WHERE\n         | ").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()).append(" = :").append(EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()).append("\n       ").toString()));
        this.sqlExec(deleteEnvResToAppRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()), (Object)reservationUid)})), x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.execute()));
        return this.insertEnvResToAppReferences(reservationUid, (scala.collection.immutable.Set<Integer>)applicationIdsToUids.valuesIterator().toSet());
    }

    private void sanitizeReservationInput(EnvironmentReservation reservation) {
        reservation.setNote(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(reservation.getNote()), EnvironmentReservationSchema$.MODULE$.NOTE_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$exists$2(ResultSet x$4) {
        return x$4.getInt(1) == 1;
    }

    @Autowired
    public EnvironmentReservationPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, EnvironmentPersistence environmentPersistence, ApplicationPersistence applicationPersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.environmentPersistence = environmentPersistence;
        this.applicationPersistence = applicationPersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        LimitOffset.$init$((LimitOffset)this);
    }
}

