/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.reports.audit.CommonFormat;
import com.xebialabs.xlrelease.reports.audit.CommonFormat$TaskAgent$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$EitherOps$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$MaybeOps$;
import com.xebialabs.xlrelease.reports.domain.ReleaseStartedBy;
import com.xebialabs.xlrelease.reports.domain.ReleaseTitleAndPath;
import com.xebialabs.xlrelease.reports.domain.StartedByCreateReleaseTask;
import com.xebialabs.xlrelease.reports.domain.StartedByTrigger;
import com.xebialabs.xlrelease.reports.domain.StartedByUser;
import com.xebialabs.xlrelease.reports.domain.UserThatCreatedOrStartedRelease;
import com.xebialabs.xlrelease.reports.domain.exceptions.ItemNotFoundException;
import com.xebialabs.xlrelease.reports.domain.exceptions.ItemNotFoundException$;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class CommonFormat$ {
    public static final CommonFormat$ MODULE$ = new CommonFormat$();
    private static final int MAXIMUM_CELL_LENGTH = Short.MAX_VALUE;
    private static final String ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE = "Activity log record not found";
    private static final String DATE_FORMAT = "mmmm d, yyyy hh:mm AM/PM";
    private static final int DATE_WIDTH = 30;

    public int MAXIMUM_CELL_LENGTH() {
        return MAXIMUM_CELL_LENGTH;
    }

    public String ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE() {
        return ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE;
    }

    public String DATE_FORMAT() {
        return DATE_FORMAT;
    }

    public int DATE_WIDTH() {
        return DATE_WIDTH;
    }

    public CommonFormat.TaskAgent taskAgent(String user, String team, String completedBy) {
        return CommonFormat$TaskAgent$.MODULE$.apply((Tuple2<Option<String>, Option<String>>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Option$.MODULE$.apply((Object)user)), (Object)Option$.MODULE$.apply((Object)team)), (Option<String>)Option$.MODULE$.apply((Object)completedBy));
    }

    public CommonFormat.TaskAgent taskAgent(String user, String team, String completedBy, Map<String, Try<Either<Tuple2<Throwable, String>, String>>> preResolvedProperties) {
        CommonFormat.TaskAgent qual$1 = this.taskAgent(user, team, completedBy);
        scala.collection.immutable.Map x$1 = CollectionConverters$.MODULE$.MapHasAsScala(preResolvedProperties).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Tuple2<Option<String>, Option<String>> x$2 = qual$1.copy$default$1();
        Option<String> x$3 = qual$1.copy$default$2();
        return qual$1.copy(x$2, x$3, (scala.collection.immutable.Map<String, Try<Either<Tuple2<Throwable, String>, String>>>)x$1);
    }

    public String getPlanItemTitle(Release release, PlanItem item) {
        String string;
        PlanItem planItem = item;
        if (planItem instanceof Task) {
            Task task = (Task)planItem;
            string = this.getTaskGroupTitle$1(task.getContainer(), task.getTitle());
        } else {
            string = item.getTitle();
        }
        String title = string;
        return (String)VariableHelper$.MODULE$.replaceAll((Object)title, VariableHelper$.MODULE$.filterOutBlankStringVariables(release.getAllStringVariableValues()), new HashSet(), false);
    }

    public String getTaskType(Task task) {
        Type type;
        Task task2 = task;
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            type = customScriptTask.getPythonScript().getType();
        } else {
            type = task.getType();
        }
        Type taskType = type;
        String typeLabel = taskType.getDescriptor().getLabel();
        if (Strings.isNullOrEmpty((String)typeLabel)) {
            return task.getType().getName();
        }
        return typeLabel;
    }

    public String getComments(Task task) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(task.getComments()).asScala().map((Function1 & Serializable)entry -> new StringBuilder(2).append(entry.getAuthor()).append(": ").append(entry.getText()).toString())).mkString("\n");
    }

    public String getComment(Comment comment) {
        String author = comment.getAuthor() != null ? comment.getAuthor() : "SYSTEM";
        String commentText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(14).append(author).append(" - ").append(comment.getCreationDate()).append("\n         |").append(comment.getText()).toString()));
        return commentText.substring(0, Math.min(commentText.length(), this.MAXIMUM_CELL_LENGTH()));
    }

    public String getIsDelayed(Task task) {
        if (task.getDelayedCount() > 0) {
            return "Yes";
        }
        return "No";
    }

    public Option<String> getTaskOwner(Release release, Task task) {
        return Option$.MODULE$.apply(VariableHelper$.MODULE$.replaceAll((Object)task.getOwner(), release.getAllStringVariableValues(), new HashSet(), false));
    }

    public Option<String> getTaskTeam(Task task) {
        return Option$.MODULE$.apply((Object)task.getTeam());
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatStartedByTrigger(StartedByTrigger startedByTrigger) {
        Try<Trigger> try_ = startedByTrigger.trigger();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Trigger trigger = (Trigger)success.value();
            return MaybeData$.MODULE$.success(new StringBuilder(5).append(trigger.getTitle()).append(" (").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(trigger.getType().getPrefix()))).append(": ").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(trigger.getType().getName()))).append(")").toString());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            Option<String> option = startedByTrigger.triggerTag();
            if (option instanceof Some) {
                Some some = (Some)option;
                String triggerTag = (String)some.value();
                return MaybeData$.MODULE$.partial(e, new StringBuilder(10).append("Trigger [").append(triggerTag).append("]").toString());
            }
            if (None$.MODULE$.equals(option)) {
                return MaybeData$.MODULE$.failure(e);
            }
            throw new MatchError(option);
        }
        throw new MatchError(try_);
    }

    public String formatFolderPath(Seq<String> path) {
        return ((IterableOnceOps)path.drop(1)).mkString(" / ");
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatStartedByMasterRelease(StartedByCreateReleaseTask startedByCreateReleaseTask) {
        return MaybeData$.MODULE$.recoverWith(startedByCreateReleaseTask.masterReleaseTitle(), (Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), (Object)new StringBuilder(2).append("[").append(startedByCreateReleaseTask.masterReleaseId()).append("]").toString()));
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatStartedByUser(Option<UserThatCreatedOrStartedRelease> startedBy) {
        return (Try)startedBy.map((Function1 & Serializable)u -> MaybeData$.MODULE$.apply((Function0 & Serializable)() -> (String)u.fullName().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0 & Serializable)() -> u.username()))).getOrElse((Function0 & Serializable)() -> MaybeData$.MODULE$.failure(new ItemNotFoundException(MODULE$.ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE(), ItemNotFoundException$.MODULE$.apply$default$2())));
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatStartedBy(Option<ReleaseStartedBy> startedBy) {
        return (Try)startedBy.map((Function1 & Serializable)x0$1 -> {
            ReleaseStartedBy releaseStartedBy = x0$1;
            if (releaseStartedBy instanceof StartedByUser) {
                StartedByUser startedByUser = (StartedByUser)releaseStartedBy;
                return MODULE$.formatStartedByUser(startedByUser.startedBy());
            }
            if (releaseStartedBy instanceof StartedByTrigger) {
                StartedByTrigger startedByTrigger = (StartedByTrigger)releaseStartedBy;
                return MODULE$.formatStartedByTrigger(startedByTrigger);
            }
            if (releaseStartedBy instanceof StartedByCreateReleaseTask) {
                StartedByCreateReleaseTask startedByCreateReleaseTask = (StartedByCreateReleaseTask)releaseStartedBy;
                return MODULE$.formatStartedByMasterRelease(startedByCreateReleaseTask);
            }
            throw new MatchError((Object)releaseStartedBy);
        }).getOrElse((Function0 & Serializable)() -> MaybeData$.MODULE$.success(""));
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatCreatedByUser(Option<UserThatCreatedOrStartedRelease> createdBy) {
        return (Try)createdBy.map((Function1 & Serializable)u -> MaybeData$.MODULE$.apply((Function0 & Serializable)() -> (String)u.fullName().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3)))).getOrElse((Function0 & Serializable)() -> u.username()))).getOrElse((Function0 & Serializable)() -> MaybeData$.MODULE$.failure(new ItemNotFoundException(MODULE$.ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE(), null)));
    }

    public String prettifyStatusString(String status) {
        return StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(status)).replace("_", " ");
    }

    public Try<Either<Tuple2<Throwable, String>, String>> getMaybeReleaseTitle(Try<Either<Tuple2<Throwable, Option<ReleaseTitleAndPath>>, Option<ReleaseTitleAndPath>>> templateInfo) {
        return MaybeData$MaybeOps$.MODULE$.mapValue$extension(MaybeData$.MODULE$.MaybeOps(templateInfo), (Function1 & Serializable)x$4 -> (String)x$4.map((Function1 & Serializable)x$5 -> x$5.title()).getOrElse((Function0 & Serializable)() -> ""));
    }

    public Try<Either<Tuple2<Throwable, String>, String>> getMaybeReleasePath(Try<Either<Tuple2<Throwable, Option<ReleaseTitleAndPath>>, Option<ReleaseTitleAndPath>>> templateInfo) {
        return templateInfo.flatMap((Function1 & Serializable)x$6 -> (Try)((Option)MaybeData$EitherOps$.MODULE$.getValue$extension(MaybeData$.MODULE$.EitherOps(x$6))).map((Function1 & Serializable)x$7 -> x$7.path()).getOrElse((Function0 & Serializable)() -> MaybeData$.MODULE$.success("")));
    }

    private final String getTaskGroupTitle$1(TaskContainer container, String currentTitle) {
        TaskContainer taskContainer;
        while ((taskContainer = container) instanceof TaskGroup) {
            TaskGroup taskGroup = (TaskGroup)taskContainer;
            currentTitle = new StringBuilder(3).append(taskGroup.getTitle()).append(" / ").append(currentTitle).toString();
            container = taskGroup.getContainer();
        }
        return currentTitle;
    }

    private CommonFormat$() {
    }
}

