import { all, call, put, takeLatest } from 'redux-saga/effects';
import { IHttpResponse } from 'angular';
import { deploymentTaskFacet } from './deployment-task-facet.reducer';
import { httpPOST } from '../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { WithTitleAndId } from '../../../../../../../../../core/xlr-ui/app/types';

const { loadApplications, loadEnvironments, setApplications, setEnvironments } = deploymentTaskFacet.actions;

export function* loadApplicationsSaga() {
    const { data }: IHttpResponse<Array<WithTitleAndId>> = yield call(httpPOST, 'api/v1/applications/search', {});
    yield put(setApplications(data));
}

export function* loadEnvironmentsSaga() {
    const { data }: IHttpResponse<Array<WithTitleAndId>> = yield call(httpPOST, 'api/v1/environments/search', {});
    yield put(setEnvironments(data));
}

export function* deploymentTaskFacetSaga() {
    yield all([takeLatest(loadApplications, loadApplicationsSaga), takeLatest(loadEnvironments, loadEnvironmentsSaga)]);
}
