/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.CSPFilter;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.MaintenanceModeAccessControlFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.UrlRedirectRewriteFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001\u0002\u000f\u001e\u0001!B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003D\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000bM\u0003A\u0011\u0001+\t\u000bi\u0003A\u0011I.\t\u000b\t\u0004A\u0011K2\t\u000bI\u0004A\u0011B:\t\u000bU\u0004A\u0011\u0002<\t\u000ba\u0004A\u0011B=\t\u000bm\u0004A\u0011\u0002?\t\u000by\u0004A\u0011B@\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006!9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\b\u0001\u0011%\u0011\u0011\u0003\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\tY\u0002\u0001C\u0005\u0003;Aq!!\t\u0001\t\u0013\t\u0019\u0003C\u0004\u0002(\u0001!I!!\u000b\t\u000f\u00055\u0002\u0001\"\u0003\u00020!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!a\u001d\u0001\t\u0013\t)HA\u0012SK2,\u0017m]3KKR$\u0018pU3sm2,GoV3c'\u0016\u0014h/\u001a:GC\u000e$xN]=\u000b\u0005yy\u0012!\u00026fiRL(B\u0001\u0011\"\u0003\u0019\u0019XM\u001d<fe*\u0011!eI\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001J\u0013\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0014\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u00167\u001b\u0005Y#B\u0001\u0010-\u0015\tic&\u0001\u0005f[\n,G\rZ3e\u0015\ty\u0003'A\u0002xK\nT!!\r\u001a\u0002\t\t|w\u000e\u001e\u0006\u0003gQ\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002k\u0005\u0019qN]4\n\u0005]Z#\u0001\b&fiRL8+\u001a:wY\u0016$x+\u001a2TKJ4XM\u001d$bGR|'/_\u0001\u0014g\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\\\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011QhI\u0001\tI\u0016\u0004Hn\\=ji&\u0011q\b\u0010\u0002\u0014'\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\u0015g\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\u001c\u0011\u0002\u0013ad'oQ8oM&<W#A\"\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019\u000b\u0013AB2p]\u001aLw-\u0003\u0002I\u000b\nI\u0001\f\u001c:D_:4\u0017nZ\u0001\u000bq2\u00148i\u001c8gS\u001e\u0004\u0013A\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ,\u0012\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001fr\n\u0001b]3dkJLG/_\u0005\u0003#:\u0013!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\u0006\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3sA\u00051A(\u001b8jiz\"B!V,Y3B\u0011a\u000bA\u0007\u0002;!)\u0001h\u0002a\u0001u!)\u0011i\u0002a\u0001\u0007\")!j\u0002a\u0001\u0019\u0006A\u0012n\u001d*fO&\u001cH/\u001a:EK\u001a\fW\u000f\u001c;TKJ4H.\u001a;\u0015\u0003q\u0003\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013qAQ8pY\u0016\fg.\u0001\rq_N$\bK]8dKN\u001cx+\u001a2BaB\u001cuN\u001c;fqR$\"\u0001Z4\u0011\u0005u+\u0017B\u00014_\u0005\u0011)f.\u001b;\t\u000b!L\u0001\u0019A5\u0002\u0017\r|g\u000e^3yiJ{w\u000e\u001e\t\u0003UBl\u0011a\u001b\u0006\u0003Y6\faa^3cCB\u0004(B\u0001\u0010o\u0015\tyG'A\u0004fG2L\u0007o]3\n\u0005E\\'!D,fE\u0006\u0003\boQ8oi\u0016DH/\u0001\u0006tKR,\bOS3uif$\"\u0001\u001a;\t\u000b!T\u0001\u0019A5\u0002%M,G/\u001e9M_\u001e\u0014\u0017mY6GS2$XM\u001d\u000b\u0003I^DQ\u0001[\u0006A\u0002%\f1b]3ukB\u001c\u0006O]5oOR\u0011AM\u001f\u0005\u0006Q2\u0001\r![\u0001\u000fg\u0016$X\u000f]!dG\u0016\u001c8\u000fT8h)\t!W\u0010C\u0003i\u001b\u0001\u0007\u0011.A\btKR,\boQ8sg\u001aKG\u000e^3s)\r!\u0017\u0011\u0001\u0005\u0006Q:\u0001\r![\u0001\u001eg\u0016$X\u000f\u001d-tgN+7-\u001e:jifDU-\u00193feN4\u0015\u000e\u001c;feR\u0019A-a\u0002\t\u000b!|\u0001\u0019A5\u0002\u001dM,G/\u001e9Ve24\u0015\u000e\u001c;feR\u0019A-!\u0004\t\u000b!\u0004\u0002\u0019A5\u0002'M,G/\u001e9TY><Hm\\<o\r&dG/\u001a:\u0015\u0007\u0011\f\u0019\u0002C\u0003i#\u0001\u0007\u0011.\u0001\btKR,\boQ*Q\r&dG/\u001a:\u0015\u0007\u0011\fI\u0002C\u0003i%\u0001\u0007\u0011.A\ttKR,\b/\u0012=uK:\u001c\u0018n\u001c8Ba&$2\u0001ZA\u0010\u0011\u0015A7\u00031\u0001j\u0003Q\u0019X\r^;q-\u0016\u00148/[8o\u000b:4wN]2feR\u0019A-!\n\t\u000b!$\u0002\u0019A5\u0002#M,G/\u001e9SKF,Xm\u001d;M_\u000e\fG\u000eF\u0002e\u0003WAQ\u0001[\u000bA\u0002%\fA#\u001a8bE2,'+Z:pkJ\u001cWm]\"bG\",Gc\u00013\u00022!)\u0001N\u0006a\u0001S\u0006\tRM\\1cY\u0016<%0\u001b9IC:$G.\u001a:\u0015\u0007\u0011\f9\u0004C\u0003i/\u0001\u0007\u0011.A\toK^\u001cVm]:j_:D\u0015M\u001c3mKJ,\"!!\u0010\u0011\t\u0005}\u0012qI\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u000591/Z:tS>t'B\u0001\u0011n\u0013\u0011\tI%!\u0011\u0003\u001dM+7o]5p]\"\u000bg\u000e\u001a7fe\u0006IRM\\1cY\u0016Len\u001d;sk6,g\u000e^3e\u0011\u0006tG\r\\3s)\r!\u0017q\n\u0005\u0006Qf\u0001\r![\u0001\u0012g\u0016$\bK]8qKJ$\u00180\u00134Ok2dG#\u00023\u0002V\u0005=\u0004bBA,5\u0001\u0007\u0011\u0011L\u0001\u0004W\u0016L\b\u0003BA.\u0003SrA!!\u0018\u0002fA\u0019\u0011q\f0\u000e\u0005\u0005\u0005$bAA2O\u00051AH]8pizJ1!a\u001a_\u0003\u0019\u0001&/\u001a3fM&!\u00111NA7\u0005\u0019\u0019FO]5oO*\u0019\u0011q\r0\t\u000f\u0005E$\u00041\u0001\u0002Z\u0005)a/\u00197vK\u000693/\u001a;va6\u000b\u0017N\u001c;f]\u0006t7-Z'pI\u0016\f5mY3tg\u000e{g\u000e\u001e:pY\u001aKG\u000e^3s)\r!\u0017q\u000f\u0005\u0006Qn\u0001\r!\u001b")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final PermissionEnforcer permissionEnforcer;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupCSPFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
        this.setupMaintenanceModeAccessControlFilter(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        contextRoot.setSessionHandler(this.newSessionHandler());
        contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
        if (this.xlrConfig().metrics().enabled()) {
            this.enableInstrumentedHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_gzip_enabled()) {
            this.enableGzipHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_cache_enabled() && Environment.isProduction()) {
            this.enableResourcesCache(contextRoot);
            return;
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
        contextRoot.addFilter(UrlRedirectRewriteFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        filter.setAsyncSupported(true);
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        encodingFilter.setAsyncSupported(true);
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setResourceBase(".");
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
            return;
        }
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().api_corsEnabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            holder.setAsyncSupported(true);
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        if (Environment.isDevelopment()) {
            long slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis();
            if (slowDownInMs > 0L) {
                this.logger.warn((Object)("Configuring slow down filter with " + slowDownInMs + " milliseconds."));
                FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
                slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
                slowdownFilter.setAsyncSupported(true);
                contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
                return;
            }
            return;
        }
    }

    private void setupCSPFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().server_http_csp_enabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CSPFilter());
            holder.setAsyncSupported(true);
            holder.setInitParameter("policyDirectives", this.xlrConfig().server_http_csp_policyDirectives());
            contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(AkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        if (!Environment.isDevelopment()) {
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
            return;
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setSyncFlush(true);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setCompressionLevel(this.xlrConfig().server_http_gzip_compression());
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        contextRoot.insertHandler((HandlerWrapper)gzipHandler);
    }

    private SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)("Setting up Secure Cookie Enabled to - " + this.serverConfiguration().isSecureCookieEnabled()));
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return sessionHandler;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry$.MODULE$.metricRegistry());
        contextRoot.insertHandler((HandlerWrapper)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        if (value != null) {
            if (System.getProperty(key) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting system property - " + key));
                }
                System.setProperty(key, value);
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not overriding already specified system property - " + key));
                return;
            }
            return;
        }
    }

    private void setupMaintenanceModeAccessControlFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().maintenanceModeEnabled()) {
            boolean restrictApiAccess = this.xlrConfig().maintenanceModeRestrictApiAccess();
            FilterHolder filterHolder = new FilterHolder((Filter)new MaintenanceModeAccessControlFilter(this.permissionEnforcer(), restrictApiAccess));
            contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.permissionEnforcer = permissionEnforcer;
    }
}

